/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.initialization.ISettingsFinder;
import org.gradle.initialization.ProjectSpec;
import org.gradle.initialization.ProjectSpecs;
import org.gradle.initialization.SettingsLoader;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.buildsrc.BuildSourceBuilder;
import org.gradle.util.DeprecationLogger;

public class DefaultSettingsLoader
implements SettingsLoader {
    private ISettingsFinder settingsFinder;
    private SettingsProcessor settingsProcessor;
    private BuildSourceBuilder buildSourceBuilder;

    public DefaultSettingsLoader(ISettingsFinder settingsFinder, SettingsProcessor settingsProcessor, BuildSourceBuilder buildSourceBuilder) {
        this.settingsFinder = settingsFinder;
        this.settingsProcessor = settingsProcessor;
        this.buildSourceBuilder = buildSourceBuilder;
    }

    public SettingsInternal findAndLoadSettings(GradleInternal gradle) {
        SettingsInternal settings;
        StartParameter startParameter = gradle.getStartParameter();
        ProjectSpec spec = ProjectSpecs.forStartParameter(startParameter, settings = this.findSettingsAndLoadIfAppropriate(gradle, startParameter));
        if (spec.containsProject(settings.getProjectRegistry())) {
            this.setDefaultProject(spec, settings);
            return settings;
        }
        this.deprecateWarningIfNecessary(startParameter, settings);
        StartParameter noSearchParameter = startParameter.newInstance();
        noSearchParameter.useEmptySettings();
        settings = this.findSettingsAndLoadIfAppropriate(gradle, noSearchParameter);
        if (noSearchParameter.getBuildFile() != null) {
            ProjectDescriptor rootProject = settings.getRootProject();
            rootProject.setBuildFileName(noSearchParameter.getBuildFile().getName());
        }
        this.setDefaultProject(spec, settings);
        return settings;
    }

    private void deprecateWarningIfNecessary(StartParameter startParameter, SettingsInternal settings) {
        File projectDir;
        if (startParameter.getSettingsFile() != null) {
            return;
        }
        File file = projectDir = startParameter.getProjectDir() == null ? startParameter.getCurrentDir() : startParameter.getProjectDir();
        if (settings.getSettingsDir().equals(projectDir)) {
            return;
        }
        for (ProjectDescriptor projectDescriptor : settings.getProjectRegistry().getAllProjects()) {
            if (!projectDescriptor.getProjectDir().equals(projectDir)) continue;
            return;
        }
        DeprecationLogger.nagUserWith("Support for nested build without a settings file was deprecated and will be removed in Gradle 5.0. You should create a empty settings file in " + projectDir.getAbsolutePath());
    }

    private void setDefaultProject(ProjectSpec spec, SettingsInternal settings) {
        settings.setDefaultProject(spec.selectProject(settings.getProjectRegistry()));
    }

    private SettingsInternal findSettingsAndLoadIfAppropriate(GradleInternal gradle, StartParameter startParameter) {
        SettingsLocation settingsLocation = this.findSettings(startParameter);
        StartParameter buildSrcStartParameter = startParameter.newBuild();
        buildSrcStartParameter.setCurrentDir(new File(settingsLocation.getSettingsDir(), "buildSrc"));
        ClassLoaderScope buildSourceClassLoaderScope = this.buildSourceBuilder.buildAndCreateClassLoader(buildSrcStartParameter);
        return this.settingsProcessor.process(gradle, settingsLocation, buildSourceClassLoaderScope, startParameter);
    }

    private SettingsLocation findSettings(StartParameter startParameter) {
        return this.settingsFinder.find(startParameter);
    }
}

