/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.authentication;

import org.gradle.api.credentials.Credentials;
import org.gradle.authentication.Authentication;
import org.gradle.internal.authentication.AuthenticationInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthentication
implements AuthenticationInternal {
    private final String name;
    private final Class<? extends Credentials> supportedCredentialType;
    private final Class<? extends Authentication> type;
    private Credentials credentials;

    public AbstractAuthentication(String name, Class<? extends Authentication> type) {
        this.name = name;
        this.supportedCredentialType = null;
        this.type = type;
    }

    public AbstractAuthentication(String name, Class<? extends Authentication> type, Class<? extends Credentials> supportedCredential) {
        this.name = name;
        this.supportedCredentialType = supportedCredential;
        this.type = type;
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean supports(Credentials credentials) {
        return this.supportedCredentialType.isAssignableFrom(credentials.getClass());
    }

    @Override
    public Class<? extends Authentication> getType() {
        return this.type;
    }

    public String toString() {
        return String.format("'%s'(%s)", this.getName(), this.getType().getSimpleName());
    }
}

