/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file;

import java.io.File;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.net.jcip.annotations.ThreadSafe;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class JarCache {
    private final FileHasher fileHasher;

    public JarCache(FileHasher fileHasher) {
        this.fileHasher = fileHasher;
    }

    public File getCachedJar(File original, Factory<File> baseDirFactory) {
        HashCode hashValue = this.fileHasher.hash(original);
        File baseDir = baseDirFactory.create();
        File cachedFile = new File(baseDir, hashValue.toString() + '/' + original.getName());
        if (!cachedFile.isFile()) {
            GFileUtils.copyFile(original, cachedFile);
        }
        return cachedFile;
    }
}

