/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.hub.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Condition;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.remote.internal.hub.protocol.InterHubMessage;
import org.gradle.internal.remote.internal.hub.queue.MultiEndPointQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndPointQueue
implements Dispatch<InterHubMessage> {
    private final List<InterHubMessage> queue = new ArrayList<InterHubMessage>();
    private final MultiEndPointQueue owner;
    private final Condition condition;

    public EndPointQueue(MultiEndPointQueue owner, Condition condition) {
        this.owner = owner;
        this.condition = condition;
    }

    @Override
    public void dispatch(InterHubMessage message) {
        this.queue.add(message);
        this.condition.signalAll();
    }

    public void take(Collection<InterHubMessage> drainTo) {
        if (this.queue.isEmpty()) {
            this.owner.empty(this);
            while (this.queue.isEmpty()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
        }
        drainTo.addAll(this.queue);
        this.queue.clear();
    }

    public void stop() {
        this.owner.stopped(this);
    }
}

