/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.resolve.ModuleVersionNotFoundException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;

public class DefaultBuildableComponentResolveResult
extends DefaultResourceAwareResolveResult
implements BuildableComponentResolveResult {
    private ComponentResolveMetadata metaData;
    private ModuleVersionResolveException failure;

    @Override
    public DefaultBuildableComponentResolveResult failed(ModuleVersionResolveException failure) {
        this.metaData = null;
        this.failure = failure;
        return this;
    }

    @Override
    public void notFound(ModuleComponentIdentifier versionIdentifier) {
        this.failed(new ModuleVersionNotFoundException(DefaultModuleVersionIdentifier.newId(versionIdentifier), this.getAttempted()));
    }

    @Override
    public void resolved(ComponentResolveMetadata metaData) {
        this.metaData = metaData;
    }

    @Override
    public void setMetaData(ComponentResolveMetadata metaData) {
        this.assertResolved();
        this.metaData = metaData;
    }

    @Override
    public ModuleVersionIdentifier getId() throws ModuleVersionResolveException {
        this.assertResolved();
        return this.metaData.getId();
    }

    @Override
    public ComponentResolveMetadata getMetaData() throws ModuleVersionResolveException {
        this.assertResolved();
        return this.metaData;
    }

    @Override
    public ModuleVersionResolveException getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    private void assertResolved() {
        this.assertHasResult();
        if (this.failure != null) {
            throw this.failure;
        }
    }

    private void assertHasResult() {
        if (!this.hasResult()) {
            throw new IllegalStateException("No result has been specified.");
        }
    }

    @Override
    public boolean hasResult() {
        return this.failure != null || this.metaData != null;
    }

    public void applyTo(BuildableComponentIdResolveResult idResolve) {
        super.applyTo(idResolve);
        if (this.failure != null) {
            idResolve.failed(this.failure);
        }
        if (this.metaData != null) {
            idResolve.resolved(this.metaData);
        }
    }
}

