/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.rc.plugins;

import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.nativeplatform.internal.NativeLanguageTransform;
import org.gradle.language.rc.WindowsResourceSet;
import org.gradle.language.rc.internal.DefaultWindowsResourceSet;
import org.gradle.language.rc.plugins.internal.WindowsResourcesCompileTaskConfig;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.internal.DefaultPreprocessingTool;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.TypeBuilder;

@Incubating
public class WindowsResourceScriptPlugin
implements Plugin<Project> {
    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(ComponentModelBasePlugin.class);
    }

    private static class WindowsResources
    extends NativeLanguageTransform<WindowsResourceSet> {
        private WindowsResources() {
        }

        @Override
        public Class<WindowsResourceSet> getSourceSetType() {
            return WindowsResourceSet.class;
        }

        @Override
        public Map<String, Class<?>> getBinaryTools() {
            LinkedHashMap tools = Maps.newLinkedHashMap();
            tools.put("rcCompiler", DefaultPreprocessingTool.class);
            return tools;
        }

        @Override
        public String getLanguageName() {
            return "rc";
        }

        @Override
        public SourceTransformTaskConfig getTransformTask() {
            return new WindowsResourcesCompileTaskConfig();
        }

        @Override
        public boolean applyToBinary(BinarySpec binary) {
            return binary instanceof NativeBinarySpec && this.shouldProcessResources((NativeBinarySpec)binary);
        }

        private boolean shouldProcessResources(NativeBinarySpec binary) {
            return binary.getTargetPlatform().getOperatingSystem().isWindows();
        }
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @ComponentType
        void registerLanguage(TypeBuilder<WindowsResourceSet> builder) {
            builder.defaultImplementation(DefaultWindowsResourceSet.class);
        }

        @Mutate
        void registerLanguageTransform(LanguageTransformContainer languages, ServiceRegistry serviceRegistry) {
            languages.add(new WindowsResources());
        }
    }
}

