/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.google.protobuf3jarjar.ByteString;
import com.google.protobuf3jarjar.GeneratedMessageV3;
import com.google.protobuf3jarjar.InvalidProtocolBufferException;
import com.google.protobuf3jarjar.Message;
import com.intellij.openapi.diagnostic.Logger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryStatsTable
extends DataStoreTable<MemoryStatements> {
    private static Logger getLogger() {
        return Logger.getInstance(MemoryStatsTable.class);
    }

    public MemoryStatsTable(@NotNull Map<Common.Session, Long> sesstionIdLookup) {
        if (sesstionIdLookup == null) {
            MemoryStatsTable.$$$reportNull$$$0(0);
        }
        super(sesstionIdLookup);
    }

    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            MemoryStatsTable.$$$reportNull$$$0(1);
        }
        super.initialize(connection);
        try {
            this.createTable("Memory_Samples", "Pid INTEGER NOT NULL", "Session INTEGER NOT NULL", "Timestamp INTEGER", "Type INTEGER", "Data BLOB", "PRIMARY KEY(Pid, Session, Timestamp, Type)");
            this.createTable("Memory_AllocationInfo", "Pid INTEGER NOT NULL", "Session INTEGER NOT NULL", "StartTime INTEGER", "EndTime INTEGER", "InfoData BLOB", "LegacyEventsData BLOB", "LegacyDumpData BLOB", "PRIMARY KEY(Pid, Session, StartTime)");
            this.createTable("Memory_LegacyAllocationStack", "Pid INTEGER NOT NULL", "Session INTEGER NOT NULL", "Id INTEGER", "Data BLOB", "PRIMARY KEY(Pid, Session, Id)");
            this.createTable("Memory_LegacyAllocatedClass", "Pid INTEGER NOT NULL", "Session INTEGER NOT NULL", "Id INTEGER", "Data BLOB", "PRIMARY KEY(Pid, Session, Id)");
            this.createTable("Memory_HeapDump", "Pid INTEGER NOT NULL", "Session INTEGER NOT NULL", "StartTime INTEGER", "EndTime INTEGER", "Status INTEGER", "InfoData BLOB", "DumpData BLOB", "PRIMARY KEY(Pid, Session, StartTime)");
        }
        catch (SQLException ex) {
            MemoryStatsTable.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            for (MemoryStatements statement : MemoryStatements.values()) {
                this.createStatement(statement, statement.getStatement());
            }
        }
        catch (SQLException ex) {
            MemoryStatsTable.getLogger().error((Throwable)ex);
        }
    }

    @NotNull
    public MemoryProfiler.MemoryData getData(MemoryProfiler.MemoryRequest request) {
        int pid = request.getProcessId();
        long startTime = request.getStartTime();
        long endTime = request.getEndTime();
        List<MemoryProfiler.MemoryData.MemorySample> memorySamples = this.getResultsInfo(MemoryStatements.QUERY_MEMORY, pid, request.getSession(), startTime, endTime, MemoryProfiler.MemoryData.MemorySample.getDefaultInstance());
        List<MemoryProfiler.MemoryData.AllocStatsSample> allocStatsSamples = this.getResultsInfo(MemoryStatements.QUERY_ALLOC_STATS, pid, request.getSession(), startTime, endTime, MemoryProfiler.MemoryData.AllocStatsSample.getDefaultInstance());
        List<MemoryProfiler.MemoryData.GcStatsSample> gcStatsSamples = this.getResultsInfo(MemoryStatements.QUERY_GC_STATS, pid, request.getSession(), startTime, endTime, MemoryProfiler.MemoryData.GcStatsSample.getDefaultInstance());
        List<MemoryProfiler.HeapDumpInfo> heapDumpSamples = this.getResultsInfo(MemoryStatements.QUERY_HEAP_INFO_BY_TIME, pid, request.getSession(), startTime, endTime, MemoryProfiler.HeapDumpInfo.getDefaultInstance());
        List<MemoryProfiler.AllocationsInfo> allocationSamples = this.getResultsInfo(MemoryStatements.QUERY_ALLOCATION_INFO_BY_TIME, pid, request.getSession(), startTime, endTime, MemoryProfiler.AllocationsInfo.getDefaultInstance());
        MemoryProfiler.MemoryData.Builder response = MemoryProfiler.MemoryData.newBuilder().addAllMemSamples(memorySamples).addAllAllocStatsSamples(allocStatsSamples).addAllGcStatsSamples(gcStatsSamples).addAllHeapDumpInfos(heapDumpSamples).addAllAllocationsInfo(allocationSamples);
        MemoryProfiler.MemoryData memoryData = response.build();
        if (memoryData == null) {
            MemoryStatsTable.$$$reportNull$$$0(2);
        }
        return memoryData;
    }

    public void insertMemory(int pid, Common.Session session, List<MemoryProfiler.MemoryData.MemorySample> samples) {
        for (MemoryProfiler.MemoryData.MemorySample sample : samples) {
            this.execute(MemoryStatements.INSERT_SAMPLE, pid, session, sample.getTimestamp(), MemorySamplesType.MEMORY.ordinal(), sample.toByteArray());
        }
    }

    public void insertAllocStats(int pid, Common.Session session, List<MemoryProfiler.MemoryData.AllocStatsSample> samples) {
        for (MemoryProfiler.MemoryData.AllocStatsSample sample : samples) {
            this.execute(MemoryStatements.INSERT_SAMPLE, pid, session, sample.getTimestamp(), MemorySamplesType.ALLOC_STATS.ordinal(), sample.toByteArray());
        }
    }

    public void insertGcStats(int pid, Common.Session session, List<MemoryProfiler.MemoryData.GcStatsSample> samples) {
        for (MemoryProfiler.MemoryData.GcStatsSample sample : samples) {
            this.execute(MemoryStatements.INSERT_SAMPLE, pid, session, sample.getStartTime(), MemorySamplesType.GC_STATS.ordinal(), sample.toByteArray());
        }
    }

    public void insertOrReplaceHeapInfo(int pid, Common.Session session, MemoryProfiler.HeapDumpInfo info) {
        this.execute(MemoryStatements.INSERT_OR_REPLACE_HEAP_INFO, pid, session, info.getStartTime(), info.getEndTime(), MemoryProfiler.DumpDataResponse.Status.NOT_READY.ordinal(), info.toByteArray());
    }

    public MemoryProfiler.DumpDataResponse.Status getHeapDumpStatus(int pid, Common.Session session, long dumpTime) {
        try {
            ResultSet result = this.executeQuery(MemoryStatements.QUERY_HEAP_STATUS_BY_ID, pid, session, dumpTime);
            if (result.next()) {
                return MemoryProfiler.DumpDataResponse.Status.forNumber((int)result.getInt(1));
            }
        }
        catch (SQLException ex) {
            MemoryStatsTable.getLogger().error((Throwable)ex);
        }
        return MemoryProfiler.DumpDataResponse.Status.NOT_FOUND;
    }

    public List<MemoryProfiler.HeapDumpInfo> getHeapDumpInfoByRequest(int pid, Common.Session session, MemoryProfiler.ListDumpInfosRequest request) {
        return this.getResultsInfo(MemoryStatements.QUERY_HEAP_INFO_BY_TIME, pid, session, request.getStartTime(), request.getEndTime(), MemoryProfiler.HeapDumpInfo.getDefaultInstance());
    }

    public void insertHeapDumpData(int pid, Common.Session session, long dumpTime, MemoryProfiler.DumpDataResponse.Status status, ByteString data) {
        this.execute(MemoryStatements.UPDATE_HEAP_DUMP, data.toByteArray(), status.getNumber(), pid, session, dumpTime);
    }

    @Nullable
    public byte[] getHeapDumpData(int pid, Common.Session session, long dumpTime) {
        try {
            ResultSet resultSet = this.executeQuery(MemoryStatements.QUERY_HEAP_DUMP_BY_ID, pid, session, dumpTime);
            if (resultSet.next()) {
                return resultSet.getBytes(1);
            }
        }
        catch (SQLException ex) {
            MemoryStatsTable.getLogger().error((Throwable)ex);
        }
        return null;
    }

    public void insertOrReplaceAllocationsInfo(int pid, Common.Session session, MemoryProfiler.AllocationsInfo info) {
        this.execute(MemoryStatements.INSERT_OR_REPLACE_ALLOCATIONS_INFO, pid, session, info.getStartTime(), info.getEndTime(), info.toByteArray());
    }

    /*
     * WARNING - void declaration
     */
    public void updateLegacyAllocationEvents(int pid, Common.Session session, long trackingStartTime, @NotNull MemoryProfiler.LegacyAllocationEventsResponse legacyAllocationEventsResponse) {
        void allocationData;
        if (legacyAllocationEventsResponse == null) {
            MemoryStatsTable.$$$reportNull$$$0(3);
        }
        this.execute(MemoryStatements.UPDATE_LEGACY_ALLOCATIONS_INFO_EVENTS, allocationData.toByteArray(), pid, session, trackingStartTime);
    }

    public void updateLegacyAllocationDump(int pid, Common.Session session, long trackingStartTime, byte[] data) {
        this.execute(MemoryStatements.UPDATE_LEGACY_ALLOCATIONS_INFO_DUMP, data, pid, session, trackingStartTime);
    }

    @Nullable
    public MemoryProfiler.AllocationsInfo getAllocationsInfo(int pid, Common.Session session, long trackingStartTime) {
        try {
            byte[] bytes;
            ResultSet results = this.executeQuery(MemoryStatements.QUERY_ALLOCATION_INFO_BY_ID, pid, session, trackingStartTime);
            if (results.next() && (bytes = results.getBytes(1)) != null) {
                return MemoryProfiler.AllocationsInfo.parseFrom((byte[])bytes);
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryStatsTable.getLogger().error(ex);
        }
        return null;
    }

    @Nullable
    public MemoryProfiler.LegacyAllocationEventsResponse getLegacyAllocationData(int pid, Common.Session session, long trackingStartTime) {
        try {
            byte[] bytes;
            ResultSet resultSet = this.executeQuery(MemoryStatements.QUERY_LEGACY_ALLOCATION_EVENTS_BY_ID, pid, session, trackingStartTime);
            if (resultSet.next() && (bytes = resultSet.getBytes(1)) != null) {
                return MemoryProfiler.LegacyAllocationEventsResponse.parseFrom((byte[])resultSet.getBytes(1));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryStatsTable.getLogger().error(ex);
        }
        return null;
    }

    @Nullable
    public byte[] getLegacyAllocationDumpData(int pid, Common.Session session, long trackingStartTime) {
        try {
            ResultSet resultSet = this.executeQuery(MemoryStatements.QUERY_LEGACY_ALLOCATION_DUMP_BY_ID, pid, session, trackingStartTime);
            if (resultSet.next()) {
                return resultSet.getBytes(1);
            }
        }
        catch (SQLException ex) {
            MemoryStatsTable.getLogger().error((Throwable)ex);
        }
        return null;
    }

    public void insertLegacyAllocationContext(int pid, Common.Session session, @NotNull List<MemoryProfiler.AllocatedClass> classes, @NotNull List<MemoryProfiler.AllocationStack> stacks) {
        if (classes == null) {
            MemoryStatsTable.$$$reportNull$$$0(4);
        }
        if (stacks == null) {
            MemoryStatsTable.$$$reportNull$$$0(5);
        }
        classes.forEach(klass -> this.execute(MemoryStatements.INSERT_LEGACY_ALLOCATED_CLASS, pid, session, klass.getClassId(), klass.toByteArray()));
        stacks.forEach(stack -> this.execute(MemoryStatements.INSERT_LEGACY_ALLOCATION_STACK, pid, session, stack.getStackId(), stack.toByteArray()));
    }

    @NotNull
    public MemoryProfiler.AllocationContextsResponse getLegacyAllocationContexts(@NotNull MemoryProfiler.LegacyAllocationContextsRequest request) {
        if (request == null) {
            MemoryStatsTable.$$$reportNull$$$0(6);
        }
        MemoryProfiler.AllocationContextsResponse.Builder builder = MemoryProfiler.AllocationContextsResponse.newBuilder();
        try {
            MemoryProfiler.AllocatedClass data;
            int i;
            for (i = 0; i < request.getClassIdsCount(); ++i) {
                ResultSet classResultSet = this.executeQuery(MemoryStatements.QUERY_LEGACY_ALLOCATED_CLASS, request.getProcessId(), request.getSession(), request.getClassIds(i));
                if (!classResultSet.next()) continue;
                data = ((MemoryProfiler.AllocatedClass.Builder)MemoryProfiler.AllocatedClass.newBuilder().mergeFrom(classResultSet.getBytes(1))).build();
                builder.addAllocatedClasses(data);
            }
            for (i = 0; i < request.getStackIdsCount(); ++i) {
                ResultSet stackResultSet = this.executeQuery(MemoryStatements.QUERY_LEGACY_ALLOCATION_STACK, request.getProcessId(), request.getSession(), request.getStackIds(i));
                if (!stackResultSet.next()) continue;
                data = ((MemoryProfiler.AllocationStack.Builder)MemoryProfiler.AllocationStack.newBuilder().mergeFrom(stackResultSet.getBytes(1))).build();
                builder.addAllocationStacks((MemoryProfiler.AllocationStack)data);
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryStatsTable.getLogger().error(ex);
        }
        MemoryProfiler.AllocationContextsResponse allocationContextsResponse = builder.build();
        if (allocationContextsResponse == null) {
            MemoryStatsTable.$$$reportNull$$$0(7);
        }
        return allocationContextsResponse;
    }

    private <T extends GeneratedMessageV3> List<T> getResultsInfo(MemoryStatements query, int pid, Common.Session session, long startTime, long endTime, T defaultInstance) {
        ArrayList<GeneratedMessageV3> datas = new ArrayList<GeneratedMessageV3>();
        try {
            ResultSet resultSet = this.executeQuery(query, pid, session, startTime, endTime);
            while (resultSet.next()) {
                Message data = defaultInstance.toBuilder().mergeFrom(resultSet.getBytes(1)).build();
                datas.add((GeneratedMessageV3)data);
            }
        }
        catch (InvalidProtocolBufferException | ClassCastException | SQLException ex) {
            MemoryStatsTable.getLogger().error(ex);
        }
        return datas;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sesstionIdLookup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/database/MemoryStatsTable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allocationData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacks";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/database/MemoryStatsTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLegacyAllocationContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateLegacyAllocationEvents";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insertLegacyAllocationContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLegacyAllocationContexts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum MemorySamplesType {
        MEMORY,
        ALLOC_STATS,
        GC_STATS;

    }

    public static enum MemoryStatements {
        INSERT_SAMPLE("INSERT OR IGNORE INTO Memory_Samples (Pid, Session, Timestamp, Type, Data) VALUES (?, ?, ?, ?, ?)"),
        QUERY_MEMORY(String.format("SELECT Data FROM Memory_Samples WHERE Pid = ? AND Session = ? AND Type = %d AND TimeStamp > ? AND TimeStamp <= ?", MemorySamplesType.MEMORY.ordinal())),
        QUERY_ALLOC_STATS(String.format("SELECT Data FROM Memory_Samples WHERE Pid = ? AND Session = ? AND Type = %d AND TimeStamp > ? AND TimeStamp <= ?", MemorySamplesType.ALLOC_STATS.ordinal())),
        QUERY_GC_STATS(String.format("SELECT Data FROM Memory_Samples WHERE Pid = ? AND Session = ? AND Type = %d AND TimeStamp > ? AND TimeStamp <= ?", MemorySamplesType.GC_STATS.ordinal())),
        INSERT_OR_REPLACE_HEAP_INFO("INSERT OR REPLACE INTO Memory_HeapDump (Pid, Session, StartTime, EndTime, Status, InfoData) VALUES (?, ?, ?, ?, ?, ?)"),
        UPDATE_HEAP_DUMP("UPDATE Memory_HeapDump SET DumpData = ?, Status = ? WHERE Pid = ? AND Session = ? AND StartTime = ?"),
        QUERY_HEAP_INFO_BY_TIME("SELECT InfoData FROM Memory_HeapDump where Pid = ? AND Session = ? AND EndTime > ? AND StartTime <= ?"),
        QUERY_HEAP_DUMP_BY_ID("SELECT DumpData FROM Memory_HeapDump where Pid = ? AND Session = ? AND StartTime = ?"),
        QUERY_HEAP_STATUS_BY_ID("SELECT Status FROM Memory_HeapDump where Pid = ? AND Session = ? AND StartTime = ?"),
        INSERT_OR_REPLACE_ALLOCATIONS_INFO("INSERT OR REPLACE INTO Memory_AllocationInfo (Pid, Session, StartTime, EndTime, InfoData) VALUES (?, ?, ?, ?, ?)"),
        UPDATE_LEGACY_ALLOCATIONS_INFO_EVENTS("UPDATE Memory_AllocationInfo SET LegacyEventsData = ? WHERE Pid = ? AND Session = ? AND StartTime = ?"),
        UPDATE_LEGACY_ALLOCATIONS_INFO_DUMP("UPDATE Memory_AllocationInfo SET LegacyDumpData = ? WHERE Pid = ? AND Session = ? AND StartTime = ?"),
        QUERY_ALLOCATION_INFO_BY_TIME("SELECT InfoData FROM Memory_AllocationInfo WHERE Pid = ? AND Session = ? AND EndTime > ? AND StartTime <= ?"),
        QUERY_ALLOCATION_INFO_BY_ID("SELECT InfoData from Memory_AllocationInfo WHERE Pid = ? AND Session = ? AND StartTime = ?"),
        QUERY_LEGACY_ALLOCATION_EVENTS_BY_ID("SELECT LegacyEventsData from Memory_AllocationInfo WHERE Pid = ? AND Session = ? AND StartTime = ?"),
        QUERY_LEGACY_ALLOCATION_DUMP_BY_ID("SELECT LegacyDumpData from Memory_AllocationInfo WHERE Pid = ? AND Session = ? AND StartTime = ?"),
        INSERT_LEGACY_ALLOCATION_STACK("INSERT OR IGNORE INTO Memory_LegacyAllocationStack (Pid, Session, Id, Data) VALUES (?, ?, ?, ?)"),
        INSERT_LEGACY_ALLOCATED_CLASS("INSERT OR IGNORE INTO Memory_LegacyAllocatedClass (Pid, Session, Id, Data) VALUES (?, ?, ?, ?)"),
        QUERY_LEGACY_ALLOCATION_STACK("Select Data FROM Memory_LegacyAllocationStack WHERE Pid = ? AND Session = ? AND Id = ?"),
        QUERY_LEGACY_ALLOCATED_CLASS("Select Data FROM Memory_LegacyAllocatedClass WHERE Pid = ? AND Session = ? AND Id = ?");

        @NotNull
        private final String mySqlStatement;

        private MemoryStatements(String sqlStatement) {
            if (sqlStatement == null) {
                MemoryStatements.$$$reportNull$$$0(0);
            }
            this.mySqlStatement = sqlStatement;
        }

        @NotNull
        public String getStatement() {
            String string = this.mySqlStatement;
            if (string == null) {
                MemoryStatements.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqlStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/datastore/database/MemoryStatsTable$MemoryStatements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/datastore/database/MemoryStatsTable$MemoryStatements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

