/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.datastore.database.ProfilerTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.proto.ProfilerServiceGrpc;
import io.grpc.StatusRuntimeException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ProfilerDevicePoller
extends PollRunner
implements DataStoreTable.DataStoreTableErrorCallback {
    private final ProfilerTable myTable;
    private final DataStoreService myService;
    private final ProfilerServiceGrpc.ProfilerServiceBlockingStub myPollingService;
    private final Map<Common.Session, DeviceData> myDevices = new HashMap<Common.Session, DeviceData>();

    public ProfilerDevicePoller(DataStoreService service, ProfilerTable table, ProfilerServiceGrpc.ProfilerServiceBlockingStub pollingService) {
        super(TimeUnit.SECONDS.toNanos(1L));
        this.myTable = table;
        this.myService = service;
        this.myPollingService = pollingService;
    }

    @Override
    public void onDataStoreError(Throwable t) {
        if (this.myTable.isClosed()) {
            this.disconnect();
        }
    }

    @Override
    public void poll() {
        try {
            Profiler.GetDevicesRequest devicesRequest = Profiler.GetDevicesRequest.newBuilder().build();
            Profiler.GetDevicesResponse deviceResponse = this.myPollingService.getDevices(devicesRequest);
            for (Profiler.Device device : deviceResponse.getDeviceList()) {
                this.myTable.insertOrUpdateDevice(device);
                Common.Session session = Common.Session.newBuilder().setBootId(device.getBootId()).setDeviceSerial(device.getSerial()).build();
                DeviceData deviceData = this.myDevices.computeIfAbsent(session, s -> new DeviceData(device));
                this.myService.setConnectedClients(session, this.myPollingService.getChannel());
                Profiler.GetProcessesRequest processesRequest = Profiler.GetProcessesRequest.newBuilder().setSession(session).build();
                Profiler.GetProcessesResponse processesResponse = this.myPollingService.getProcesses(processesRequest);
                HashSet<Profiler.Process> liveProcesses = new HashSet<Profiler.Process>();
                for (Profiler.Process process : processesResponse.getProcessList()) {
                    this.myTable.insertOrUpdateProcess(session, process);
                    liveProcesses.add(process);
                    deviceData.processes.remove(process);
                    Profiler.AgentStatusRequest agentStatusRequest = Profiler.AgentStatusRequest.newBuilder().setProcessId(process.getPid()).setSession(session).build();
                    Profiler.AgentStatusResponse agentStatusResponse = this.myPollingService.getAgentStatus(agentStatusRequest);
                    this.myTable.updateAgentStatus(session, process, agentStatusResponse);
                }
                this.killProcesses(session, deviceData.processes);
                deviceData.processes.clear();
                deviceData.processes.addAll(liveProcesses);
            }
        }
        catch (StatusRuntimeException ex) {
            this.disconnect();
        }
    }

    private void disconnect() {
        for (Map.Entry<Common.Session, DeviceData> entry : this.myDevices.entrySet()) {
            Common.Session session = entry.getKey();
            DeviceData activeDevice = entry.getValue();
            this.disconnectDevice(activeDevice.device);
            this.killProcesses(session, activeDevice.processes);
            this.myService.disconnect(session);
        }
        this.myDevices.clear();
    }

    private void disconnectDevice(Profiler.Device device) {
        Profiler.Device disconnectedDevice = device.toBuilder().setState(Profiler.Device.State.DISCONNECTED).build();
        this.myTable.insertOrUpdateDevice(disconnectedDevice);
    }

    private void killProcesses(Common.Session session, Set<Profiler.Process> processes) {
        for (Profiler.Process process : processes) {
            Profiler.Process updatedProcess = process.toBuilder().setState(Profiler.Process.State.DEAD).build();
            this.myTable.insertOrUpdateProcess(session, updatedProcess);
        }
    }

    private static final class DeviceData {
        public final Profiler.Device device;
        public final Set<Profiler.Process> processes = new HashSet<Profiler.Process>();

        public DeviceData(Profiler.Device device) {
            this.device = device;
        }
    }
}

