/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.AxisComponentModel;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DefaultDataSeries;
import com.android.tools.adtui.model.DefaultDurationData;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SelectionListener;
import com.android.tools.adtui.model.SelectionModel;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.UpdatableManager;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CaptureModel;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureParser;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.cpu.ThreadStateDataSeries;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.protobuf3jarjar.ByteString;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfilerStage
extends Stage
implements CodeNavigator.Listener {
    private static final SingleUnitAxisFormatter CPU_USAGE_FORMATTER = new SingleUnitAxisFormatter(1, 5, 10, "%");
    private static final SingleUnitAxisFormatter NUM_THREADS_AXIS = new SingleUnitAxisFormatter(1, 5, 1, "");
    static final ProfilingConfiguration EDIT_CONFIGURATIONS_ENTRY = new ProfilingConfiguration();
    static final ProfilingConfiguration CONFIG_SEPARATOR_ENTRY = new ProfilingConfiguration();
    private static final long INVALID_CAPTURE_START_TIME = Long.MAX_VALUE;
    private static final int O_API_LEVEL = 26;
    private static final CaptureModel.Details.Type DEFAULT_CAPTURE_DETAILS = CaptureModel.Details.Type.CALL_CHART;
    private final CpuThreadsModel myThreadsStates;
    private final AxisComponentModel myCpuUsageAxis;
    private final AxisComponentModel myThreadCountAxis;
    private final AxisComponentModel myTimeAxisGuide;
    private final DetailedCpuUsage myCpuUsage;
    private final CpuStageLegends myLegends;
    private final DurationDataModel<CpuTraceInfo> myTraceDurations;
    private final EventMonitor myEventMonitor;
    private final SelectionModel mySelectionModel;
    @NotNull
    private final DurationDataModel<DefaultDurationData> myInProgressTraceDuration;
    @NotNull
    private final DefaultDataSeries<DefaultDurationData> myInProgressTraceSeries;
    @NotNull
    private final CpuTraceDataSeries myCpuTraceDataSeries;
    private final AspectModel<CpuProfilerAspect> myAspect;
    @NotNull
    private final CaptureModel myCaptureModel;
    @NotNull
    private CaptureState myCaptureState;
    private long myCaptureStartTimeNs;
    private CaptureElapsedTimeUpdatable myCaptureElapsedTimeUpdatable;
    private ProfilingConfiguration myProfilingConfiguration;
    private List<ProfilingConfiguration> myProfilingConfigurations;
    private ProfilingConfiguration myActiveConfig;
    @NotNull
    private final UpdatableManager myUpdatableManager;
    private final CpuCaptureParser myCaptureParser;
    @Nullable
    private Tooltip myTooltip;

    public CpuProfilerStage(final @NotNull StudioProfilers profilers) {
        if (profilers == null) {
            CpuProfilerStage.$$$reportNull$$$0(0);
        }
        super(profilers);
        this.myAspect = new AspectModel();
        this.myCaptureState = CaptureState.IDLE;
        this.myCpuTraceDataSeries = new CpuTraceDataSeries();
        Range viewRange = this.getStudioProfilers().getTimeline().getViewRange();
        Range dataRange = this.getStudioProfilers().getTimeline().getDataRange();
        Range selectionRange = this.getStudioProfilers().getTimeline().getSelectionRange();
        this.myCpuUsage = new DetailedCpuUsage(profilers);
        this.myCpuUsageAxis = new AxisComponentModel(this.myCpuUsage.getCpuRange(), (BaseAxisFormatter)CPU_USAGE_FORMATTER);
        this.myCpuUsageAxis.setClampToMajorTicks(true);
        this.myThreadCountAxis = new AxisComponentModel(this.myCpuUsage.getThreadRange(), (BaseAxisFormatter)NUM_THREADS_AXIS);
        this.myThreadCountAxis.setClampToMajorTicks(true);
        this.myTimeAxisGuide = new AxisComponentModel(viewRange, (BaseAxisFormatter)TimeAxisFormatter.DEFAULT_WITHOUT_MINOR_TICKS);
        this.myTimeAxisGuide.setGlobalRange(dataRange);
        this.myLegends = new CpuStageLegends(this.myCpuUsage, dataRange);
        this.myTraceDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)this.getCpuTraceDataSeries()));
        this.myThreadsStates = new CpuThreadsModel(viewRange, this, this.getStudioProfilers().getProcessId(), this.getStudioProfilers().getSession());
        this.myInProgressTraceSeries = new DefaultDataSeries();
        this.myInProgressTraceDuration = new DurationDataModel(new RangedSeries(viewRange, this.myInProgressTraceSeries));
        this.myEventMonitor = new EventMonitor(profilers);
        this.mySelectionModel = new SelectionModel(selectionRange, viewRange);
        this.mySelectionModel.addConstraint(this.myTraceDurations);
        this.mySelectionModel.addListener(new SelectionListener(){

            public void selectionCreated() {
                profilers.getIdeServices().getFeatureTracker().trackSelectRange();
            }
        });
        this.myCaptureElapsedTimeUpdatable = new CaptureElapsedTimeUpdatable();
        this.updateProfilingState();
        this.updateProfilingConfigurations();
        this.myCaptureModel = new CaptureModel(this);
        this.myUpdatableManager = new UpdatableManager(this.getStudioProfilers().getUpdater());
        this.myCaptureParser = new CpuCaptureParser(this.getStudioProfilers().getIdeServices());
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuProfilerStage.class);
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this.mySelectionModel;
        if (selectionModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(1);
        }
        return selectionModel;
    }

    public AxisComponentModel getCpuUsageAxis() {
        return this.myCpuUsageAxis;
    }

    public AxisComponentModel getThreadCountAxis() {
        return this.myThreadCountAxis;
    }

    public AxisComponentModel getTimeAxisGuide() {
        return this.myTimeAxisGuide;
    }

    public DetailedCpuUsage getCpuUsage() {
        return this.myCpuUsage;
    }

    public CpuStageLegends getLegends() {
        return this.myLegends;
    }

    public void setTooltip(@Nullable Tooltip.Type type) {
        if (type != null && this.myTooltip != null && type.equals((Object)this.myTooltip.getType())) {
            return;
        }
        if (this.myTooltip != null) {
            this.myTooltip.dispose();
        }
        this.myTooltip = type != null ? type.build(this) : null;
        this.getAspect().changed((Enum)CpuProfilerAspect.TOOLTIP);
    }

    @Nullable
    public Tooltip getTooltip() {
        return this.myTooltip;
    }

    public DurationDataModel<CpuTraceInfo> getTraceDurations() {
        return this.myTraceDurations;
    }

    @NotNull
    public DurationDataModel<DefaultDurationData> getInProgressTraceDuration() {
        DurationDataModel<DefaultDurationData> durationDataModel = this.myInProgressTraceDuration;
        if (durationDataModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(2);
        }
        return durationDataModel;
    }

    public String getName() {
        return "CPU";
    }

    public EventMonitor getEventMonitor() {
        return this.myEventMonitor;
    }

    @Override
    public void enter() {
        this.myEventMonitor.enter();
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().register(this.myInProgressTraceDuration);
        this.getStudioProfilers().getUpdater().register(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myThreadCountAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myTimeAxisGuide);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myLegends);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myThreadsStates);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCaptureElapsedTimeUpdatable);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().addListener(this);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getClass());
        this.getStudioProfilers().addDependency(this).onChange((Enum)ProfilerAspect.DEVICES, this::updateProfilingConfigurations);
        this.getStudioProfilers().getTimeline().getSelectionRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::selectionChanged);
    }

    @Override
    public void exit() {
        this.myEventMonitor.exit();
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().unregister(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().unregister(this.myInProgressTraceDuration);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myThreadCountAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myTimeAxisGuide);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myLegends);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myThreadsStates);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCaptureElapsedTimeUpdatable);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().removeListener(this);
        this.getStudioProfilers().removeDependencies(this);
        this.getStudioProfilers().getTimeline().getSelectionRange().removeDependencies((AspectObserver)this);
        this.mySelectionModel.clearListeners();
        this.myUpdatableManager.releaseAll();
    }

    @NotNull
    public UpdatableManager getUpdatableManager() {
        UpdatableManager updatableManager = this.myUpdatableManager;
        if (updatableManager == null) {
            CpuProfilerStage.$$$reportNull$$$0(3);
        }
        return updatableManager;
    }

    public AspectModel<CpuProfilerAspect> getAspect() {
        return this.myAspect;
    }

    public void startCapturing() {
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getStudioProfilers().getClient().getCpuClient();
        CpuProfiler.CpuProfilingAppStartRequest request = CpuProfiler.CpuProfilingAppStartRequest.newBuilder().setProcessId(this.getStudioProfilers().getProcessId()).setSession(this.getStudioProfilers().getSession()).setMode(this.myProfilingConfiguration.getMode()).setProfilerType(this.myProfilingConfiguration.getProfilerType()).setBufferSizeInMb(this.myProfilingConfiguration.getProfilingBufferSizeInMb()).setSamplingIntervalUs(this.myProfilingConfiguration.getProfilingSamplingIntervalUs()).build();
        this.setCaptureState(CaptureState.STARTING);
        CompletableFuture.supplyAsync(() -> cpuService.startProfilingApp(request), this.getStudioProfilers().getIdeServices().getPoolExecutor()).thenAcceptAsync(response -> this.startCapturingCallback((CpuProfiler.CpuProfilingAppStartResponse)response, this.myProfilingConfiguration), this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    private void startCapturingCallback(CpuProfiler.CpuProfilingAppStartResponse response, ProfilingConfiguration profilingConfiguration) {
        if (response.getStatus().equals((Object)CpuProfiler.CpuProfilingAppStartResponse.Status.SUCCESS)) {
            this.setActiveConfig(profilingConfiguration.getProfilerType(), profilingConfiguration.getMode(), profilingConfiguration.getProfilingBufferSizeInMb(), profilingConfiguration.getProfilingSamplingIntervalUs());
            this.setCaptureState(CaptureState.CAPTURING);
            this.myCaptureStartTimeNs = this.currentTimeNs();
            this.myInProgressTraceSeries.clear();
            this.myInProgressTraceSeries.add(TimeUnit.NANOSECONDS.toMicros(this.myCaptureStartTimeNs), (Object)new DefaultDurationData(Long.MAX_VALUE));
            this.getStudioProfilers().getTimeline().setStreaming(true);
        } else {
            CpuProfilerStage.getLogger().warn("Unable to start tracing: " + response.getStatus());
            CpuProfilerStage.getLogger().warn(response.getErrorMessage());
            this.setCaptureState(CaptureState.IDLE);
        }
    }

    public void stopCapturing() {
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getStudioProfilers().getClient().getCpuClient();
        CpuProfiler.CpuProfilingAppStopRequest request = CpuProfiler.CpuProfilingAppStopRequest.newBuilder().setProcessId(this.getStudioProfilers().getProcessId()).setProfilerType(this.myActiveConfig.getProfilerType()).setSession(this.getStudioProfilers().getSession()).build();
        this.setCaptureState(CaptureState.STOPPING);
        this.myInProgressTraceSeries.clear();
        CompletableFuture.supplyAsync(() -> cpuService.stopProfilingApp(request), this.getStudioProfilers().getIdeServices().getPoolExecutor()).thenAcceptAsync(this::stopCapturingCallback, this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    public long getCaptureElapsedTimeUs() {
        return TimeUnit.NANOSECONDS.toMicros(this.currentTimeNs() - this.myCaptureStartTimeNs);
    }

    private void stopCapturingCallback(CpuProfiler.CpuProfilingAppStopResponse response) {
        CpuCaptureMetadata captureMetadata = new CpuCaptureMetadata(this.myActiveConfig);
        if (!response.getStatus().equals((Object)CpuProfiler.CpuProfilingAppStopResponse.Status.SUCCESS)) {
            CpuProfilerStage.getLogger().warn("Unable to stop tracing: " + response.getStatus());
            CpuProfilerStage.getLogger().warn(response.getErrorMessage());
            this.setCaptureState(CaptureState.IDLE);
            captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.STOP_CAPTURING_FAILURE);
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
        } else {
            this.setCaptureState(CaptureState.PARSING);
            ByteString traceBytes = response.getTrace();
            captureMetadata.setTraceFileSizeBytes(traceBytes.size());
            this.handleCaptureParsing(response.getTraceId(), traceBytes, captureMetadata);
        }
    }

    private void handleCaptureParsing(int traceId, ByteString traceBytes, CpuCaptureMetadata captureMetadata) {
        long beforeParsingTime = System.currentTimeMillis();
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.parse(traceId, traceBytes, this.myActiveConfig.getProfilerType());
        if (capture == null) {
            this.setCaptureState(CaptureState.IDLE);
            captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING);
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
            return;
        }
        Consumer<CpuCapture> parsingCallback = parsedCapture -> {
            this.myCaptureState = CaptureState.IDLE;
            if (parsedCapture != null) {
                this.setAndSelectCapture((CpuCapture)parsedCapture);
                this.setCaptureDetails(DEFAULT_CAPTURE_DETAILS);
                this.saveTraceInfo(traceId, (CpuCapture)parsedCapture);
                captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.SUCCESS);
                captureMetadata.setParsingTimeMs(System.currentTimeMillis() - beforeParsingTime);
                captureMetadata.setCaptureDurationMs(TimeUnit.MICROSECONDS.toMillis(parsedCapture.getDuration()));
                captureMetadata.setRecordDurationMs(CpuProfilerStage.calculateRecordDurationMs(parsedCapture));
            } else {
                captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILURE);
                this.setCapture(null);
            }
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
        };
        capture.handleAsync((parsedCapture, exception) -> {
            if (parsedCapture == null) {
                assert (exception != null);
                CpuProfilerStage.getLogger().warn("Unable to parse capture: " + exception.getMessage());
            }
            parsingCallback.accept((CpuCapture)parsedCapture);
            return parsedCapture;
        }, this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    private static long calculateRecordDurationMs(CpuCapture capture) {
        Range maxDataRange = new Range();
        for (CpuThreadInfo thread : capture.getThreads()) {
            CaptureNode threadMainNode = capture.getCaptureNode(thread.getId());
            assert (threadMainNode != null);
            maxDataRange.expand((double)threadMainNode.getStartGlobal(), (double)threadMainNode.getEndGlobal());
        }
        return TimeUnit.MICROSECONDS.toMillis((long)maxDataRange.getLength());
    }

    private void saveTraceInfo(int traceId, @NotNull CpuCapture capture) {
        if (capture == null) {
            CpuProfilerStage.$$$reportNull$$$0(4);
        }
        long captureFrom = TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMin());
        long captureTo = TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMax());
        ArrayList<CpuProfiler.Thread> threads = new ArrayList<CpuProfiler.Thread>();
        for (CpuThreadInfo thread : capture.getThreads()) {
            threads.add(CpuProfiler.Thread.newBuilder().setTid(thread.getId()).setName(thread.getName()).build());
        }
        CpuProfiler.TraceInfo traceInfo = CpuProfiler.TraceInfo.newBuilder().setTraceId(traceId).setFromTimestamp(captureFrom).setToTimestamp(captureTo).setProfilerType(this.myActiveConfig.getProfilerType()).addAllThreads(threads).build();
        CpuProfiler.SaveTraceInfoRequest request = CpuProfiler.SaveTraceInfoRequest.newBuilder().setSession(this.getStudioProfilers().getSession()).setProcessId(this.getStudioProfilers().getProcessId()).setTraceInfo(traceInfo).build();
        CpuServiceGrpc.CpuServiceBlockingStub service = this.getStudioProfilers().getClient().getCpuClient();
        service.saveTraceInfo(request);
    }

    private void updateProfilingState() {
        CpuProfiler.ProfilingStateRequest request;
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getStudioProfilers().getClient().getCpuClient();
        CpuProfiler.ProfilingStateResponse response = cpuService.checkAppProfilingState(request = CpuProfiler.ProfilingStateRequest.newBuilder().setProcessId(this.getStudioProfilers().getProcessId()).setSession(this.getStudioProfilers().getSession()).setTimestamp(this.currentTimeNs()).build());
        if (response.getBeingProfiled()) {
            long elapsedTime = response.getCheckTimestamp() - response.getStartTimestamp();
            this.myCaptureStartTimeNs = this.currentTimeNs() - elapsedTime;
            this.myCaptureState = CaptureState.CAPTURING;
            this.myInProgressTraceSeries.clear();
            this.myInProgressTraceSeries.add(TimeUnit.NANOSECONDS.toMicros(this.myCaptureStartTimeNs), (Object)new DefaultDurationData(Long.MAX_VALUE));
            CpuProfiler.CpuProfilingAppStartRequest startRequest = response.getStartRequest();
            this.setActiveConfig(startRequest.getProfilerType(), startRequest.getMode(), startRequest.getBufferSizeInMb(), startRequest.getSamplingIntervalUs());
        } else {
            this.myCaptureStartTimeNs = Long.MAX_VALUE;
            this.myCaptureState = CaptureState.IDLE;
        }
    }

    public void setActiveConfig(CpuProfiler.CpuProfilerType profilerType, CpuProfiler.CpuProfilingAppStartRequest.Mode mode, int bufferSizeLimitMb, int samplingIntervalUs) {
        String anyConfigName = "Current config";
        this.myActiveConfig = new ProfilingConfiguration(anyConfigName, profilerType, mode);
        this.myActiveConfig.setProfilingBufferSizeInMb(bufferSizeLimitMb);
        this.myActiveConfig.setProfilingSamplingIntervalUs(samplingIntervalUs);
    }

    private void selectionChanged() {
        Range range = this.getStudioProfilers().getTimeline().getSelectionRange();
        if (!range.isEmpty()) {
            this.getStudioProfilers().getTimeline().setStreaming(false);
        }
        List infoList = this.getTraceDurations().getSeries().getDataSeries().getDataForXRange(range);
        for (SeriesData info : infoList) {
            Range captureRange = ((CpuTraceInfo)info.value).getRange();
            if (captureRange.getIntersection(range).isEmpty()) continue;
            this.setCapture(((CpuTraceInfo)info.value).getTraceId());
            break;
        }
    }

    private long currentTimeNs() {
        return TimeUnit.MICROSECONDS.toNanos((long)this.getStudioProfilers().getTimeline().getDataRange().getMax()) + TimeUnit.SECONDS.toNanos(0L);
    }

    void setCapture(@Nullable CpuCapture capture) {
        this.myCaptureModel.setCapture(capture);
        this.setProfilerMode(capture == null ? ProfilerMode.NORMAL : ProfilerMode.EXPANDED);
    }

    private void setCapture(int traceId) {
        CompletableFuture<CpuCapture> future = this.getCaptureFuture(traceId);
        if (future != null) {
            future.handleAsync((capture, exception) -> {
                this.setCapture((CpuCapture)capture);
                return capture;
            }, this.getStudioProfilers().getIdeServices().getMainExecutor());
        }
    }

    public void setAndSelectCapture(int traceId) {
        CompletableFuture<CpuCapture> future = this.getCaptureFuture(traceId);
        if (future != null) {
            future.handleAsync((capture, exception) -> {
                this.setAndSelectCapture((CpuCapture)capture);
                return capture;
            }, this.getStudioProfilers().getIdeServices().getMainExecutor());
        }
    }

    public void setAndSelectCapture(@NotNull CpuCapture capture) {
        if (capture == null) {
            CpuProfilerStage.$$$reportNull$$$0(5);
        }
        ProfilerTimeline timeline = this.getStudioProfilers().getTimeline();
        boolean wasStreaming = timeline.isStreaming();
        timeline.getSelectionRange().set(capture.getRange());
        timeline.setStreaming(wasStreaming);
        this.setCapture(capture);
    }

    public int getSelectedThread() {
        return this.myCaptureModel.getThread();
    }

    public void setSelectedThread(int id) {
        this.myCaptureModel.setThread(id);
    }

    @NotNull
    public List<ClockType> getClockTypes() {
        ImmutableList immutableList = ImmutableList.of((Object)ClockType.GLOBAL, (Object)ClockType.THREAD);
        if (immutableList == null) {
            CpuProfilerStage.$$$reportNull$$$0(6);
        }
        return immutableList;
    }

    @NotNull
    public ClockType getClockType() {
        ClockType clockType = this.myCaptureModel.getClockType();
        if (clockType == null) {
            CpuProfilerStage.$$$reportNull$$$0(7);
        }
        return clockType;
    }

    public void setClockType(@NotNull ClockType clockType) {
        if (clockType == null) {
            CpuProfilerStage.$$$reportNull$$$0(8);
        }
        this.myCaptureModel.setClockType(clockType);
    }

    @Nullable
    public CpuCapture getCapture() {
        return this.myCaptureModel.getCapture();
    }

    @NotNull
    public CaptureState getCaptureState() {
        CaptureState captureState = this.myCaptureState;
        if (captureState == null) {
            CpuProfilerStage.$$$reportNull$$$0(9);
        }
        return captureState;
    }

    public void setCaptureState(@NotNull CaptureState captureState) {
        if (captureState == null) {
            CpuProfilerStage.$$$reportNull$$$0(10);
        }
        this.myCaptureState = captureState;
        this.myCaptureStartTimeNs = Long.MAX_VALUE;
        this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE);
    }

    @NotNull
    public ProfilingConfiguration getProfilingConfiguration() {
        ProfilingConfiguration profilingConfiguration = this.myProfilingConfiguration;
        if (profilingConfiguration == null) {
            CpuProfilerStage.$$$reportNull$$$0(11);
        }
        return profilingConfiguration;
    }

    public void setProfilingConfiguration(@NotNull ProfilingConfiguration mode) {
        if (mode == null) {
            CpuProfilerStage.$$$reportNull$$$0(12);
        }
        if (mode == EDIT_CONFIGURATIONS_ENTRY) {
            this.openProfilingConfigurationsDialog();
        } else if (mode != CONFIG_SEPARATOR_ENTRY) {
            this.myProfilingConfiguration = mode;
        }
        this.myAspect.changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
    }

    @NotNull
    public List<ProfilingConfiguration> getProfilingConfigurations() {
        List<ProfilingConfiguration> list = this.myProfilingConfigurations;
        if (list == null) {
            CpuProfilerStage.$$$reportNull$$$0(13);
        }
        return list;
    }

    public void openProfilingConfigurationsDialog() {
        Consumer<ProfilingConfiguration> dialogCallback = configuration -> {
            this.updateProfilingConfigurations();
            if (configuration != null) {
                this.setProfilingConfiguration((ProfilingConfiguration)configuration);
            }
        };
        Profiler.Device selectedDevice = this.getStudioProfilers().getDevice();
        boolean isDeviceAtLeastO = selectedDevice != null && selectedDevice.getFeatureLevel() >= 26;
        this.getStudioProfilers().getIdeServices().openCpuProfilingConfigurationsDialog(this.myProfilingConfiguration, isDeviceAtLeastO, dialogCallback);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackOpenProfilingConfigDialog();
    }

    public void updateProfilingConfigurations() {
        boolean selectedDeviceSupportsSimpleperf;
        this.myProfilingConfigurations = new ArrayList<ProfilingConfiguration>();
        this.myProfilingConfigurations.add(EDIT_CONFIGURATIONS_ENTRY);
        this.myProfilingConfigurations.add(CONFIG_SEPARATOR_ENTRY);
        List<ProfilingConfiguration> savedConfigs = this.getStudioProfilers().getIdeServices().getCpuProfilingConfigurations();
        List<ProfilingConfiguration> defaultConfigs = ProfilingConfiguration.getDefaultProfilingConfigurations();
        Profiler.Device selectedDevice = this.getStudioProfilers().getDevice();
        boolean bl = selectedDeviceSupportsSimpleperf = selectedDevice != null && selectedDevice.getFeatureLevel() >= 26;
        if (!selectedDeviceSupportsSimpleperf || !this.getStudioProfilers().getIdeServices().getFeatureConfig().isSimplePerfEnabled()) {
            Predicate<ProfilingConfiguration> simpleperfFilter = pref -> pref.getProfilerType() != CpuProfiler.CpuProfilerType.SIMPLE_PERF;
            savedConfigs = savedConfigs.stream().filter(simpleperfFilter).collect(Collectors.toList());
            defaultConfigs = defaultConfigs.stream().filter(simpleperfFilter).collect(Collectors.toList());
        }
        this.myProfilingConfigurations.addAll(savedConfigs);
        if (!savedConfigs.isEmpty()) {
            this.myProfilingConfigurations.add(CONFIG_SEPARATOR_ENTRY);
        }
        this.myProfilingConfigurations.addAll(defaultConfigs);
        assert (this.myProfilingConfigurations.size() > 2);
        this.myProfilingConfiguration = this.myProfilingConfigurations.get(2);
    }

    @NotNull
    public CpuTraceDataSeries getCpuTraceDataSeries() {
        CpuTraceDataSeries cpuTraceDataSeries = this.myCpuTraceDataSeries;
        if (cpuTraceDataSeries == null) {
            CpuProfilerStage.$$$reportNull$$$0(14);
        }
        return cpuTraceDataSeries;
    }

    @NotNull
    public CpuThreadsModel getThreadStates() {
        CpuThreadsModel cpuThreadsModel = this.myThreadsStates;
        if (cpuThreadsModel == null) {
            CpuProfilerStage.$$$reportNull$$$0(15);
        }
        return cpuThreadsModel;
    }

    @Nullable
    public CompletableFuture<CpuCapture> getCaptureFuture(int traceId) {
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.getCapture(traceId);
        if (capture == null) {
            CpuProfiler.GetTraceRequest request = CpuProfiler.GetTraceRequest.newBuilder().setProcessId(this.getStudioProfilers().getProcessId()).setSession(this.getStudioProfilers().getSession()).setTraceId(traceId).build();
            CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getStudioProfilers().getClient().getCpuClient();
            CpuProfiler.GetTraceResponse trace = cpuService.getTrace(request);
            if (trace.getStatus() == CpuProfiler.GetTraceResponse.Status.SUCCESS) {
                capture = this.myCaptureParser.parse(traceId, trace.getData(), trace.getProfilerType());
            }
        }
        return capture;
    }

    public void setCaptureDetails(@Nullable CaptureModel.Details.Type type) {
        this.myCaptureModel.setDetails(type);
    }

    @Nullable
    public CaptureModel.Details getCaptureDetails() {
        return this.myCaptureModel.getDetails();
    }

    @Override
    public void onNavigated(@NotNull CodeLocation location) {
        if (location == null) {
            CpuProfilerStage.$$$reportNull$$$0(16);
        }
        this.setProfilerMode(ProfilerMode.NORMAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerStage";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capture";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clockType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureState";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerStage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInProgressTraceDuration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatableManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClockTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getClockType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaptureState";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingConfiguration";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingConfigurations";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuTraceDataSeries";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveTraceInfo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setAndSelectCapture";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setClockType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setCaptureState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setProfilingConfiguration";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onNavigated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UsageTooltip
    implements Tooltip {
        @NotNull
        private final CpuProfilerStage myStage;
        @NotNull
        private final CpuStageLegends myLegends;

        UsageTooltip(@NotNull CpuProfilerStage stage) {
            if (stage == null) {
                UsageTooltip.$$$reportNull$$$0(0);
            }
            this.myStage = stage;
            this.myLegends = new CpuStageLegends(stage.getCpuUsage(), stage.getStudioProfilers().getTimeline().getTooltipRange());
            this.myStage.getStudioProfilers().getUpdater().register((Updatable)this.myLegends);
        }

        @Override
        @NotNull
        public Tooltip.Type getType() {
            Tooltip.Type type = Tooltip.Type.USAGE;
            if (type == null) {
                UsageTooltip.$$$reportNull$$$0(1);
            }
            return type;
        }

        @Override
        public void dispose() {
            this.myStage.getStudioProfilers().getUpdater().unregister((Updatable)this.myLegends);
        }

        @NotNull
        public CpuStageLegends getLegends() {
            CpuStageLegends cpuStageLegends = this.myLegends;
            if (cpuStageLegends == null) {
                UsageTooltip.$$$reportNull$$$0(2);
            }
            return cpuStageLegends;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stage";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerStage$UsageTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerStage$UsageTooltip";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLegends";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ThreadsTooltip
    extends AspectModel<Aspect>
    implements Tooltip {
        @NotNull
        private final CpuProfilerStage myStage;
        @Nullable
        private String myThreadName;
        @Nullable
        private ThreadStateDataSeries mySeries;
        @Nullable
        private ThreadState myThreadState;

        ThreadsTooltip(@NotNull CpuProfilerStage stage) {
            if (stage == null) {
                ThreadsTooltip.$$$reportNull$$$0(0);
            }
            this.myStage = stage;
            Range tooltipRange = stage.getStudioProfilers().getTimeline().getTooltipRange();
            tooltipRange.addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::updateThreadState);
        }

        private void updateThreadState() {
            this.myThreadState = null;
            if (this.mySeries == null) {
                this.changed(Aspect.THREAD_STATE);
                return;
            }
            Range tooltipRange = this.myStage.getStudioProfilers().getTimeline().getTooltipRange();
            List<SeriesData<ThreadState>> series = this.mySeries.getDataForXRange(this.myStage.getStudioProfilers().getTimeline().getViewRange());
            for (int i = 0; i < series.size(); ++i) {
                if (i + 1 != series.size() && !(tooltipRange.getMin() < (double)series.get((int)(i + 1)).x)) continue;
                this.myThreadState = (ThreadState)((Object)series.get((int)i).value);
                break;
            }
            this.changed(Aspect.THREAD_STATE);
        }

        @Override
        @NotNull
        public Tooltip.Type getType() {
            Tooltip.Type type = Tooltip.Type.THREADS;
            if (type == null) {
                ThreadsTooltip.$$$reportNull$$$0(1);
            }
            return type;
        }

        void setThread(@Nullable String threadName, @Nullable ThreadStateDataSeries stateSeries) {
            this.myThreadName = threadName;
            this.mySeries = stateSeries;
            this.updateThreadState();
        }

        @Nullable
        public String getThreadName() {
            return this.myThreadName;
        }

        @Nullable
        ThreadState getThreadState() {
            return this.myThreadState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerStage$ThreadsTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerStage$ThreadsTooltip";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static enum Aspect {
            THREAD_STATE;

        }
    }

    public static interface Tooltip {
        @NotNull
        public Type getType();

        default public void dispose() {
        }

        public static enum Type {
            USAGE(UsageTooltip::new),
            THREADS(ThreadsTooltip::new);

            @NotNull
            private final Function<CpuProfilerStage, Tooltip> myBuilder;

            private Type(Function<CpuProfilerStage, Tooltip> builder) {
                if (builder == null) {
                    Type.$$$reportNull$$$0(0);
                }
                this.myBuilder = builder;
            }

            public Tooltip build(@NotNull CpuProfilerStage stage) {
                if (stage == null) {
                    Type.$$$reportNull$$$0(1);
                }
                return this.myBuilder.apply(stage);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "stage";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerStage$Tooltip$Type";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "build";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class CpuStageLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myCpuLegend;
        @NotNull
        private final SeriesLegend myOthersLegend;
        @NotNull
        private final SeriesLegend myThreadsLegend;

        public CpuStageLegends(@NotNull DetailedCpuUsage cpuUsage, @NotNull Range dataRange) {
            if (cpuUsage == null) {
                CpuStageLegends.$$$reportNull$$$0(0);
            }
            if (dataRange == null) {
                CpuStageLegends.$$$reportNull$$$0(1);
            }
            super(100);
            this.myCpuLegend = new SeriesLegend(cpuUsage.getCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myOthersLegend = new SeriesLegend(cpuUsage.getOtherCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myThreadsLegend = new SeriesLegend(cpuUsage.getThreadsCountSeries(), (BaseAxisFormatter)NUM_THREADS_AXIS, dataRange, Interpolatable.SteppedLineInterpolator);
            this.add((Legend)this.myCpuLegend);
            this.add((Legend)this.myOthersLegend);
            this.add((Legend)this.myThreadsLegend);
        }

        @NotNull
        public SeriesLegend getCpuLegend() {
            SeriesLegend seriesLegend = this.myCpuLegend;
            if (seriesLegend == null) {
                CpuStageLegends.$$$reportNull$$$0(2);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getOthersLegend() {
            SeriesLegend seriesLegend = this.myOthersLegend;
            if (seriesLegend == null) {
                CpuStageLegends.$$$reportNull$$$0(3);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getThreadsLegend() {
            SeriesLegend seriesLegend = this.myThreadsLegend;
            if (seriesLegend == null) {
                CpuStageLegends.$$$reportNull$$$0(4);
            }
            return seriesLegend;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cpuUsage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataRange";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilerStage$CpuStageLegends";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilerStage$CpuStageLegends";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCpuLegend";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOthersLegend";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThreadsLegend";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @VisibleForTesting
    class CpuTraceDataSeries
    implements DataSeries<CpuTraceInfo> {
        CpuTraceDataSeries() {
        }

        public List<SeriesData<CpuTraceInfo>> getDataForXRange(Range xRange) {
            long rangeMin = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMin());
            long rangeMax = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMax());
            CpuServiceGrpc.CpuServiceBlockingStub cpuService = CpuProfilerStage.this.getStudioProfilers().getClient().getCpuClient();
            CpuProfiler.GetTraceInfoResponse response = cpuService.getTraceInfo(CpuProfiler.GetTraceInfoRequest.newBuilder().setProcessId(CpuProfilerStage.this.getStudioProfilers().getProcessId()).setSession(CpuProfilerStage.this.getStudioProfilers().getSession()).setFromTimestamp(rangeMin).setToTimestamp(rangeMax).build());
            ArrayList<SeriesData<CpuTraceInfo>> seriesData = new ArrayList<SeriesData<CpuTraceInfo>>();
            for (CpuProfiler.TraceInfo protoTraceInfo : response.getTraceInfoList()) {
                CpuTraceInfo info = new CpuTraceInfo(protoTraceInfo);
                seriesData.add((SeriesData<CpuTraceInfo>)new SeriesData((long)info.getRange().getMin(), (Object)info));
            }
            return seriesData;
        }
    }

    private class CaptureElapsedTimeUpdatable
    implements Updatable {
        private CaptureElapsedTimeUpdatable() {
        }

        public void update(long elapsedNs) {
            if (CpuProfilerStage.this.myCaptureState == CaptureState.CAPTURING) {
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME);
            }
        }
    }

    public static enum CaptureState {
        IDLE,
        CAPTURING,
        PARSING,
        STARTING,
        STOPPING;

    }

    public static enum ThreadState {
        RUNNING,
        RUNNING_CAPTURED,
        SLEEPING,
        SLEEPING_CAPTURED,
        DEAD,
        DEAD_CAPTURED,
        WAITING,
        WAITING_CAPTURED,
        UNKNOWN;

    }
}

