/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.memory.GcDurationData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class GcStatsDataSeries
implements DataSeries<GcDurationData> {
    @NotNull
    private MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    private final int myProcessId;
    private final Common.Session mySession;

    public GcStatsDataSeries(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, int id, Common.Session session) {
        if (client == null) {
            GcStatsDataSeries.$$$reportNull$$$0(0);
        }
        this.myClient = client;
        this.myProcessId = id;
        this.mySession = session;
    }

    public List<SeriesData<GcDurationData>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        if (timeCurrentRangeUs == null) {
            GcStatsDataSeries.$$$reportNull$$$0(1);
        }
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        MemoryProfiler.MemoryRequest.Builder dataRequestBuilder = MemoryProfiler.MemoryRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setStartTime(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin()) - bufferNs).setEndTime(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()) + bufferNs);
        MemoryProfiler.MemoryData response = this.myClient.getData(dataRequestBuilder.build());
        ArrayList<SeriesData<GcDurationData>> seriesData = new ArrayList<SeriesData<GcDurationData>>();
        for (MemoryProfiler.MemoryData.GcStatsSample sample : response.getGcStatsSamplesList()) {
            long dataTimestamp = TimeUnit.NANOSECONDS.toMicros(sample.getStartTime());
            long duration = TimeUnit.NANOSECONDS.toMicros(sample.getEndTime() - sample.getStartTime());
            seriesData.add((SeriesData<GcDurationData>)new SeriesData(dataTimestamp, (Object)new GcDurationData(duration)));
        }
        return seriesData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/memory/GcStatsDataSeries";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataForXRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

