/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ClassDb {
    public static final String JAVA_LANG_STRING = "java.lang.String";
    public static final String JAVA_LANG_CLASS = "java.lang.Class";
    private final Map<Long, Map<String, ClassEntry>> myClassEntries = new HashMap<Long, Map<String, ClassEntry>>();
    private final Map<Long, ClassEntry> myTagMap = new HashMap<Long, ClassEntry>();

    public void clear() {
        this.myClassEntries.clear();
        this.myTagMap.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ClassEntry registerClass(long classLoaderId, @NotNull String string) {
        void className;
        if (string == null) {
            ClassDb.$$$reportNull$$$0(0);
        }
        ClassEntry classEntry = this.myClassEntries.computeIfAbsent(classLoaderId, id -> new HashMap()).computeIfAbsent(className, ClassEntry::new);
        if (classEntry == null) {
            ClassDb.$$$reportNull$$$0(1);
        }
        return classEntry;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ClassEntry registerClass(long classLoaderId, @NotNull String className, long l) {
        void tag;
        if (className == null) {
            ClassDb.$$$reportNull$$$0(2);
        }
        ClassEntry entry = this.registerClass(classLoaderId, className);
        this.myTagMap.put((long)tag, entry);
        ClassEntry classEntry = entry;
        if (classEntry == null) {
            ClassDb.$$$reportNull$$$0(3);
        }
        return classEntry;
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsClassEntry(long classLoaderId, @NotNull String string) {
        void className;
        if (string == null) {
            ClassDb.$$$reportNull$$$0(4);
        }
        return this.myClassEntries.containsKey(classLoaderId) && this.myClassEntries.get(classLoaderId).containsKey(className);
    }

    @NotNull
    public ClassEntry getEntry(long tag) {
        assert (this.myTagMap.containsKey(tag));
        ClassEntry classEntry = this.myTagMap.get(tag);
        if (classEntry == null) {
            ClassDb.$$$reportNull$$$0(5);
        }
        return classEntry;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/ClassDb";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/ClassDb";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "registerClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerClass";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsClassEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ClassEntry {
        @NotNull
        private final String myClassName;
        @NotNull
        private final String myPackageName;
        @NotNull
        private final String mySimpleClassName;
        @NotNull
        private final String[] mySplitPackageName;

        public ClassEntry(@NotNull String className) {
            if (className == null) {
                ClassEntry.$$$reportNull$$$0(0);
            }
            this.myClassName = className;
            int lastIndexOfDot = this.myClassName.lastIndexOf(46);
            this.myPackageName = lastIndexOfDot > 0 ? this.myClassName.substring(0, lastIndexOfDot) : "";
            this.mySimpleClassName = this.myClassName.substring(lastIndexOfDot + 1);
            this.mySplitPackageName = this.myPackageName.isEmpty() ? new String[]{} : this.myPackageName.split("\\.");
        }

        @NotNull
        public String getClassName() {
            String string = this.myClassName;
            if (string == null) {
                ClassEntry.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getPackageName() {
            String string = this.myPackageName;
            if (string == null) {
                ClassEntry.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String[] getSplitPackageName() {
            if (this.mySplitPackageName == null) {
                ClassEntry.$$$reportNull$$$0(3);
            }
            return this.mySplitPackageName;
        }

        @NotNull
        public String getSimpleClassName() {
            String string = this.mySimpleClassName;
            if (string == null) {
                ClassEntry.$$$reportNull$$$0(4);
            }
            return string;
        }

        public int hashCode() {
            return this.myClassName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ClassEntry && this.myClassName.equals(((ClassEntry)obj).myClassName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/memory/adapters/ClassDb$ClassEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/memory/adapters/ClassDb$ClassEntry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPackageName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSplitPackageName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimpleClassName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

