/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.StackFrame;
import com.android.tools.perflib.heap.Type;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profilers.memory.adapters.ArrayObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.HeapDumpCaptureObject;
import com.android.tools.profilers.memory.adapters.HeapDumpFieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ReferenceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HeapDumpInstanceObject
implements InstanceObject {
    private static final String NAME_FORMATTER = "%s@%d (0x%x)";
    private static final int MAX_VALUE_TEXT_LENGTH = 1024;
    private static final Comparator<Instance> DEPTH_COMPARATOR = Comparator.comparingInt(Instance::getDistanceToGcRoot);
    private static final String INVALID_STRING_VALUE = " ...<invalid string value>...";
    private static final Map<Type, ValueObject.ValueType> VALUE_TYPE_MAP = ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)ValueObject.ValueType.BOOLEAN).put((Object)Type.BYTE, (Object)ValueObject.ValueType.BYTE).put((Object)Type.CHAR, (Object)ValueObject.ValueType.CHAR).put((Object)Type.SHORT, (Object)ValueObject.ValueType.SHORT).put((Object)Type.INT, (Object)ValueObject.ValueType.INT).put((Object)Type.LONG, (Object)ValueObject.ValueType.LONG).put((Object)Type.FLOAT, (Object)ValueObject.ValueType.FLOAT).put((Object)Type.DOUBLE, (Object)ValueObject.ValueType.DOUBLE).put((Object)Type.OBJECT, (Object)ValueObject.ValueType.OBJECT).build();
    @NotNull
    protected ValueObject.ValueType myValueType;
    @NotNull
    private final HeapDumpCaptureObject myCaptureObject;
    @Nullable
    private final InstanceObject myClassInstanceObject;
    @NotNull
    private final Instance myInstance;
    @NotNull
    private final ClassDb.ClassEntry myClassEntry;
    @NotNull
    private final String myMemoizedLabel;

    public HeapDumpInstanceObject(@NotNull HeapDumpCaptureObject captureObject, @Nullable InstanceObject classInstanceObject, @NotNull Instance instance, @NotNull ClassDb.ClassEntry classEntry, @Nullable ValueObject.ValueType precomputedValueType) {
        if (captureObject == null) {
            HeapDumpInstanceObject.$$$reportNull$$$0(0);
        }
        if (instance == null) {
            HeapDumpInstanceObject.$$$reportNull$$$0(1);
        }
        if (classEntry == null) {
            HeapDumpInstanceObject.$$$reportNull$$$0(2);
        }
        this.myCaptureObject = captureObject;
        this.myClassInstanceObject = classInstanceObject;
        this.myInstance = instance;
        this.myClassEntry = classEntry;
        this.myMemoizedLabel = String.format(NAME_FORMATTER, this.myClassEntry.getSimpleClassName(), this.myInstance.getUniqueId(), this.myInstance.getUniqueId());
        if (precomputedValueType != null) {
            this.myValueType = precomputedValueType;
            return;
        }
        ClassObj classObj = instance.getClassObj();
        this.myValueType = instance instanceof ClassObj ? ValueObject.ValueType.CLASS : (instance instanceof ClassInstance && classObj.getClassName().equals("java.lang.String") ? ValueObject.ValueType.STRING : (classObj.getClassName().endsWith("[]") ? ValueObject.ValueType.ARRAY : ValueObject.ValueType.OBJECT));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HeapDumpInstanceObject)) {
            return false;
        }
        HeapDumpInstanceObject otherInstance = (HeapDumpInstanceObject)obj;
        return this.myInstance == otherInstance.myInstance;
    }

    public int hashCode() {
        return this.myInstance.hashCode();
    }

    @Override
    @NotNull
    public String getName() {
        if ("" == null) {
            HeapDumpInstanceObject.$$$reportNull$$$0(3);
        }
        return "";
    }

    @Override
    @NotNull
    public String getValueText() {
        String string = this.myMemoizedLabel;
        if (string == null) {
            HeapDumpInstanceObject.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getToStringText() {
        if (this.myValueType == ValueObject.ValueType.STRING) {
            char[] stringChars = ((ClassInstance)this.myInstance).getStringChars(1024);
            if (stringChars != null) {
                int charLength = stringChars.length;
                StringBuilder builder = new StringBuilder(6 + charLength);
                builder.append("\"");
                if (charLength == 1024) {
                    builder.append(stringChars, 0, charLength - 1).append("...");
                } else {
                    builder.append(stringChars);
                }
                builder.append("\"");
                String string = builder.toString();
                if (string == null) {
                    HeapDumpInstanceObject.$$$reportNull$$$0(5);
                }
                return string;
            }
            if (INVALID_STRING_VALUE == null) {
                HeapDumpInstanceObject.$$$reportNull$$$0(6);
            }
            return INVALID_STRING_VALUE;
        }
        if ("" == null) {
            HeapDumpInstanceObject.$$$reportNull$$$0(7);
        }
        return "";
    }

    @Override
    public int getHeapId() {
        return this.myInstance.getHeap().getId();
    }

    @Override
    @NotNull
    public ClassDb.ClassEntry getClassEntry() {
        ClassDb.ClassEntry classEntry = this.myClassEntry;
        if (classEntry == null) {
            HeapDumpInstanceObject.$$$reportNull$$$0(8);
        }
        return classEntry;
    }

    @Override
    @Nullable
    public InstanceObject getClassObject() {
        return this.myClassInstanceObject;
    }

    @Override
    public int getDepth() {
        return this.myInstance.getDistanceToGcRoot();
    }

    @Override
    public long getNativeSize() {
        return this.myInstance.getNativeSize();
    }

    @Override
    public int getShallowSize() {
        return this.myInstance.getSize();
    }

    @Override
    public long getRetainedSize() {
        return this.myInstance.getTotalRetainedSize();
    }

    @Override
    public int getFieldCount() {
        if (this.myInstance instanceof ClassInstance) {
            ClassInstance classInstance = (ClassInstance)this.myInstance;
            return classInstance.getValues().size();
        }
        if (this.myInstance instanceof ArrayInstance) {
            ArrayInstance arrayInstance = (ArrayInstance)this.myInstance;
            return arrayInstance.getLength();
        }
        if (this.myInstance instanceof ClassObj) {
            ClassObj classObj = (ClassObj)this.myInstance;
            return classObj.getStaticFieldValues().size();
        }
        return 0;
    }

    @Override
    @NotNull
    public List<FieldObject> getFields() {
        ArrayList<FieldObject> fields = new ArrayList<FieldObject>();
        if (this.myInstance instanceof ClassInstance) {
            ClassInstance classInstance = (ClassInstance)this.myInstance;
            for (ClassInstance.FieldValue field : classInstance.getValues()) {
                fields.add(new HeapDumpFieldObject(this.myCaptureObject, this.myInstance, field));
            }
        } else if (this.myInstance instanceof ArrayInstance) {
            ArrayInstance arrayInstance = (ArrayInstance)this.myInstance;
            Type arrayType = arrayInstance.getArrayType();
            int arrayIndex = 0;
            for (Object value : arrayInstance.getValues()) {
                ClassInstance.FieldValue field = new ClassInstance.FieldValue(new Field(arrayType, Integer.toString(arrayIndex)), value);
                fields.add(new HeapDumpFieldObject(this.myCaptureObject, this.myInstance, field));
                ++arrayIndex;
            }
        } else if (this.myInstance instanceof ClassObj) {
            ClassObj classObj = (ClassObj)this.myInstance;
            for (Map.Entry entry : classObj.getStaticFieldValues().entrySet()) {
                ClassInstance.FieldValue field = new ClassInstance.FieldValue((Field)entry.getKey(), entry.getValue());
                fields.add(new HeapDumpFieldObject(this.myCaptureObject, this.myInstance, field));
            }
        }
        ArrayList<FieldObject> arrayList = fields;
        if (arrayList == null) {
            HeapDumpInstanceObject.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public ArrayObject getArrayObject() {
        if (!(this.myInstance instanceof ArrayInstance)) {
            return null;
        }
        final ArrayInstance arrayInstance = (ArrayInstance)this.myInstance;
        return new ArrayObject(){

            @Override
            @NotNull
            public ValueObject.ValueType getArrayElementType() {
                ValueObject.ValueType valueType = (ValueObject.ValueType)((Object)VALUE_TYPE_MAP.get(arrayInstance.getArrayType()));
                if (valueType == null) {
                    1.$$$reportNull$$$0(0);
                }
                return valueType;
            }

            @Override
            @Nullable
            public byte[] getAsByteArray() {
                if (this.getArrayElementType() == ValueObject.ValueType.BYTE) {
                    return arrayInstance.asRawByteArray(0, arrayInstance.getLength());
                }
                return null;
            }

            @Override
            @Nullable
            public char[] getAsCharArray() {
                if (this.getArrayElementType() == ValueObject.ValueType.CHAR) {
                    return arrayInstance.asCharArray(0, arrayInstance.getLength());
                }
                return null;
            }

            @Override
            @NotNull
            public Object[] getAsArray() {
                Object[] objectArray = arrayInstance.getValues();
                if (objectArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return objectArray;
            }

            @Override
            public int getArrayLength() {
                return arrayInstance.getLength();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/android/tools/profilers/memory/adapters/HeapDumpInstanceObject$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getArrayElementType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAsArray";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @Override
    @NotNull
    public ValueObject.ValueType getValueType() {
        ValueObject.ValueType valueType = this.myValueType;
        if (valueType == null) {
            HeapDumpInstanceObject.$$$reportNull$$$0(10);
        }
        return valueType;
    }

    @Override
    @Nullable
    public MemoryProfiler.AllocationStack getCallStack() {
        if (this.myInstance.getStack() == null) {
            return null;
        }
        MemoryProfiler.AllocationStack.Builder builder = MemoryProfiler.AllocationStack.newBuilder();
        MemoryProfiler.AllocationStack.StackFrameWrapper.Builder frameBuilder = MemoryProfiler.AllocationStack.StackFrameWrapper.newBuilder();
        for (StackFrame stackFrame : this.myInstance.getStack().getFrames()) {
            String fileName = stackFrame.getFilename();
            String guessedClassName = fileName.endsWith(".java") ? fileName.substring(0, fileName.length() - ".java".length()) : fileName;
            frameBuilder.addFrames(MemoryProfiler.AllocationStack.StackFrame.newBuilder().setClassName(guessedClassName).setMethodName(stackFrame.getMethodName()).setLineNumber(stackFrame.getLineNumber()).setFileName(fileName).build());
        }
        builder.setFullStack(frameBuilder);
        return builder.build();
    }

    @Override
    public boolean getIsRoot() {
        return this.myInstance instanceof RootObj;
    }

    @Override
    @NotNull
    public List<ReferenceObject> getReferences() {
        List<ReferenceObject> list = this.getIsRoot() ? Collections.EMPTY_LIST : this.extractReferences();
        if (list == null) {
            HeapDumpInstanceObject.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<ReferenceObject> extractReferences() {
        ArrayList<Object> sortedReferences = new ArrayList<Object>(this.myInstance.getHardReverseReferences());
        sortedReferences.sort(DEPTH_COMPARATOR);
        if (this.myInstance.getSoftReverseReferences() != null) {
            ArrayList<Instance> sortedSoftReferences = new ArrayList<Instance>(this.myInstance.getSoftReverseReferences());
            sortedSoftReferences.sort(DEPTH_COMPARATOR);
            sortedReferences.addAll(sortedSoftReferences);
        }
        ArrayList<ReferenceObject> referrers = new ArrayList<ReferenceObject>(sortedReferences.size());
        for (Instance instance : sortedReferences) {
            ArrayList<String> referencingFieldNames = new ArrayList<String>(3);
            if (instance instanceof ClassInstance) {
                ClassInstance classInstance = (ClassInstance)instance;
                for (ClassInstance.FieldValue entry : classInstance.getValues()) {
                    if (entry.getField().getType() != Type.OBJECT || entry.getValue() != this.myInstance) continue;
                    referencingFieldNames.add(entry.getField().getName());
                }
            } else if (instance instanceof ArrayInstance) {
                ArrayInstance arrayInstance = (ArrayInstance)instance;
                assert (arrayInstance.getArrayType() == Type.OBJECT);
                Object[] values = arrayInstance.getValues();
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] != this.myInstance) continue;
                    referencingFieldNames.add(String.valueOf(i));
                }
            } else if (instance instanceof ClassObj) {
                ClassObj classObj = (ClassObj)instance;
                Map staticValues = classObj.getStaticFieldValues();
                for (Map.Entry entry : staticValues.entrySet()) {
                    if (((Field)entry.getKey()).getType() != Type.OBJECT || entry.getValue() != this.myInstance) continue;
                    referencingFieldNames.add(((Field)entry.getKey()).getName());
                }
            }
            InstanceObject referencingInstance = this.myCaptureObject.findInstanceObject(instance);
            assert (referencingInstance != null);
            referrers.add(new ReferenceObject(referencingFieldNames, referencingInstance));
        }
        ArrayList<ReferenceObject> arrayList = referrers;
        if (arrayList == null) {
            HeapDumpInstanceObject.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classEntry";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/HeapDumpInstanceObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/HeapDumpInstanceObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueText";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getToStringText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassEntry";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "extractReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

