/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profilers.memory.MemoryProfilerConfiguration;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassSet;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.PackageSet;
import com.android.tools.profilers.memory.adapters.ThreadSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class HeapSet
extends ClassifierSet {
    @NotNull
    private final CaptureObject myCaptureObject;
    @NotNull
    private MemoryProfilerConfiguration.ClassGrouping myClassGrouping;
    private final int myId;

    public HeapSet(@NotNull CaptureObject captureObject, @NotNull String heapName, int id) {
        if (captureObject == null) {
            HeapSet.$$$reportNull$$$0(0);
        }
        if (heapName == null) {
            HeapSet.$$$reportNull$$$0(1);
        }
        super(heapName);
        this.myClassGrouping = MemoryProfilerConfiguration.ClassGrouping.ARRANGE_BY_CLASS;
        this.myCaptureObject = captureObject;
        this.myId = id;
        this.setClassGrouping(MemoryProfilerConfiguration.ClassGrouping.ARRANGE_BY_CLASS);
    }

    public void setClassGrouping(@NotNull MemoryProfilerConfiguration.ClassGrouping classGrouping) {
        if (classGrouping == null) {
            HeapSet.$$$reportNull$$$0(2);
        }
        if (this.myClassGrouping == classGrouping) {
            return;
        }
        this.myClassGrouping = classGrouping;
        List descendantsStream = this.getInstancesStream().collect(Collectors.toList());
        this.myInstances.clear();
        this.myClassifier = null;
        this.myInstances.addAll(descendantsStream);
    }

    public int getId() {
        return this.myId;
    }

    @Override
    @NotNull
    public ClassifierSet.Classifier createSubClassifier() {
        switch (this.myClassGrouping) {
            case ARRANGE_BY_CLASS: {
                ClassifierSet.Classifier classifier = ClassSet.createDefaultClassifier();
                if (classifier == null) {
                    HeapSet.$$$reportNull$$$0(3);
                }
                return classifier;
            }
            case ARRANGE_BY_PACKAGE: {
                ClassifierSet.Classifier classifier = PackageSet.createDefaultClassifier(this.myCaptureObject);
                if (classifier == null) {
                    HeapSet.$$$reportNull$$$0(4);
                }
                return classifier;
            }
            case ARRANGE_BY_CALLSTACK: {
                ClassifierSet.Classifier classifier = ThreadSet.createDefaultClassifier(this.myCaptureObject);
                if (classifier == null) {
                    HeapSet.$$$reportNull$$$0(5);
                }
                return classifier;
            }
        }
        throw new RuntimeException("Classifier type not implemented: " + (Object)((Object)this.myClassGrouping));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "captureObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heapName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classGrouping";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/adapters/HeapSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/adapters/HeapSet";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubClassifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setClassGrouping";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

