/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import sun.swing.SwingUtilities2;

public class LegendComponent
extends AnimatedComponent {
    private static final int LEGEND_VERT_MARGIN_PX = JBUI.scale((int)10);
    private static final int LEGEND_HORIZ_MARGIN_PX = JBUI.scale((int)12);
    private static final int ICON_MARGIN_PX = JBUI.scale((int)7);
    private final int myLeftPadding;
    private final int myRightPadding;
    private final int myVerticalPadding;
    private final LegendComponentModel myModel;
    private final Map<Legend, LegendConfig> myConfigs;
    private final Map<Legend, Integer> myMinWidths;
    @NotNull
    private final Orientation myOrientation;
    @NotNull
    private final List<LegendInstruction> myInstructions;

    public LegendComponent(@NotNull LegendComponentModel model) {
        if (model == null) {
            LegendComponent.$$$reportNull$$$0(0);
        }
        this(new Builder(model));
    }

    private LegendComponent(@NotNull Builder builder) {
        if (builder == null) {
            LegendComponent.$$$reportNull$$$0(1);
        }
        this.myMinWidths = new HashMap();
        this.myInstructions = new ArrayList<LegendInstruction>();
        this.myModel = builder.myModel;
        this.myConfigs = new HashMap();
        this.myOrientation = builder.myOrientation;
        this.myLeftPadding = builder.myLeftPadding;
        this.myRightPadding = builder.myRightPadding;
        this.myVerticalPadding = builder.myVerticalPadding;
        this.myModel.addDependency(this.myAspectObserver).onChange(LegendComponentModel.Aspect.LEGEND, this::modelChanged);
        this.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        this.modelChanged();
    }

    public void configure(Legend legend, LegendConfig config) {
        this.myConfigs.put(legend, config);
    }

    @NotNull
    public LegendComponentModel getModel() {
        LegendComponentModel legendComponentModel = this.myModel;
        if (legendComponentModel == null) {
            LegendComponent.$$$reportNull$$$0(2);
        }
        return legendComponentModel;
    }

    @NotNull
    List<LegendInstruction> getInstructions() {
        List<LegendInstruction> list = this.myInstructions;
        if (list == null) {
            LegendComponent.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private LegendConfig getConfig(Legend data) {
        LegendConfig config = this.myConfigs.get(data);
        if (config == null) {
            config = new LegendConfig(LegendConfig.IconType.NONE, Color.RED);
            this.myConfigs.put(data, config);
        }
        LegendConfig legendConfig = config;
        if (legendConfig == null) {
            LegendComponent.$$$reportNull$$$0(4);
        }
        return legendConfig;
    }

    @Override
    public Dimension getPreferredSize() {
        int width = 0;
        int height = 0;
        LegendState state = new LegendState(this.myInstructions);
        LegendCursor cursor = new LegendCursor();
        for (LegendInstruction instruction : this.myInstructions) {
            instruction.moveCursor(state, cursor);
            width = Math.max(cursor.x, width);
            height = Math.max(cursor.y + state.rowHeight, height);
        }
        return new Dimension(width + this.myLeftPadding + this.myRightPadding, height + 2 * this.myVerticalPadding);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    protected void draw(Graphics2D g2d, Dimension dim) {
        LegendState state = new LegendState(this.myInstructions);
        LegendCursor cursor = new LegendCursor();
        LegendBounds bounds = new LegendBounds(this.myLeftPadding, this.myVerticalPadding);
        for (LegendInstruction instruction : this.myInstructions) {
            bounds.update(state, cursor, instruction.getSize());
            instruction.render(this, g2d, bounds);
            instruction.moveCursor(state, cursor);
        }
    }

    private void modelChanged() {
        Dimension prevSize = this.getPreferredSize();
        this.myInstructions.clear();
        for (Legend legend : this.myModel.getLegends()) {
            LegendConfig config;
            if (legend != this.myModel.getLegends().get(0)) {
                if (this.myOrientation == Orientation.HORIZONTAL) {
                    this.myInstructions.add(new GapInstruction(LEGEND_HORIZ_MARGIN_PX));
                } else {
                    this.myInstructions.add(new NewRowInstruction());
                }
            }
            if ((config = this.getConfig(legend)).getIcon() != LegendConfig.IconType.NONE) {
                this.myInstructions.add(new IconInstruction(config.getIcon(), config.getColor()));
                this.myInstructions.add(new GapInstruction(ICON_MARGIN_PX));
            }
            String name = legend.getName();
            String value = legend.getValue();
            if (!name.isEmpty() && StringUtil.isNotEmpty((String)value)) {
                name = name + ": ";
            }
            this.myInstructions.add(new TextInstruction(this.getFont(), name));
            if (!StringUtil.isNotEmpty((String)value)) continue;
            TextInstruction valueInstruction = new TextInstruction(this.getFont(), value);
            if (this.myOrientation != Orientation.VERTICAL) {
                Integer minWidth = this.myMinWidths.getOrDefault(legend, 0);
                if (valueInstruction.getSize().w < minWidth) {
                    this.myInstructions.add(new GapInstruction(minWidth - valueInstruction.getSize().w));
                } else {
                    this.myMinWidths.put(legend, valueInstruction.getSize().w);
                }
            }
            this.myInstructions.add(valueInstruction);
        }
        if (!this.getPreferredSize().equals(prevSize)) {
            this.revalidate();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/LegendComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/LegendComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class NewRowInstruction
    extends LegendInstruction {
        NewRowInstruction() {
        }

        @Override
        public void moveCursor(@NotNull LegendState state, @NotNull LegendCursor cursor) {
            if (state == null) {
                NewRowInstruction.$$$reportNull$$$0(0);
            }
            if (cursor == null) {
                NewRowInstruction.$$$reportNull$$$0(1);
            }
            cursor.y += state.rowHeight + LEGEND_VERT_MARGIN_PX;
            cursor.x = 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cursor";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/adtui/LegendComponent$NewRowInstruction";
            objectArray[2] = "moveCursor";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class GapInstruction
    extends LegendInstruction {
        private final LegendSize mySize;

        private GapInstruction(int w) {
            this.mySize = new LegendSize(w, 0);
        }

        @Override
        @NotNull
        public LegendSize getSize() {
            LegendSize legendSize = this.mySize;
            if (legendSize == null) {
                GapInstruction.$$$reportNull$$$0(0);
            }
            return legendSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/LegendComponent$GapInstruction", "getSize"));
        }
    }

    static final class TextInstruction
    extends LegendInstruction {
        @NotNull
        final String myText;
        @NotNull
        private final Font myFont;
        @NotNull
        private final LegendSize mySize;

        private TextInstruction(@NotNull Font font, @NotNull String text) {
            if (font == null) {
                TextInstruction.$$$reportNull$$$0(0);
            }
            if (text == null) {
                TextInstruction.$$$reportNull$$$0(1);
            }
            this.myFont = font;
            this.myText = text;
            Rectangle2D bounds = this.myFont.getStringBounds(this.myText, new FontRenderContext(null, true, true));
            int w = (int)bounds.getWidth();
            int h = (int)bounds.getHeight();
            this.mySize = new LegendSize(w, h);
        }

        @Override
        @NotNull
        public LegendSize getSize() {
            LegendSize legendSize = this.mySize;
            if (legendSize == null) {
                TextInstruction.$$$reportNull$$$0(2);
            }
            return legendSize;
        }

        @Override
        public void render(@NotNull JComponent c, @NotNull Graphics2D g2d, @NotNull LegendBounds bounds) {
            if (c == null) {
                TextInstruction.$$$reportNull$$$0(3);
            }
            if (g2d == null) {
                TextInstruction.$$$reportNull$$$0(4);
            }
            if (bounds == null) {
                TextInstruction.$$$reportNull$$$0(5);
            }
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(c.getForeground());
            FontMetrics metrics = SwingUtilities2.getFontMetrics(c, this.myFont);
            assert (this.mySize.h <= bounds.h);
            int textY = bounds.y + metrics.getAscent() + (bounds.h - this.mySize.h) / 2;
            g2d.drawString(this.myText, bounds.x, textY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "font";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/LegendComponent$TextInstruction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g2d";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/LegendComponent$TextInstruction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "render";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class IconInstruction
    extends LegendInstruction {
        private static final int ICON_HEIGHT_PX = 15;
        private static final int LINE_THICKNESS = 3;
        private static final LegendSize BOX_SIZE = new LegendSize(11, 11);
        private static final LegendSize BOX_BOUNDS = new LegendSize(11, 15);
        private static final LegendSize LINE_SIZE = new LegendSize(12, 3);
        private static final LegendSize LINE_BOUNDS = new LegendSize(12, 15);
        private static final BasicStroke LINE_STROKE = new BasicStroke(3.0f);
        private static final BasicStroke DASH_STROKE = new BasicStroke(3.0f, 0, 2, 10.0f, new float[]{5.0f, 2.0f}, 0.0f);
        private static final BasicStroke BORDER_STROKE = new BasicStroke(1.0f);
        @NotNull
        final LegendConfig.IconType myType;
        @NotNull
        private final Color myColor;
        @NotNull
        private final Color myBorderColor;

        public IconInstruction(@NotNull LegendConfig.IconType type, @NotNull Color color) {
            if (type == null) {
                IconInstruction.$$$reportNull$$$0(0);
            }
            if (color == null) {
                IconInstruction.$$$reportNull$$$0(1);
            }
            switch (type) {
                case BOX: 
                case LINE: 
                case DASHED_LINE: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(type.toString());
                }
            }
            this.myType = type;
            this.myColor = color;
            int r = (int)((float)this.myColor.getRed() * 0.8f);
            int g = (int)((float)this.myColor.getGreen() * 0.8f);
            int b = (int)((float)this.myColor.getBlue() * 0.8f);
            this.myBorderColor = new Color(r, g, b);
        }

        @Override
        @NotNull
        public LegendSize getSize() {
            switch (this.myType) {
                case BOX: {
                    LegendSize legendSize = BOX_BOUNDS;
                    if (legendSize == null) {
                        IconInstruction.$$$reportNull$$$0(2);
                    }
                    return legendSize;
                }
                case LINE: 
                case DASHED_LINE: {
                    LegendSize legendSize = LINE_BOUNDS;
                    if (legendSize == null) {
                        IconInstruction.$$$reportNull$$$0(3);
                    }
                    return legendSize;
                }
            }
            throw new IllegalStateException(this.myType.toString());
        }

        @Override
        public void render(@NotNull JComponent c, @NotNull Graphics2D g2d, @NotNull LegendBounds bounds) {
            if (c == null) {
                IconInstruction.$$$reportNull$$$0(4);
            }
            if (g2d == null) {
                IconInstruction.$$$reportNull$$$0(5);
            }
            if (bounds == null) {
                IconInstruction.$$$reportNull$$$0(6);
            }
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Stroke prevStroke = g2d.getStroke();
            switch (this.myType) {
                case BOX: {
                    assert (IconInstruction.BOX_SIZE.w <= bounds.w);
                    assert (IconInstruction.BOX_SIZE.h <= bounds.h);
                    int boxX = bounds.x;
                    int boxY = bounds.y + (bounds.h - IconInstruction.BOX_SIZE.h) / 2;
                    g2d.setColor(this.myColor);
                    g2d.fillRect(boxX, boxY, IconInstruction.BOX_SIZE.w, IconInstruction.BOX_SIZE.h);
                    g2d.setColor(this.myBorderColor);
                    g2d.setStroke(BORDER_STROKE);
                    g2d.drawRect(boxX, boxY, IconInstruction.BOX_SIZE.w, IconInstruction.BOX_SIZE.h);
                    break;
                }
                case LINE: 
                case DASHED_LINE: {
                    assert (IconInstruction.LINE_SIZE.w <= bounds.w);
                    assert (IconInstruction.LINE_SIZE.h <= bounds.h);
                    g2d.setColor(this.myColor);
                    g2d.setStroke(this.myType == LegendConfig.IconType.LINE ? LINE_STROKE : DASH_STROKE);
                    int lineX = bounds.x;
                    int lineY = bounds.y + bounds.h / 2;
                    g2d.drawLine(lineX, lineY, lineX + IconInstruction.LINE_SIZE.w, lineY);
                    break;
                }
                default: {
                    throw new IllegalStateException(this.myType.toString());
                }
            }
            g2d.setStroke(prevStroke);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/LegendComponent$IconInstruction";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g2d";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/LegendComponent$IconInstruction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "render";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static abstract class LegendInstruction {
        LegendInstruction() {
        }

        @NotNull
        public LegendSize getSize() {
            LegendSize legendSize = LegendSize.EMPTY;
            if (legendSize == null) {
                LegendInstruction.$$$reportNull$$$0(0);
            }
            return legendSize;
        }

        public void moveCursor(@NotNull LegendState state, @NotNull LegendCursor cursor) {
            if (state == null) {
                LegendInstruction.$$$reportNull$$$0(1);
            }
            if (cursor == null) {
                LegendInstruction.$$$reportNull$$$0(2);
            }
            LegendSize size = this.getSize();
            cursor.x += size.w;
        }

        public void render(@NotNull JComponent c, @NotNull Graphics2D g2d, @NotNull LegendBounds bounds) {
            if (c == null) {
                LegendInstruction.$$$reportNull$$$0(3);
            }
            if (g2d == null) {
                LegendInstruction.$$$reportNull$$$0(4);
            }
            if (bounds == null) {
                LegendInstruction.$$$reportNull$$$0(5);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/LegendComponent$LegendInstruction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cursor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g2d";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSize";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/LegendComponent$LegendInstruction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "moveCursor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "render";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class LegendBounds {
        private final int myLeftX;
        private final int myTopY;
        private int x;
        private int y;
        private int w;
        private int h;

        public LegendBounds(int leftX, int topY) {
            this.myLeftX = leftX;
            this.myTopY = topY;
        }

        public void update(@NotNull LegendState state, @NotNull LegendCursor cursor, @NotNull LegendSize size) {
            if (state == null) {
                LegendBounds.$$$reportNull$$$0(0);
            }
            if (cursor == null) {
                LegendBounds.$$$reportNull$$$0(1);
            }
            if (size == null) {
                LegendBounds.$$$reportNull$$$0(2);
            }
            this.x = this.myLeftX + cursor.x;
            this.y = this.myTopY + cursor.y;
            this.w = size.w;
            this.h = state.rowHeight;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cursor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "size";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/adtui/LegendComponent$LegendBounds";
            objectArray[2] = "update";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class LegendSize {
        private static final LegendSize EMPTY = new LegendSize(0, 0);
        public final int w;
        public final int h;

        private LegendSize(int w, int h) {
            this.w = w;
            this.h = h;
        }
    }

    private static final class LegendCursor {
        public int x;
        public int y;

        private LegendCursor() {
        }
    }

    private static final class LegendState {
        private int rowHeight = 0;

        public LegendState(List<LegendInstruction> instructions) {
            for (LegendInstruction instruction : instructions) {
                this.rowHeight = Math.max(instruction.getSize().h, this.rowHeight);
            }
        }
    }

    public static final class Builder {
        private static final int DEFAULT_PADDING_X_PX = JBUI.scale((int)5);
        private static final int DEFAULT_PADDING_Y_PX = JBUI.scale((int)5);
        private final LegendComponentModel myModel;
        private int myLeftPadding;
        private int myRightPadding;
        private int myVerticalPadding;
        private Orientation myOrientation;

        public Builder(@NotNull LegendComponentModel model) {
            if (model == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myLeftPadding = DEFAULT_PADDING_X_PX;
            this.myRightPadding = DEFAULT_PADDING_X_PX;
            this.myVerticalPadding = DEFAULT_PADDING_Y_PX;
            this.myOrientation = Orientation.HORIZONTAL;
            this.myModel = model;
        }

        @NotNull
        public Builder setVerticalPadding(int verticalPadding) {
            this.myVerticalPadding = verticalPadding;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder setLeftPadding(int leftPadding) {
            this.myLeftPadding = leftPadding;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder setRightPadding(int rightPadding) {
            this.myRightPadding = rightPadding;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder setHorizontalPadding(int padding) {
            this.setLeftPadding(padding);
            this.setRightPadding(padding);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder setOrientation(@NotNull Orientation orientation) {
            if (orientation == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myOrientation = orientation;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public LegendComponent build() {
            LegendComponent legendComponent = new LegendComponent(this);
            if (legendComponent == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return legendComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/LegendComponent$Builder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orientation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/LegendComponent$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setVerticalPadding";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setLeftPadding";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRightPadding";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setHorizontalPadding";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setOrientation";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setOrientation";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

