/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.AbstractClientStream;
import io.grpc.internal.AbstractStream;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.ReadableBuffers;
import io.grpc.internal.WritableBufferAllocator;
import java.nio.charset.Charset;
import javax.annotation.Nullable;

public abstract class Http2ClientStream
extends AbstractClientStream<Integer> {
    private static final Metadata.AsciiMarshaller<Integer> HTTP_STATUS_LINE_MARSHALLER = new Metadata.AsciiMarshaller<Integer>(){

        @Override
        public String toAsciiString(Integer value) {
            return value.toString();
        }

        @Override
        public Integer parseAsciiString(String serialized) {
            return Integer.parseInt(serialized.split(" ", 2)[0]);
        }
    };
    private static final Metadata.Key<Integer> HTTP2_STATUS = Metadata.Key.of(":status", HTTP_STATUS_LINE_MARSHALLER);
    private Status transportError;
    private Metadata transportErrorMetadata;
    private Charset errorCharset = Charsets.UTF_8;
    private boolean headersReceived;

    protected Http2ClientStream(WritableBufferAllocator bufferAllocator, int maxMessageSize) {
        super(bufferAllocator, maxMessageSize);
    }

    protected void transportHeadersReceived(Metadata headers) {
        Preconditions.checkNotNull((Object)headers);
        if (this.transportError != null) {
            this.transportError = this.transportError.augmentDescription("headers: " + headers);
            return;
        }
        try {
            if (this.headersReceived) {
                this.transportError = Status.INTERNAL.withDescription("Received headers twice");
                return;
            }
            Integer httpStatus = headers.get(HTTP2_STATUS);
            if (httpStatus != null && httpStatus >= 100 && httpStatus < 200) {
                return;
            }
            this.headersReceived = true;
            this.transportError = this.validateInitialMetadata(headers);
            if (this.transportError != null) {
                return;
            }
            Http2ClientStream.stripTransportDetails(headers);
            this.inboundHeadersReceived(headers);
        }
        finally {
            if (this.transportError != null) {
                this.transportError = this.transportError.augmentDescription("headers: " + headers);
                this.transportErrorMetadata = headers;
                this.errorCharset = Http2ClientStream.extractCharset(headers);
            }
        }
    }

    protected void transportDataReceived(ReadableBuffer frame, boolean endOfStream) {
        if (this.transportError == null && this.inboundPhase() == AbstractStream.Phase.HEADERS) {
            this.transportError = Status.INTERNAL.withDescription("no headers received prior to data");
            this.transportErrorMetadata = new Metadata();
        }
        if (this.transportError != null) {
            this.transportError = this.transportError.augmentDescription("DATA-----------------------------\n" + ReadableBuffers.readAsString(frame, this.errorCharset));
            frame.close();
            if (this.transportError.getDescription().length() > 1000 || endOfStream) {
                this.inboundTransportError(this.transportError, this.transportErrorMetadata);
                this.sendCancel(Status.CANCELLED);
            }
        } else {
            this.inboundDataReceived(frame);
            if (endOfStream) {
                this.transportError = Status.INTERNAL.withDescription("Received EOS on DATA frame");
                this.transportErrorMetadata = new Metadata();
                this.inboundTransportError(this.transportError, this.transportErrorMetadata);
            }
        }
    }

    protected void transportTrailersReceived(Metadata trailers) {
        Preconditions.checkNotNull((Object)trailers, (Object)"trailers");
        if (this.transportError == null && !this.headersReceived) {
            this.transportError = this.validateInitialMetadata(trailers);
            if (this.transportError != null) {
                this.transportErrorMetadata = trailers;
            }
        }
        if (this.transportError != null) {
            this.transportError = this.transportError.augmentDescription("trailers: " + trailers);
            this.inboundTransportError(this.transportError, this.transportErrorMetadata);
            this.sendCancel(Status.CANCELLED);
        } else {
            Status status = this.statusFromTrailers(trailers);
            Http2ClientStream.stripTransportDetails(trailers);
            this.inboundTrailersReceived(trailers, status);
        }
    }

    private Status statusFromTrailers(Metadata trailers) {
        Status status = trailers.get(Status.CODE_KEY);
        if (status != null) {
            return status.withDescription(trailers.get(Status.MESSAGE_KEY));
        }
        if (this.headersReceived) {
            return Status.UNKNOWN.withDescription("missing GRPC status in response");
        }
        Integer httpStatus = trailers.get(HTTP2_STATUS);
        status = httpStatus != null ? GrpcUtil.httpStatusToGrpcStatus(httpStatus) : Status.INTERNAL.withDescription("missing HTTP status code");
        return status.augmentDescription("missing GRPC status, inferred error from HTTP status code");
    }

    @Nullable
    private Status validateInitialMetadata(Metadata headers) {
        Integer httpStatus = headers.get(HTTP2_STATUS);
        if (httpStatus == null) {
            return Status.INTERNAL.withDescription("Missing HTTP status code");
        }
        String contentType = headers.get(GrpcUtil.CONTENT_TYPE_KEY);
        if (!GrpcUtil.isGrpcContentType(contentType)) {
            return GrpcUtil.httpStatusToGrpcStatus(httpStatus).augmentDescription("invalid content-type: " + contentType);
        }
        return null;
    }

    private static Charset extractCharset(Metadata headers) {
        String contentType = headers.get(GrpcUtil.CONTENT_TYPE_KEY);
        if (contentType != null) {
            String[] split = contentType.split("charset=");
            try {
                return Charset.forName(split[split.length - 1].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Charsets.UTF_8;
    }

    private static void stripTransportDetails(Metadata metadata) {
        metadata.removeAll(HTTP2_STATUS);
        metadata.removeAll(Status.CODE_KEY);
        metadata.removeAll(Status.MESSAGE_KEY);
    }
}

