/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.stub;

import com.google.common.base.Preconditions;
import io.grpc.stub.CallStreamObserver;
import java.util.Iterator;

public class StreamObservers {
    public static <V> void copyWithFlowControl(final Iterator<V> source, final CallStreamObserver<V> target) {
        Preconditions.checkNotNull(source);
        Preconditions.checkNotNull(target);
        target.setOnReadyHandler(new Runnable(){

            @Override
            public void run() {
                while (target.isReady() && source.hasNext()) {
                    target.onNext(source.next());
                }
                if (!source.hasNext()) {
                    target.onCompleted();
                }
            }
        });
    }

    public static <V> void copyWithFlowControl(Iterable<V> source, CallStreamObserver<V> target) {
        Preconditions.checkNotNull(source);
        StreamObservers.copyWithFlowControl(source.iterator(), target);
    }
}

