/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.projectRoots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.ValidatableSdkAdditionalData;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;

public class Sandbox
implements ValidatableSdkAdditionalData {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.devkit.projectRoots.Sandbox");
    public String mySandboxHome;
    private final Sdk myCurrentJdk;
    private String myJavaSdkName;
    private Sdk myJavaSdk;
    private LocalFileSystem.WatchRequest mySandboxRoot;
    @NonNls
    private static final String SDK = "sdk";

    public Sandbox(String sandboxHome, Sdk javaSdk, Sdk currentJdk) {
        this.mySandboxHome = sandboxHome;
        this.myCurrentJdk = currentJdk;
        if (this.mySandboxHome != null) {
            this.mySandboxRoot = LocalFileSystem.getInstance().addRootToWatch(this.mySandboxHome, true);
        }
        this.myJavaSdk = javaSdk;
    }

    public Sandbox(Sdk currentSdk) {
        this.myCurrentJdk = currentSdk;
    }

    public String getSandboxHome() {
        return this.mySandboxHome;
    }

    public Object clone() throws CloneNotSupportedException {
        return new Sandbox(this.mySandboxHome, this.getJavaSdk(), this.myCurrentJdk);
    }

    public void checkValid(SdkModel sdkModel) throws ConfigurationException {
        if (StringUtil.isEmpty((String)this.mySandboxHome)) {
            throw new ConfigurationException(DevKitBundle.message("sandbox.specification", new Object[0]));
        }
        if (this.getJavaSdk() == null) {
            throw new ConfigurationException(DevKitBundle.message("jdk.specification", new Object[0]));
        }
    }

    void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        LOG.assertTrue(this.mySandboxRoot == null);
        this.myJavaSdkName = element.getAttributeValue(SDK);
        if (this.mySandboxHome != null) {
            this.mySandboxRoot = LocalFileSystem.getInstance().addRootToWatch(this.mySandboxHome, true);
        }
    }

    void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        Sdk sdk = this.getJavaSdk();
        if (sdk != null) {
            element.setAttribute(SDK, sdk.getName());
        }
    }

    void cleanupWatchedRoots() {
        if (this.mySandboxRoot != null) {
            LocalFileSystem.getInstance().removeWatchedRoot(this.mySandboxRoot);
        }
    }

    @Nullable
    public Sdk getJavaSdk() {
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        if (this.myJavaSdk == null) {
            if (this.myJavaSdkName != null) {
                this.myJavaSdk = jdkTable.findJdk(this.myJavaSdkName);
                this.myJavaSdkName = null;
            } else {
                for (Sdk jdk : jdkTable.getAllJdks()) {
                    if (!IdeaJdk.isValidInternalJdk(this.myCurrentJdk, jdk)) continue;
                    this.myJavaSdk = jdk;
                    break;
                }
            }
        }
        return this.myJavaSdk;
    }

    void setJavaSdk(Sdk javaSdk) {
        this.myJavaSdk = javaSdk;
    }
}

