/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.PluginRelatedLocatorsUtils;

public abstract class ExtensionLocator {
    @NotNull
    public abstract List<ExtensionCandidate> findCandidates();

    public static ExtensionLocator byPsiClass(PsiClass psiClass) {
        return new ExtensionByPsiClassLocator(psiClass);
    }

    public static ExtensionLocator byExtensionPoint(@NotNull ExtensionPoint extensionPoint) {
        if (extensionPoint == null) {
            ExtensionLocator.$$$reportNull$$$0(0);
        }
        return new ExtensionByExtensionPointLocator(extensionPoint, null);
    }

    public static ExtensionLocator byExtensionPointAndId(@NotNull ExtensionPoint extensionPoint, @NotNull String extensionId) {
        if (extensionPoint == null) {
            ExtensionLocator.$$$reportNull$$$0(1);
        }
        if (extensionId == null) {
            ExtensionLocator.$$$reportNull$$$0(2);
        }
        return new ExtensionByExtensionPointLocator(extensionPoint, extensionId);
    }

    private static void processExtensionDeclarations(String name, Project project, PsiNonJavaFileReferenceProcessor referenceProcessor) {
        if (name == null) {
            return;
        }
        GlobalSearchScope scope = PluginRelatedLocatorsUtils.getCandidatesScope(project);
        PsiSearchHelper.SERVICE.getInstance((Project)project).processUsagesInNonJavaFiles(name, referenceProcessor, scope);
    }

    @Nullable
    private static XmlTag getXmlTagOfTokenElement(PsiFile file, int startOffset, String matchStr, boolean strictMatch) {
        String tokenText;
        PsiElement element = file.findElementAt(startOffset);
        String string = tokenText = element instanceof XmlToken ? element.getText() : null;
        if (tokenText == null) {
            return null;
        }
        if (!strictMatch && !StringUtil.contains((CharSequence)tokenText, (CharSequence)matchStr)) {
            return null;
        }
        if (strictMatch && !StringUtil.equals((CharSequence)tokenText, (CharSequence)matchStr)) {
            return null;
        }
        return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionId";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/util/ExtensionLocator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "byExtensionPoint";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "byExtensionPointAndId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ExtensionByExtensionPointLocator
    extends ExtensionLocator {
        private final ExtensionPoint myExtensionPoint;
        private final String myExtensionId;

        private ExtensionByExtensionPointLocator(@NotNull ExtensionPoint extensionPoint, @Nullable String extensionId) {
            if (extensionPoint == null) {
                ExtensionByExtensionPointLocator.$$$reportNull$$$0(0);
            }
            this.myExtensionPoint = extensionPoint;
            this.myExtensionId = extensionId;
        }

        @Override
        @NotNull
        public List<ExtensionCandidate> findCandidates() {
            XmlTag epTag = this.myExtensionPoint.getXmlTag();
            if (epTag == null) {
                List<ExtensionCandidate> list = Collections.emptyList();
                if (list == null) {
                    ExtensionByExtensionPointLocator.$$$reportNull$$$0(1);
                }
                return list;
            }
            Project project = epTag.getProject();
            DomManager domManager = DomManager.getDomManager((Project)project);
            String epNameToSearch = StringUtil.substringAfterLast((String)this.myExtensionPoint.getEffectiveQualifiedName(), (String)".");
            SmartList result = new SmartList();
            ExtensionLocator.processExtensionDeclarations(epNameToSearch, project, (arg_0, arg_1, arg_2) -> this.lambda$findCandidates$0(epNameToSearch, domManager, (List)result, arg_0, arg_1, arg_2));
            SmartList smartList = result;
            if (smartList == null) {
                ExtensionByExtensionPointLocator.$$$reportNull$$$0(2);
            }
            return smartList;
        }

        private /* synthetic */ boolean lambda$findCandidates$0(String epNameToSearch, DomManager domManager, List result, PsiFile file, int startOffset, int endOffset) {
            XmlTag tag = ExtensionLocator.getXmlTagOfTokenElement(file, startOffset, epNameToSearch, false);
            if (tag == null) {
                return true;
            }
            DomElement domElement = domManager.getDomElement(tag);
            if (!(domElement instanceof Extension)) {
                return true;
            }
            Extension extension = (Extension)domElement;
            ExtensionPoint ep = extension.getExtensionPoint();
            if (ep == null) {
                return true;
            }
            if (StringUtil.equals((CharSequence)ep.getEffectiveQualifiedName(), (CharSequence)this.myExtensionPoint.getEffectiveQualifiedName()) && (this.myExtensionId == null || this.myExtensionId.equals(extension.getId().getStringValue()))) {
                result.add(new ExtensionCandidate((SmartPsiElementPointer<XmlTag>)SmartPointerManager.getInstance((Project)tag.getProject()).createSmartPsiElementPointer((PsiElement)tag)));
                return this.myExtensionId == null;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensionPoint";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/util/ExtensionLocator$ExtensionByExtensionPointLocator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/util/ExtensionLocator$ExtensionByExtensionPointLocator";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findCandidates";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExtensionByPsiClassLocator
    extends ExtensionLocator {
        private final PsiClass myPsiClass;

        ExtensionByPsiClassLocator(PsiClass psiClass) {
            this.myPsiClass = psiClass;
        }

        @Override
        @NotNull
        public List<ExtensionCandidate> findCandidates() {
            String name = ClassUtil.getJVMClassName((PsiClass)this.myPsiClass);
            if (name == null) {
                List<ExtensionCandidate> list = Collections.emptyList();
                if (list == null) {
                    ExtensionByPsiClassLocator.$$$reportNull$$$0(0);
                }
                return list;
            }
            SmartList result = new SmartList();
            ExtensionLocator.processExtensionDeclarations(this.myPsiClass.getQualifiedName(), this.myPsiClass.getProject(), (arg_0, arg_1, arg_2) -> ExtensionByPsiClassLocator.lambda$findCandidates$0(name, (List)result, arg_0, arg_1, arg_2));
            SmartList smartList = result;
            if (smartList == null) {
                ExtensionByPsiClassLocator.$$$reportNull$$$0(1);
            }
            return smartList;
        }

        private static /* synthetic */ boolean lambda$findCandidates$0(String name, List result, PsiFile file, int startOffset, int endOffset) {
            XmlTag tag = ExtensionLocator.getXmlTagOfTokenElement(file, startOffset, name, true);
            DomElement dom = DomUtil.getDomElement((PsiElement)tag);
            if (dom instanceof Extension && ((Extension)dom).getExtensionPoint() != null) {
                result.add(new ExtensionCandidate((SmartPsiElementPointer<XmlTag>)SmartPointerManager.getInstance((Project)tag.getProject()).createSmartPsiElementPointer((PsiElement)tag)));
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/util/ExtensionLocator$ExtensionByPsiClassLocator", "findCandidates"));
        }
    }
}

