/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CustomExceptionHandler;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtil {
    @NonNls
    private static final String CLONE_METHOD_NAME = "clone";

    private ExceptionUtil() {
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(@NotNull PsiElement[] elements) {
        if (elements == null) {
            ExceptionUtil.$$$reportNull$$$0(0);
        }
        ArrayList array = ContainerUtil.newArrayList();
        for (PsiElement element : elements) {
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(element);
            ExceptionUtil.addExceptions(array, exceptions);
        }
        ArrayList arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getThrownCheckedExceptions(PsiElement ... elements) {
        List<PsiClassType> exceptions;
        if (elements == null) {
            ExceptionUtil.$$$reportNull$$$0(2);
        }
        if ((exceptions = ExceptionUtil.getThrownExceptions(elements)).isEmpty()) {
            List<PsiClassType> list = exceptions;
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<PsiClassType> list = exceptions = ExceptionUtil.filterOutUncheckedExceptions(exceptions);
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static List<PsiClassType> filterOutUncheckedExceptions(@NotNull List<PsiClassType> exceptions) {
        if (exceptions == null) {
            ExceptionUtil.$$$reportNull$$$0(5);
        }
        ArrayList array = ContainerUtil.newArrayList();
        for (PsiClassType exception : exceptions) {
            if (ExceptionUtil.isUncheckedException(exception)) continue;
            array.add(exception);
        }
        ArrayList arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getThrownExceptions(final @NotNull PsiElement element) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(7);
        }
        final ArrayList<PsiClassType> result = new ArrayList<PsiClassType>();
        element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitAnonymousClass(PsiAnonymousClass aClass) {
                PsiExpressionList argumentList = aClass.getArgumentList();
                if (argumentList != null) {
                    super.visitExpressionList(argumentList);
                }
                super.visitAnonymousClass(aClass);
            }

            public void visitClass(PsiClass aClass) {
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiReferenceExpression methodRef = expression2.getMethodExpression();
                JavaResolveResult resolveResult = methodRef.advancedResolve(false);
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method != null) {
                    ExceptionUtil.addExceptions(result, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
                }
                super.visitMethodCallExpression(expression2);
            }

            public void visitNewExpression(PsiNewExpression expression2) {
                JavaResolveResult resolveResult = expression2.resolveMethodGenerics();
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method != null) {
                    ExceptionUtil.addExceptions(result, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
                }
                super.visitNewExpression(expression2);
            }

            public void visitThrowStatement(PsiThrowStatement statement) {
                PsiExpression expr = statement.getException();
                if (expr != null) {
                    ExceptionUtil.addExceptions(result, StreamEx.of((Collection)ExceptionUtil.getPreciseThrowTypes(expr)).select(PsiClassType.class).toList());
                }
                super.visitThrowStatement(statement);
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
            }

            public void visitResourceList(PsiResourceList resourceList) {
                for (PsiResourceListElement listElement : resourceList) {
                    ExceptionUtil.addExceptions(result, ExceptionUtil.getCloserExceptions(listElement));
                }
                super.visitResourceList(resourceList);
            }

            public void visitTryStatement(PsiTryStatement statement) {
                ExceptionUtil.addExceptions(result, ExceptionUtil.getTryExceptions(statement));
            }
        });
        ArrayList<PsiClassType> arrayList = result;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getTryExceptions(@NotNull PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        if (tryStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(9);
        }
        ArrayList array = ContainerUtil.newArrayList();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            for (PsiCodeBlock[] resource : resourceList) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)resource, (PsiElement)resourceList));
            }
        }
        if ((tryBlock = tryStatement.getTryBlock()) != null) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions((PsiElement)tryBlock));
        }
        for (PsiResourceListElement psiResourceListElement : tryStatement.getCatchBlockParameters()) {
            PsiType exception = psiResourceListElement.getType();
            for (int j = array.size() - 1; j >= 0; --j) {
                PsiClassType exception1 = (PsiClassType)array.get(j);
                if (!exception.isAssignableFrom((PsiType)exception1)) continue;
                array.remove(exception1);
            }
        }
        for (PsiCodeBlock psiCodeBlock : tryStatement.getCatchBlocks()) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions((PsiElement)psiCodeBlock));
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            try {
                ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow((PsiElement)finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
                List<PsiClassType> list = ExceptionUtil.getThrownExceptions((PsiElement)finallyBlock);
                if (!BitUtil.isSet((int)completionReasons, (int)1)) {
                    array = ContainerUtil.newArrayList(list);
                } else {
                    ExceptionUtil.addExceptions(array, list);
                }
            }
            catch (AnalysisCanceledException analysisCanceledException) {
                // empty catch block
            }
        }
        ArrayList arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethodAndChildren(@NotNull PsiElement element, @NotNull JavaResolveResult resolveResult) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(11);
        }
        if (resolveResult == null) {
            ExceptionUtil.$$$reportNull$$$0(12);
        }
        ArrayList result = ContainerUtil.newArrayList();
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        if (method != null) {
            ExceptionUtil.addExceptions(result, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor(), element));
        }
        ExceptionUtil.addExceptions(result, ExceptionUtil.getThrownExceptions(element.getChildren()));
        ArrayList arrayList = result;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement place) {
        PsiClassType[] referenceTypes;
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(14);
        }
        if (substitutor == null) {
            ExceptionUtil.$$$reportNull$$$0(15);
        }
        if (place == null) {
            ExceptionUtil.$$$reportNull$$$0(16);
        }
        if ((referenceTypes = method.getThrowsList().getReferencedTypes()).length == 0) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(17);
            }
            return list;
        }
        GlobalSearchScope scope = place.getResolveScope();
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiClassType type2 : referenceTypes) {
            if (!((type2 = PsiClassImplUtil.correctType(substitutor.substitute((PsiType)type2), scope)) instanceof PsiClassType)) continue;
            result.add(type2);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private static void addExceptions(@NotNull List<PsiClassType> array, @NotNull Collection<PsiClassType> exceptions) {
        if (array == null) {
            ExceptionUtil.$$$reportNull$$$0(19);
        }
        if (exceptions == null) {
            ExceptionUtil.$$$reportNull$$$0(20);
        }
        for (PsiClassType exception : exceptions) {
            ExceptionUtil.addException(array, exception);
        }
    }

    private static void addException(@NotNull List<PsiClassType> array, @Nullable PsiClassType exception) {
        if (array == null) {
            ExceptionUtil.$$$reportNull$$$0(21);
        }
        if (exception == null) {
            return;
        }
        for (int i = array.size() - 1; i >= 0; --i) {
            PsiClassType exception1 = array.get(i);
            if (exception1.isAssignableFrom((PsiType)exception)) {
                return;
            }
            if (!exception.isAssignableFrom((PsiType)exception1)) continue;
            array.remove(i);
        }
        array.add(exception);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(22);
        }
        Collection<PsiClassType> collection = ExceptionUtil.collectUnhandledExceptions(element, topElement, true);
        if (collection == null) {
            ExceptionUtil.$$$reportNull$$$0(23);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        Set<PsiClassType> set;
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(24);
        }
        Collection<Object> collection = (set = ExceptionUtil.collectUnhandledExceptions(element, topElement, null, includeSelfCalls)) == null ? Collections.emptyList() : set;
        if (collection == null) {
            ExceptionUtil.$$$reportNull$$$0(25);
        }
        return collection;
    }

    @Nullable
    private static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, @Nullable Set<PsiClassType> foundExceptions, boolean includeSelfCalls) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(26);
        }
        AbstractCollection unhandledExceptions = null;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression2 = (PsiCallExpression)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(expression2, topElement, includeSelfCalls);
        } else {
            List<PsiClassType> unhandled;
            if (element instanceof PsiMethodReferenceExpression) {
                PsiExpression qualifierExpression2 = ((PsiMethodReferenceExpression)element).getQualifierExpression();
                return qualifierExpression2 != null ? ExceptionUtil.collectUnhandledExceptions((PsiElement)qualifierExpression2, topElement, null, false) : null;
            }
            if (element instanceof PsiLambdaExpression) {
                return null;
            }
            if (element instanceof PsiThrowStatement) {
                PsiThrowStatement statement = (PsiThrowStatement)element;
                unhandledExceptions = ExceptionUtil.getUnhandledExceptions(statement, topElement);
            } else if (element instanceof PsiCodeBlock && element.getParent() instanceof PsiMethod && ((PsiMethod)element.getParent()).isConstructor() && !ExceptionUtil.firstStatementIsConstructorCall((PsiCodeBlock)element)) {
                PsiMethod constructor = (PsiMethod)element.getParent();
                PsiClass aClass = constructor.getContainingClass();
                PsiClass superClass = aClass == null ? null : aClass.getSuperClass();
                PsiMethod[] superConstructors = superClass == null ? PsiMethod.EMPTY_ARRAY : superClass.getConstructors();
                HashSet<PsiClassType> unhandled2 = new HashSet<PsiClassType>();
                for (PsiMethod superConstructor : superConstructors) {
                    PsiClassType[] exceptionTypes;
                    if (superConstructor.hasModifierProperty("private") || !superConstructor.getParameterList().isEmpty()) continue;
                    for (PsiClassType exceptionType : exceptionTypes = superConstructor.getThrowsList().getReferencedTypes()) {
                        if (ExceptionUtil.isUncheckedException(exceptionType) || ExceptionUtil.isHandled(element, exceptionType, topElement)) continue;
                        unhandled2.add(exceptionType);
                    }
                    break;
                }
                if (aClass != null) {
                    PsiClassInitializer[] initializers = aClass.getInitializers();
                    THashSet thrownByInitializer = new THashSet();
                    for (PsiClassInitializer initializer : initializers) {
                        if (initializer.hasModifierProperty("static")) continue;
                        thrownByInitializer.clear();
                        ExceptionUtil.collectUnhandledExceptions((PsiElement)initializer.getBody(), (PsiElement)initializer, (Set<PsiClassType>)thrownByInitializer, includeSelfCalls);
                        for (PsiClassType thrown : thrownByInitializer) {
                            if (ExceptionUtil.isHandled((PsiElement)constructor.getBody(), thrown, topElement)) continue;
                            unhandled2.add(thrown);
                        }
                    }
                }
                unhandledExceptions = unhandled2;
            } else if (element instanceof PsiResourceListElement && !(unhandled = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)element, topElement)).isEmpty()) {
                unhandledExceptions = ContainerUtil.newArrayList(unhandled);
            }
        }
        if (unhandledExceptions != null) {
            if (foundExceptions == null) {
                foundExceptions = new THashSet();
            }
            foundExceptions.addAll(unhandledExceptions);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            Set<PsiClassType> foundInChild = ExceptionUtil.collectUnhandledExceptions(child, topElement, (Set<PsiClassType>)foundExceptions, includeSelfCalls);
            if (foundExceptions == null) {
                foundExceptions = foundInChild;
                continue;
            }
            if (foundInChild == null) continue;
            foundExceptions.addAll(foundInChild);
        }
        return foundExceptions;
    }

    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(@NotNull PsiMethodReferenceExpression methodReferenceExpression, PsiElement topElement) {
        JavaResolveResult resolveResult;
        PsiElement resolve;
        if (methodReferenceExpression == null) {
            ExceptionUtil.$$$reportNull$$$0(27);
        }
        if ((resolve = (resolveResult = methodReferenceExpression.advancedResolve(false)).getElement()) instanceof PsiMethod) {
            PsiElement referenceNameElement = methodReferenceExpression.getReferenceNameElement();
            List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions((PsiMethod)resolve, referenceNameElement, topElement, resolveResult.getSubstitutor());
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(28);
            }
            return list;
        }
        List<PsiClassType> list = Collections.emptyList();
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(29);
        }
        return list;
    }

    private static boolean firstStatementIsConstructorCall(@NotNull PsiCodeBlock constructorBody) {
        PsiStatement[] statements;
        if (constructorBody == null) {
            ExceptionUtil.$$$reportNull$$$0(30);
        }
        if ((statements = constructorBody.getStatements()).length == 0) {
            return false;
        }
        if (!(statements[0] instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression2 = ((PsiExpressionStatement)statements[0]).getExpression();
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethod method = (PsiMethod)((PsiMethodCallExpression)expression2).getMethodExpression().resolve();
        return method != null && method.isConstructor();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(final @NotNull PsiElement[] elements) {
        if (elements == null) {
            ExceptionUtil.$$$reportNull$$$0(31);
        }
        final ArrayList array = ContainerUtil.newArrayList();
        JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getOwnUnhandledExceptions(element));
                super.visitElement(element);
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                if (ArrayUtil.find((Object[])elements, (Object)expression2) >= 0) {
                    this.visitElement((PsiElement)expression2);
                }
            }

            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression2) {
                if (expression2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (ArrayUtil.find((Object[])elements, (Object)expression2) >= 0) {
                    this.visitElement((PsiElement)expression2);
                }
            }

            public void visitClass(PsiClass aClass) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/ExceptionUtil$2", "visitMethodReferenceExpression"));
            }
        };
        for (PsiElement element : elements) {
            element.accept((PsiElementVisitor)visitor);
        }
        ArrayList arrayList = array;
        if (arrayList == null) {
            ExceptionUtil.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiClassType> getOwnUnhandledExceptions(@NotNull PsiElement element) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(33);
        }
        if (element instanceof PsiEnumConstant) {
            PsiMethod method = ((PsiEnumConstant)element).resolveMethod();
            if (method != null) {
                List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions(method, element, null, PsiSubstitutor.EMPTY);
                if (list == null) {
                    ExceptionUtil.$$$reportNull$$$0(34);
                }
                return list;
            }
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(35);
            }
            return list;
        }
        if (element instanceof PsiCallExpression) {
            List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions((PsiCallExpression)element, null);
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(36);
            }
            return list;
        }
        if (element instanceof PsiThrowStatement) {
            List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions((PsiThrowStatement)element, null);
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(37);
            }
            return list;
        }
        if (element instanceof PsiMethodReferenceExpression) {
            List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions((PsiMethodReferenceExpression)element, null);
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(38);
            }
            return list;
        }
        if (element instanceof PsiResourceListElement) {
            List<PsiClassType> list = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)element, null);
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(39);
            }
            return list;
        }
        List<PsiClassType> list = Collections.emptyList();
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(40);
        }
        return list;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiElement element) {
        if (element == null) {
            ExceptionUtil.$$$reportNull$$$0(41);
        }
        List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions(new PsiElement[]{element});
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(42);
        }
        return list;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement) {
        if (methodCall == null) {
            ExceptionUtil.$$$reportNull$$$0(43);
        }
        List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, true);
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(44);
        }
        return list;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiCallExpression methodCall, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        block19: {
            block20: {
                if (methodCall == null) {
                    ExceptionUtil.$$$reportNull$$$0(45);
                }
                if (MethodCandidateInfo.isOverloadCheck()) {
                    v0 = Collections.emptyList();
                    if (v0 == null) {
                        ExceptionUtil.$$$reportNull$$$0(46);
                    }
                    return v0;
                }
                properties = MethodCandidateInfo.getCurrentMethod((PsiElement)methodCall.getArgumentList());
                result = properties != null ? properties.getInfo() : PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)methodCall);
                element = result.getElement();
                v1 = method = element instanceof PsiMethod != false ? (PsiMethod)element : null;
                if (method == null) {
                    v2 = Collections.emptyList();
                    if (v2 == null) {
                        ExceptionUtil.$$$reportNull$$$0(47);
                    }
                    return v2;
                }
                if (!includeSelfCalls && method == PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class)) {
                    v3 = Collections.emptyList();
                    if (v3 == null) {
                        ExceptionUtil.$$$reportNull$$$0(48);
                    }
                    return v3;
                }
                if (properties != null) {
                    PsiUtilCore.ensureValid((PsiElement)method);
                }
                if ((thrownExceptions = method.getThrowsList().getReferencedTypes()).length == 0) {
                    v4 = Collections.emptyList();
                    if (v4 == null) {
                        ExceptionUtil.$$$reportNull$$$0(49);
                    }
                    return v4;
                }
                substitutor = result.getSubstitutor();
                if (ExceptionUtil.isArrayClone(method, (PsiElement)methodCall) || !(methodCall instanceof PsiMethodCallExpression)) break block19;
                containingFile = methodCall.getContainingFile();
                processor = new MethodResolverProcessor((PsiMethodCallExpression)methodCall, containingFile);
                try {
                    PsiScopesUtil.setupAndRunProcessor(processor, methodCall, false);
                    candidates = ContainerUtil.mapNotNull(processor.getResults(), (Function)(Function)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getUnhandledExceptions$0(com.intellij.psi.PsiMethod com.intellij.psi.infos.CandidateInfo ), (Lcom/intellij/psi/infos/CandidateInfo;)Lcom/intellij/openapi/util/Pair;)((PsiMethod)method));
                    if (candidates.isEmpty()) break block19;
                    scope = methodCall.getResolveScope();
                    ex = ExceptionUtil.collectSubstituted(substitutor, thrownExceptions, scope);
lbl39:
                    // 2 sources

                    for (Pair pair : candidates) {
                        exceptions = ((PsiMethod)pair.first).getThrowsList().getReferencedTypes();
                        if (exceptions.length == 0) {
                            v5 = ExceptionUtil.getUnhandledExceptions((PsiElement)methodCall, topElement, PsiSubstitutor.EMPTY, PsiClassType.EMPTY_ARRAY);
                            break block20;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl57
                }
                catch (MethodProcessorSetupFailedException ignore) {
                    v6 = Collections.emptyList();
                    if (v6 == null) {
                        ExceptionUtil.$$$reportNull$$$0(52);
                    }
                    return v6;
                }
            }
            if (v5 == null) {
                ExceptionUtil.$$$reportNull$$$0(50);
            }
            return v5;
lbl-1000:
            // 1 sources

            {
                ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted((PsiSubstitutor)pair.second, exceptions, scope));
                ** GOTO lbl39
lbl57:
                // 1 sources

                v7 = ExceptionUtil.getUnhandledExceptions((PsiElement)methodCall, topElement, PsiSubstitutor.EMPTY, ex.toArray(PsiClassType.EMPTY_ARRAY));
            }
            if (v7 == null) {
                ExceptionUtil.$$$reportNull$$$0(51);
            }
            return v7;
        }
        v8 = ExceptionUtil.getUnhandledExceptions(method, (PsiElement)methodCall, topElement, substitutor);
        if (v8 == null) {
            ExceptionUtil.$$$reportNull$$$0(53);
        }
        return v8;
    }

    public static void retainExceptions(List<PsiClassType> ex, List<PsiClassType> thrownEx) {
        ArrayList<PsiClassType> replacement = new ArrayList<PsiClassType>();
        Iterator<PsiClassType> iterator = ex.iterator();
        while (iterator.hasNext()) {
            PsiClassType classType = iterator.next();
            boolean found = false;
            for (PsiClassType psiClassType : thrownEx) {
                if (psiClassType.isAssignableFrom((PsiType)classType)) {
                    found = true;
                    break;
                }
                if (!classType.isAssignableFrom((PsiType)psiClassType) || ExceptionUtil.isUncheckedException(classType) != ExceptionUtil.isUncheckedException(psiClassType)) continue;
                replacement.add(psiClassType);
            }
            if (found) continue;
            iterator.remove();
        }
        ex.removeAll(replacement);
        ex.addAll(replacement);
    }

    public static List<PsiClassType> collectSubstituted(PsiSubstitutor substitutor, PsiClassType[] thrownExceptions, GlobalSearchScope scope) {
        ArrayList<PsiClassType> ex = new ArrayList<PsiClassType>();
        for (PsiClassType thrownException : thrownExceptions) {
            PsiCapturedWildcardType capturedWildcardType;
            PsiType upperBound;
            PsiType psiType = PsiClassImplUtil.correctType(substitutor.substitute((PsiType)thrownException), scope);
            if (psiType instanceof PsiClassType) {
                ex.add((PsiClassType)psiType);
                continue;
            }
            if (!(psiType instanceof PsiCapturedWildcardType) || !((upperBound = (capturedWildcardType = (PsiCapturedWildcardType)psiType).getUpperBound()) instanceof PsiClassType)) continue;
            ex.add((PsiClassType)upperBound);
        }
        return ex;
    }

    @NotNull
    public static List<PsiClassType> getCloserExceptions(@NotNull PsiResourceListElement resource) {
        List<PsiClassType> ex;
        if (resource == null) {
            ExceptionUtil.$$$reportNull$$$0(54);
        }
        List<Object> list = (ex = ExceptionUtil.getExceptionsFromClose(resource)) != null ? ex : Collections.emptyList();
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(55);
        }
        return list;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(@NotNull PsiResourceListElement resource, @Nullable PsiElement topElement) {
        if (resource == null) {
            ExceptionUtil.$$$reportNull$$$0(56);
        }
        PsiType type2 = resource.getType();
        List<PsiClassType> list = ExceptionUtil.getUnhandledCloserExceptions((PsiElement)resource, topElement, type2);
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(57);
        }
        return list;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(PsiElement place, @Nullable PsiElement topElement, PsiType type2) {
        List<PsiClassType> ex = type2 instanceof PsiClassType ? ExceptionUtil.getExceptionsFromClose(type2, place.getResolveScope()) : null;
        List<PsiClassType> list = ex != null ? ExceptionUtil.getUnhandledExceptions(place, topElement, PsiSubstitutor.EMPTY, ex.toArray(PsiClassType.EMPTY_ARRAY)) : Collections.emptyList();
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(58);
        }
        return list;
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiResourceListElement resource) {
        PsiType type2 = resource.getType();
        return type2 instanceof PsiClassType ? ExceptionUtil.getExceptionsFromClose(type2, resource.getResolveScope()) : null;
    }

    private static List<PsiClassType> getExceptionsFromClose(PsiType type2, GlobalSearchScope scope) {
        PsiClassType.ClassResolveResult resourceType = PsiUtil.resolveGenericsClassInType((PsiType)type2);
        PsiClass resourceClass = resourceType.getElement();
        if (resourceClass == null) {
            return null;
        }
        PsiMethod[] methods = PsiUtil.getResourceCloserMethodsForType((PsiClassType)((PsiClassType)type2));
        if (methods != null) {
            List<PsiClassType> ex = null;
            for (PsiMethod method : methods) {
                PsiSubstitutor substitutor;
                PsiClass closerClass = method.getContainingClass();
                if (closerClass == null || (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)closerClass, (PsiClass)resourceClass, (PsiSubstitutor)resourceType.getSubstitutor())) == null) continue;
                PsiClassType[] exceptionTypes = method.getThrowsList().getReferencedTypes();
                if (exceptionTypes.length == 0) {
                    return Collections.emptyList();
                }
                if (ex == null) {
                    ex = ExceptionUtil.collectSubstituted(substitutor, exceptionTypes, scope);
                    continue;
                }
                ExceptionUtil.retainExceptions(ex, ExceptionUtil.collectSubstituted(substitutor, exceptionTypes, scope));
            }
            return ex;
        }
        return null;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiThrowStatement throwStatement, @Nullable PsiElement topElement) {
        if (throwStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(59);
        }
        SmartList unhandled = new SmartList();
        for (PsiType type2 : ExceptionUtil.getPreciseThrowTypes(throwStatement.getException())) {
            List types = type2 instanceof PsiDisjunctionType ? ((PsiDisjunctionType)type2).getDisjunctions() : Collections.singletonList(type2);
            for (PsiType subType : types) {
                PsiClassType classType;
                if (!(subType instanceof PsiClassType) || ExceptionUtil.isUncheckedException(classType = (PsiClassType)subType) || ExceptionUtil.isHandled((PsiElement)throwStatement, classType, topElement)) continue;
                unhandled.add(classType);
            }
        }
        SmartList smartList = unhandled;
        if (smartList == null) {
            ExceptionUtil.$$$reportNull$$$0(60);
        }
        return smartList;
    }

    @NotNull
    private static List<PsiType> getPreciseThrowTypes(@Nullable PsiExpression expression2) {
        PsiType type2;
        PsiElement target;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)expression2).resolve()) != null && PsiUtil.isCatchParameter((PsiElement)target)) {
            List list = ((PsiCatchSection)target.getParent()).getPreciseCatchTypes();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(61);
            }
            return list;
        }
        if (expression2 != null && (type2 = expression2.getType()) != null) {
            List<PsiType> list = Collections.singletonList(type2);
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(62);
            }
            return list;
        }
        List<PsiType> list = Collections.emptyList();
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(63);
        }
        return list;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(@NotNull PsiMethod method, PsiElement element, PsiElement topElement, @NotNull PsiSubstitutor substitutor) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(64);
        }
        if (substitutor == null) {
            ExceptionUtil.$$$reportNull$$$0(65);
        }
        if (ExceptionUtil.isArrayClone(method, element)) {
            List<PsiClassType> list = Collections.emptyList();
            if (list == null) {
                ExceptionUtil.$$$reportNull$$$0(66);
            }
            return list;
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions(element, topElement, substitutor, referencedTypes);
        if (list == null) {
            ExceptionUtil.$$$reportNull$$$0(67);
        }
        return list;
    }

    private static List<PsiClassType> getUnhandledExceptions(PsiElement element, PsiElement topElement, PsiSubstitutor substitutor, PsiClassType[] referencedTypes) {
        if (referencedTypes.length > 0) {
            ArrayList result = ContainerUtil.newArrayList();
            for (PsiClassType referencedType : referencedTypes) {
                PsiType type2 = PsiClassImplUtil.correctType(GenericsUtil.eliminateWildcards((PsiType)substitutor.substitute((PsiType)referencedType), (boolean)false), element.getResolveScope());
                if (!(type2 instanceof PsiClassType)) continue;
                PsiClassType classType = (PsiClassType)type2;
                PsiClass exceptionClass = ((PsiClassType)type2).resolve();
                if (exceptionClass == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.isHandled(element, classType, topElement)) continue;
                result.add((PsiClassType)type2);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static boolean isArrayClone(@NotNull PsiMethod method, PsiElement element) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(68);
        }
        if (!method.getName().equals(CLONE_METHOD_NAME)) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
            return false;
        }
        if (element instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodCallExpression = (PsiMethodReferenceExpression)element;
            PsiExpression qualifierExpression2 = methodCallExpression.getQualifierExpression();
            return qualifierExpression2 != null && qualifierExpression2.getType() instanceof PsiArrayType;
        }
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpression qualifierExpression3 = methodCallExpression.getMethodExpression().getQualifierExpression();
        return qualifierExpression3 != null && qualifierExpression3.getType() instanceof PsiArrayType;
    }

    public static boolean isUncheckedException(@NotNull PsiClassType type2) {
        if (type2 == null) {
            ExceptionUtil.$$$reportNull$$$0(69);
        }
        return InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.RuntimeException") || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.Error");
    }

    public static boolean isUncheckedException(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ExceptionUtil.$$$reportNull$$$0(70);
        }
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.RuntimeException") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.Error");
    }

    public static boolean isUncheckedExceptionOrSuperclass(@NotNull PsiClassType type2) {
        if (type2 == null) {
            ExceptionUtil.$$$reportNull$$$0(71);
        }
        return ExceptionUtil.isGeneralExceptionType((PsiType)type2) || ExceptionUtil.isUncheckedException(type2);
    }

    public static boolean isGeneralExceptionType(@NotNull PsiType type2) {
        String canonicalText;
        if (type2 == null) {
            ExceptionUtil.$$$reportNull$$$0(72);
        }
        return "java.lang.Throwable".equals(canonicalText = type2.getCanonicalText()) || "java.lang.Exception".equals(canonicalText);
    }

    public static boolean isHandled(@NotNull PsiClassType exceptionType, @NotNull PsiElement throwPlace) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(73);
        }
        if (throwPlace == null) {
            ExceptionUtil.$$$reportNull$$$0(74);
        }
        return ExceptionUtil.isHandled(throwPlace, exceptionType, (PsiElement)throwPlace.getContainingFile());
    }

    private static boolean isHandled(@Nullable PsiElement element, @NotNull PsiClassType exceptionType, PsiElement topElement) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(75);
        }
        if (element == null || element.getParent() == topElement || element.getParent() == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType);
        }
        if (parent instanceof PsiClass) {
            return parent instanceof PsiAnonymousClass && ExceptionUtil.isHandled(parent, exceptionType, topElement);
        }
        if (parent instanceof PsiLambdaExpression || parent instanceof PsiMethodReferenceExpression && element == ((PsiMethodReferenceExpression)parent).getReferenceNameElement()) {
            PsiType interfaceType = ((PsiFunctionalExpression)parent).getFunctionalInterfaceType();
            return ExceptionUtil.isDeclaredBySAMMethod(exceptionType, interfaceType);
        }
        if (parent instanceof PsiClassInitializer) {
            if (((PsiClassInitializer)parent).hasModifierProperty("static")) {
                return false;
            }
            if (!(parent.getParent() instanceof PsiAnonymousClass)) {
                PsiClass aClass = ((PsiClassInitializer)parent).getContainingClass();
                return ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType);
            }
        } else if (parent instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            if (tryStatement.getTryBlock() == element && ExceptionUtil.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            if (tryStatement.getResourceList() == element && ExceptionUtil.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (element instanceof PsiCatchSection && finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
                return true;
            }
        } else {
            if (parent instanceof JavaCodeFragment) {
                JavaCodeFragment codeFragment = (JavaCodeFragment)parent;
                JavaCodeFragment.ExceptionHandler exceptionHandler = codeFragment.getExceptionHandler();
                return exceptionHandler != null && exceptionHandler.isHandledException(exceptionType);
            }
            if (PsiImplUtil.isInServerPage(parent) && parent instanceof PsiFile) {
                return true;
            }
            if (parent instanceof PsiFile) {
                return false;
            }
            if (parent instanceof PsiField && ((PsiField)parent).getInitializer() == element) {
                PsiClass aClass = ((PsiField)parent).getContainingClass();
                if (aClass != null && !(aClass instanceof PsiAnonymousClass) && !((PsiField)parent).hasModifierProperty("static")) {
                    return ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType);
                }
            } else {
                for (CustomExceptionHandler exceptionHandler : (CustomExceptionHandler[])Extensions.getExtensions(CustomExceptionHandler.KEY)) {
                    if (!exceptionHandler.isHandled(element, exceptionType, topElement)) continue;
                    return true;
                }
            }
        }
        return ExceptionUtil.isHandled(parent, exceptionType, topElement);
    }

    private static boolean isDeclaredBySAMMethod(@NotNull PsiClassType exceptionType, @Nullable PsiType interfaceType) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiMethod interfaceMethod;
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(76);
        }
        if (interfaceType != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)(resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)interfaceType)))) != null) {
            return ExceptionUtil.isHandledByMethodThrowsClause(interfaceMethod, exceptionType, LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult));
        }
        return true;
    }

    private static boolean areAllConstructorsThrow(@Nullable PsiClass aClass, @NotNull PsiClassType exceptionType) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(77);
        }
        if (aClass == null) {
            return false;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        boolean thrown = constructors.length != 0;
        for (PsiMethod constructor : constructors) {
            if (ExceptionUtil.isHandledByMethodThrowsClause(constructor, exceptionType)) continue;
            thrown = false;
            break;
        }
        return thrown;
    }

    private static boolean isCaught(@NotNull PsiTryStatement tryStatement, @NotNull PsiClassType exceptionType) {
        PsiParameter[] catchBlockParameters;
        PsiCodeBlock finallyBlock;
        if (tryStatement == null) {
            ExceptionUtil.$$$reportNull$$$0(78);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(79);
        }
        if ((finallyBlock = tryStatement.getFinallyBlock()) != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
            return true;
        }
        for (PsiParameter parameter2 : catchBlockParameters = tryStatement.getCatchBlockParameters()) {
            PsiType paramType = parameter2.getType();
            if (!paramType.isAssignableFrom((PsiType)exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static boolean blockCompletesAbruptly(@NotNull PsiCodeBlock finallyBlock) {
        if (finallyBlock == null) {
            ExceptionUtil.$$$reportNull$$$0(80);
        }
        try {
            ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow((PsiElement)finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
            int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
            if (!BitUtil.isSet((int)completionReasons, (int)1)) {
                return true;
            }
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return false;
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(81);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(82);
        }
        return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType, PsiSubstitutor.EMPTY);
    }

    private static boolean isHandledByMethodThrowsClause(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, PsiSubstitutor substitutor) {
        if (method == null) {
            ExceptionUtil.$$$reportNull$$$0(83);
        }
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(84);
        }
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes, substitutor);
    }

    public static boolean isHandledBy(@NotNull PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(85);
        }
        if (referencedTypes == null) {
            ExceptionUtil.$$$reportNull$$$0(86);
        }
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes, PsiSubstitutor.EMPTY);
    }

    public static boolean isHandledBy(@NotNull PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes, PsiSubstitutor substitutor) {
        if (exceptionType == null) {
            ExceptionUtil.$$$reportNull$$$0(87);
        }
        if (referencedTypes == null) {
            ExceptionUtil.$$$reportNull$$$0(88);
        }
        for (PsiClassType classType : referencedTypes) {
            PsiType psiType = substitutor.substitute((PsiType)classType);
            if (psiType == null || !psiType.isAssignableFrom((PsiType)exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static void sortExceptionsByHierarchy(@NotNull List<PsiClassType> exceptions) {
        if (exceptions == null) {
            ExceptionUtil.$$$reportNull$$$0(89);
        }
        if (exceptions.size() <= 1) {
            return;
        }
        ExceptionUtil.sortExceptionsByHierarchy(exceptions.subList(1, exceptions.size()));
        for (int i = 0; i < exceptions.size() - 1; ++i) {
            if (!TypeConversionUtil.isAssignable((PsiType)((PsiType)exceptions.get(i)), (PsiType)((PsiType)exceptions.get(i + 1)))) continue;
            Collections.swap(exceptions, i, i + 1);
        }
    }

    private static /* synthetic */ Pair lambda$getUnhandledExceptions$0(PsiMethod method, CandidateInfo info) {
        PsiElement element1 = info.getElement();
        if (info instanceof MethodCandidateInfo && element1 != method && MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)((PsiMethod)element1)) && !MethodSignatureUtil.isSuperMethod((PsiMethod)((PsiMethod)element1), (PsiMethod)method) && (!((MethodCandidateInfo)info).isToInferApplicability() || ((MethodCandidateInfo)info).isApplicable())) {
            return Pair.create((Object)((PsiMethod)element1), (Object)((MethodCandidateInfo)info).getSubstitutor(false));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 66: 
            case 67: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 66: 
            case 67: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/ExceptionUtil";
                break;
            }
            case 5: 
            case 20: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 7: 
            case 11: 
            case 22: 
            case 24: 
            case 26: 
            case 33: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 14: 
            case 64: 
            case 68: 
            case 81: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 15: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReferenceExpression";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorBody";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwStatement";
                break;
            }
            case 69: 
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 82: 
            case 84: 
            case 85: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwPlace";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finallyBlock";
                break;
            }
            case 86: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/ExceptionUtil";
                break;
            }
            case 1: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownExceptions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrownCheckedExceptions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutUncheckedExceptions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTryExceptions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionsByMethodAndChildren";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionsByMethod";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnhandledExceptions";
                break;
            }
            case 28: 
            case 29: 
            case 32: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnhandledExceptions";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnUnhandledExceptions";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloserExceptions";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnhandledCloserExceptions";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreciseThrowTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThrownExceptions";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 66: 
            case 67: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getThrownCheckedExceptions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterOutUncheckedExceptions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTryExceptions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionsByMethodAndChildren";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionsByMethod";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addExceptions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addException";
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collectUnhandledExceptions";
                break;
            }
            case 27: 
            case 31: 
            case 41: 
            case 43: 
            case 45: 
            case 59: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getUnhandledExceptions";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "firstStatementIsConstructorCall";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getOwnUnhandledExceptions";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getCloserExceptions";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getUnhandledCloserExceptions";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isArrayClone";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isUncheckedException";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isUncheckedExceptionOrSuperclass";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isGeneralExceptionType";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isHandled";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredBySAMMethod";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "areAllConstructorsThrow";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isCaught";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "blockCompletesAbruptly";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "isHandledByMethodThrowsClause";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "isHandledBy";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "sortExceptionsByHierarchy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 66: 
            case 67: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

