/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerNotNullableSerializer;

@State(name="NullableNotNullManager")
public class NullableNotNullManagerImpl
extends NullableNotNullManager
implements PersistentStateComponent<Element> {
    public static final String TYPE_QUALIFIER_NICKNAME = "javax.annotation.meta.TypeQualifierNickname";

    public NullableNotNullManagerImpl(Project project) {
        super(project);
        this.myNotNulls.addAll(this.getPredefinedNotNulls());
    }

    public List<String> getPredefinedNotNulls() {
        return JpsJavaCompilerNotNullableSerializer.DEFAULT_NOT_NULLS;
    }

    protected boolean hasHardcodedContracts(PsiElement element) {
        return HardcodedContracts.hasHardcodedContracts(element);
    }

    public Element getState() {
        Element component = new Element("component");
        if (this.hasDefaultValues()) {
            return component;
        }
        try {
            DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)component);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        return component;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(0);
        }
        try {
            DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)state);
            if (this.myNullables.isEmpty()) {
                Collections.addAll(this.myNullables, DEFAULT_NULLABLES);
            }
            if (this.myNotNulls.isEmpty()) {
                this.myNotNulls.addAll(this.getPredefinedNotNulls());
            }
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    private List<PsiClass> getAllNullabilityNickNames() {
        if (!this.getNotNulls().contains("javax.annotation.Nonnull")) {
            return Collections.emptyList();
        }
        return (List)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> {
            ArrayList result = new ArrayList();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
            for (PsiClass tqNick : JavaPsiFacade.getInstance((Project)this.myProject).findClasses(TYPE_QUALIFIER_NICKNAME, scope)) {
                result.addAll(ContainerUtil.findAll((Collection)MetaAnnotationUtil.getChildren((PsiClass)tqNick, (GlobalSearchScope)scope), candidate -> {
                    String qname = candidate.getQualifiedName();
                    if (qname == null || qname.startsWith("javax.annotation.")) {
                        return false;
                    }
                    return NullableNotNullManagerImpl.getNickNamedNullability(candidate) != Nullness.UNKNOWN;
                }));
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static Nullness getNickNamedNullability(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(1);
        }
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{TYPE_QUALIFIER_NICKNAME}) == null) {
            return Nullness.UNKNOWN;
        }
        PsiAnnotation nonNull = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{"javax.annotation.Nonnull"});
        return nonNull != null ? NullableNotNullManagerImpl.extractNullityFromWhenValue(nonNull) : Nullness.UNKNOWN;
    }

    @NotNull
    private static Nullness extractNullityFromWhenValue(PsiAnnotation nonNull) {
        PsiAnnotationMemberValue when = nonNull.findAttributeValue("when");
        if (when instanceof PsiReferenceExpression) {
            String refName = ((PsiReferenceExpression)when).getReferenceName();
            if ("ALWAYS".equals(refName)) {
                Nullness nullness = Nullness.NOT_NULL;
                if (nullness == null) {
                    NullableNotNullManagerImpl.$$$reportNull$$$0(2);
                }
                return nullness;
            }
            if ("MAYBE".equals(refName) || "NEVER".equals(refName)) {
                Nullness nullness = Nullness.NULLABLE;
                if (nullness == null) {
                    NullableNotNullManagerImpl.$$$reportNull$$$0(3);
                }
                return nullness;
            }
        }
        Nullness nullness = Nullness.UNKNOWN;
        if (nullness == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(4);
        }
        return nullness;
    }

    private List<String> filterNickNames(Nullness nullness) {
        return ((StreamEx)StreamEx.of(this.getAllNullabilityNickNames()).filter(c -> NullableNotNullManagerImpl.getNickNamedNullability(c) == nullness)).map(PsiClass::getQualifiedName).toList();
    }

    @NotNull
    protected List<String> getNullablesWithNickNames() {
        List list = (List)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)ContainerUtil.concat((List)this.getNullables(), this.filterNickNames(Nullness.NULLABLE)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (list == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    protected List<String> getNotNullsWithNickNames() {
        List list = (List)CachedValuesManager.getManager((Project)this.myProject).getCachedValue((UserDataHolder)this.myProject, () -> CachedValueProvider.Result.create((Object)ContainerUtil.concat((List)this.getNotNulls(), this.filterNickNames(Nullness.NOT_NULL)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (list == null) {
            NullableNotNullManagerImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/NullableNotNullManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/NullableNotNullManagerImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNullityFromWhenValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullablesWithNickNames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullsWithNickNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNickNamedNullability";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

