/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionSession {
    private final Set<String> myAddedClasses = new HashSet<String>();
    private final Set<String> myKeywords = new HashSet<String>();
    private final MultiMap<CompletionResultSet, LookupElement> myBatchItems = MultiMap.create();
    private final CompletionResultSet myResult;

    public JavaCompletionSession(CompletionResultSet result) {
        this.myResult = result;
    }

    void registerBatchItems(CompletionResultSet result, Collection<LookupElement> elements) {
        this.myBatchItems.putValues((Object)result, elements);
    }

    void flushBatchItems() {
        for (Map.Entry entry : this.myBatchItems.entrySet()) {
            ((CompletionResultSet)entry.getKey()).addAllElements((Iterable)entry.getValue());
        }
        this.myBatchItems.clear();
    }

    public void addClassItem(LookupElement lookupElement) {
        PsiClass psiClass = JavaCompletionSession.extractClass(lookupElement);
        if (psiClass != null) {
            this.registerClass(psiClass);
        }
        this.myResult.addElement(AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy(lookupElement));
    }

    @NotNull
    PrefixMatcher getMatcher() {
        PrefixMatcher prefixMatcher = this.myResult.getPrefixMatcher();
        if (prefixMatcher == null) {
            JavaCompletionSession.$$$reportNull$$$0(0);
        }
        return prefixMatcher;
    }

    @Nullable
    private static PsiClass extractClass(LookupElement lookupElement) {
        Object object = lookupElement.getObject();
        if (object instanceof PsiClass) {
            return (PsiClass)object;
        }
        if (object instanceof PsiMethod && ((PsiMethod)object).isConstructor()) {
            return ((PsiMethod)object).getContainingClass();
        }
        return null;
    }

    public void registerClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaCompletionSession.$$$reportNull$$$0(1);
        }
        ContainerUtil.addIfNotNull(this.myAddedClasses, (Object)JavaCompletionSession.getClassName(psiClass));
    }

    @Nullable
    private static String getClassName(@NotNull PsiClass psiClass) {
        String name;
        if (psiClass == null) {
            JavaCompletionSession.$$$reportNull$$$0(2);
        }
        return (name = psiClass.getQualifiedName()) == null ? psiClass.getName() : name;
    }

    public boolean alreadyProcessed(@NotNull LookupElement element) {
        PsiClass psiClass;
        if (element == null) {
            JavaCompletionSession.$$$reportNull$$$0(3);
        }
        return (psiClass = JavaCompletionSession.extractClass(element)) != null && this.alreadyProcessed(psiClass);
    }

    public boolean alreadyProcessed(@NotNull PsiClass object) {
        String name;
        if (object == null) {
            JavaCompletionSession.$$$reportNull$$$0(4);
        }
        return (name = JavaCompletionSession.getClassName(object)) == null || this.myAddedClasses.contains(name);
    }

    public boolean isKeywordAlreadyProcessed(@NotNull String keyword) {
        if (keyword == null) {
            JavaCompletionSession.$$$reportNull$$$0(5);
        }
        return this.myKeywords.contains(keyword);
    }

    void registerKeyword(@NotNull String keyword) {
        if (keyword == null) {
            JavaCompletionSession.$$$reportNull$$$0(6);
        }
        this.myKeywords.add(keyword);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/JavaCompletionSession";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatcher";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/JavaCompletionSession";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClassName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "alreadyProcessed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isKeywordAlreadyProcessed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerKeyword";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

