/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeleteMultiCatchFix
implements IntentionAction {
    private final PsiTypeElement myTypeElement;

    public DeleteMultiCatchFix(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            DeleteMultiCatchFix.$$$reportNull$$$0(0);
        }
        this.myTypeElement = typeElement;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("delete.catch.text", JavaHighlightUtil.formatType(this.myTypeElement.getType()));
        if (string == null) {
            DeleteMultiCatchFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("delete.catch.family", new Object[0]);
        if (string == null) {
            DeleteMultiCatchFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            DeleteMultiCatchFix.$$$reportNull$$$0(3);
        }
        return this.myTypeElement.isValid() && PsiManager.getInstance((Project)project).isInProject((PsiElement)this.myTypeElement.getContainingFile());
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            DeleteMultiCatchFix.$$$reportNull$$$0(4);
        }
        PsiTypeElement psiTypeElement = this.myTypeElement;
        if (psiTypeElement == null) {
            DeleteMultiCatchFix.$$$reportNull$$$0(5);
        }
        return psiTypeElement;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement last;
        PsiTypeElement first;
        PsiElement parentType;
        if (project == null) {
            DeleteMultiCatchFix.$$$reportNull$$$0(6);
        }
        if (!((parentType = this.myTypeElement.getParent()) instanceof PsiTypeElement)) {
            return;
        }
        PsiElement right = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)this.myTypeElement);
        if (PsiUtil.isJavaToken((PsiElement)right, (IElementType)JavaTokenType.OR)) {
            first = this.myTypeElement;
            last = right;
        } else if (right == null) {
            PsiElement left = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)this.myTypeElement);
            if (!(left instanceof PsiJavaToken)) {
                return;
            }
            IElementType leftType = ((PsiJavaToken)left).getTokenType();
            if (leftType != JavaTokenType.OR) {
                return;
            }
            first = left;
            last = this.myTypeElement;
        } else {
            return;
        }
        parentType.deleteChildRange((PsiElement)first, last);
        List typeElements = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)parentType, PsiTypeElement.class);
        if (typeElements.size() == 1) {
            PsiElement parameter2 = parentType.getParent();
            parameter2.addRangeAfter(parentType.getFirstChild(), parentType.getLastChild(), parentType);
            parentType.delete();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/DeleteMultiCatchFix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/DeleteMultiCatchFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToMakeWritable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

