/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.TemplateLookupSelectionHandler;
import com.intellij.codeInsight.template.impl.JavaTemplateLookupSelectionHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Set;

public class JavaTemplateUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.template.impl.JavaTemplateUtil");

    private JavaTemplateUtil() {
    }

    public static void updateTypeBindings(Object item, PsiFile file, Document document, int segmentStart, int segmentEnd) {
        JavaTemplateUtil.updateTypeBindings(item, file, document, segmentStart, segmentEnd, false);
    }

    public static void updateTypeBindings(Object item, PsiFile file, Document document, int segmentStart, int segmentEnd, boolean noImport) {
        Project project = file.getProject();
        ArrayList<PsiClass> classes2 = new ArrayList<PsiClass>();
        if (item instanceof PsiClass) {
            classes2.add((PsiClass)item);
        } else if (item instanceof PsiClassType) {
            PsiTypesUtil.TypeParameterSearcher searcher = new PsiTypesUtil.TypeParameterSearcher();
            ((PsiClassType)item).accept((PsiTypeVisitor)searcher);
            classes2.addAll(searcher.getTypeParameters());
        }
        if (!classes2.isEmpty()) {
            for (PsiClass aClass : classes2) {
                if (aClass instanceof PsiTypeParameter) {
                    PsiTypeParameter[] params;
                    PsiTypeParameterListOwner owner;
                    PsiElement element = file.findElementAt(segmentStart);
                    PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
                    if (method == null || !method.hasModifierProperty("static") && PsiTreeUtil.isAncestor((PsiElement)(owner = ((PsiTypeParameter)aClass).getOwner()), (PsiElement)method, (boolean)false)) continue;
                    PsiTypeParameterList paramList = method.getTypeParameterList();
                    for (PsiTypeParameter param : params = paramList != null ? paramList.getTypeParameters() : PsiTypeParameter.EMPTY_ARRAY) {
                        if (!param.getName().equals(aClass.getName())) continue;
                        return;
                    }
                    try {
                        if (paramList == null) {
                            PsiTypeParameterList newList = JVMElementFactories.getFactory((Language)method.getLanguage(), (Project)project).createTypeParameterList();
                            paramList = (PsiTypeParameterList)method.addAfter((PsiElement)newList, (PsiElement)method.getModifierList());
                        }
                        paramList.add(aClass.copy());
                        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                    continue;
                }
                if (noImport) continue;
                JavaTemplateUtil.addImportForClass(document, aClass, segmentStart, segmentEnd);
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
            }
        }
    }

    public static void addImportForClass(Document document, PsiClass aClass, int start, int end) {
        Project project = aClass.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (!aClass.isValid() || aClass.getQualifiedName() == null) {
            return;
        }
        JavaPsiFacade manager = JavaPsiFacade.getInstance((Project)project);
        PsiResolveHelper helper = manager.getResolveHelper();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        CharSequence chars = document.getCharsSequence();
        PsiElement element = file.findElementAt(start);
        String refText = chars.subSequence(start, end).toString();
        PsiClass refClass = helper.resolveReferencedClass(refText, element);
        if (aClass.equals(refClass)) {
            return;
        }
        if (element instanceof PsiIdentifier) {
            PsiElement tmp;
            PsiElement parent = element.getParent();
            while (parent != null && (tmp = parent.getParent()) instanceof PsiJavaCodeReferenceElement && tmp.getTextRange().getEndOffset() <= end) {
                parent = tmp;
            }
            if (parent instanceof PsiJavaCodeReferenceElement && !((PsiJavaCodeReferenceElement)parent).isQualified()) {
                PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)parent;
                ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        ref.bindToElement((PsiElement)aClass);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                });
            }
        }
    }

    public static LookupElement addElementLookupItem(Set<LookupElement> items, PsiElement element) {
        LookupElement item = LookupItemUtil.objectToLookupItem(element);
        items.add(item);
        item.putUserData(TemplateLookupSelectionHandler.KEY_IN_LOOKUP_ITEM, (Object)new JavaTemplateLookupSelectionHandler());
        return item;
    }

    public static LookupElement addTypeLookupItem(Set<LookupElement> items, PsiType type2) {
        PsiTypeLookupItem item = PsiTypeLookupItem.createLookupItem(type2, null);
        items.add((LookupElement)item);
        item.putUserData(TemplateLookupSelectionHandler.KEY_IN_LOOKUP_ITEM, new JavaTemplateLookupSelectionHandler());
        return item;
    }
}

