/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.siyeh.ig.controlflow.UnnecessaryReturnInspection;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeVoidQuickFix
implements LocalQuickFix {
    private final ProblemDescriptionsProcessor myProcessor;
    private static final Logger LOG = Logger.getInstance(MakeVoidQuickFix.class);

    public MakeVoidQuickFix(@Nullable ProblemDescriptionsProcessor processor) {
        this.myProcessor = processor;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"inspection.unused.return.value.make.void.quickfix", (Object[])new Object[0]);
        if (string == null) {
            MakeVoidQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            MakeVoidQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            MakeVoidQuickFix.$$$reportNull$$$0(2);
        }
        PsiMethod psiMethod = null;
        if (this.myProcessor != null) {
            RefElement refElement = (RefElement)this.myProcessor.getElement((CommonProblemDescriptor)descriptor);
            if (refElement instanceof RefMethod && refElement.isValid()) {
                RefMethod refMethod = (RefMethod)refElement;
                psiMethod = (PsiMethod)refMethod.getElement();
            }
        } else {
            psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
        }
        if (psiMethod == null) {
            return;
        }
        MakeVoidQuickFix.makeMethodHierarchyVoid(project, psiMethod);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            MakeVoidQuickFix.$$$reportNull$$$0(3);
        }
        return currentFile;
    }

    private static void makeMethodHierarchyVoid(Project project, @NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            MakeVoidQuickFix.$$$reportNull$$$0(4);
        }
        SmartList methodsToModify = new SmartList((Object)psiMethod);
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (psiMethod == null) {
                MakeVoidQuickFix.$$$reportNull$$$0(6);
            }
            methodsToModify.addAll(OverridingMethodsSearch.search((PsiMethod)psiMethod).findAll());
        }, InspectionsBundle.message((String)"psi.search.overriding.progress", (Object[])new Object[0]), true, project)) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)methodsToModify)) {
            return;
        }
        for (PsiMethod method : methodsToModify) {
            MakeVoidQuickFix.replaceReturnStatements(method);
        }
        ChangeSignatureProcessor csp = new ChangeSignatureProcessor(project, psiMethod, false, null, psiMethod.getName(), (PsiType)PsiType.VOID, ParameterInfoImpl.fromMethod(psiMethod));
        csp.run();
    }

    private static void replaceReturnStatements(@NotNull PsiMethod method) {
        PsiReturnStatement[] statements;
        if (method == null) {
            MakeVoidQuickFix.$$$reportNull$$$0(5);
        }
        if ((statements = PsiUtil.findReturnStatements((PsiMethod)method)).length > 0) {
            WriteAction.run(() -> {
                for (int i = statements.length - 1; i >= 0; --i) {
                    PsiReturnStatement returnStatement = statements[i];
                    try {
                        PsiExpression expression2 = returnStatement.getReturnValue();
                        if (expression2 == null) continue;
                        List<PsiExpression> sideEffectExpressions = SideEffectChecker.extractSideEffectExpressions(expression2);
                        PsiStatement[] sideEffectStatements = StatementExtractor.generateStatements(sideEffectExpressions, expression2);
                        if (sideEffectStatements.length > 0) {
                            PsiStatement added = BlockUtils.addBefore((PsiStatement)returnStatement, sideEffectStatements);
                            returnStatement = (PsiReturnStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)added, PsiReturnStatement.class);
                        }
                        if (returnStatement == null || returnStatement.getReturnValue() == null) continue;
                        returnStatement.getReturnValue().delete();
                        if (!UnnecessaryReturnInspection.isReturnRedundant(returnStatement, false, null)) continue;
                        returnStatement.delete();
                        continue;
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/MakeVoidQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/MakeVoidQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "makeMethodHierarchyVoid";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceReturnStatements";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$makeMethodHierarchyVoid$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

