/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ReflectionUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SetInspectionOptionFix
implements LocalQuickFix,
LowPriorityAction,
Iconable {
    private final String myShortName;
    private final String myProperty;
    private final String myMessage;
    private final boolean myValue;

    public SetInspectionOptionFix(InspectionProfileEntry inspection, String property, String message2, boolean value2) {
        this.myShortName = inspection.getShortName();
        this.myProperty = property;
        this.myMessage = message2;
        this.myValue = value2;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.myMessage;
        if (string == null) {
            SetInspectionOptionFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Set inspection option" == null) {
            SetInspectionOptionFix.$$$reportNull$$$0(1);
        }
        return "Set inspection option";
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            SetInspectionOptionFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            SetInspectionOptionFix.$$$reportNull$$$0(3);
        }
        this.setOption(project, this.myValue);
        VirtualFile vFile = descriptor.getPsiElement().getContainingFile().getVirtualFile();
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{vFile}){

            public void undo() {
                SetInspectionOptionFix.this.setOption(project, !SetInspectionOptionFix.this.myValue);
            }

            public void redo() {
                SetInspectionOptionFix.this.setOption(project, SetInspectionOptionFix.this.myValue);
            }
        });
    }

    private void setOption(@NotNull Project project, boolean value2) {
        if (project == null) {
            SetInspectionOptionFix.$$$reportNull$$$0(4);
        }
        InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, model -> {
            InspectionToolWrapper tool;
            if (project == null) {
                SetInspectionOptionFix.$$$reportNull$$$0(5);
            }
            if ((tool = model.getInspectionTool(this.myShortName, project)) == null) {
                return;
            }
            InspectionProfileEntry inspection = tool.getTool();
            ReflectionUtil.setField(inspection.getClass(), (Object)inspection, Boolean.TYPE, (String)this.myProperty, (Object)value2);
        });
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.Cancel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SetInspectionOptionFix";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SetInspectionOptionFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setOption";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setOption$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

