/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.javaDoc.JavaDocReferenceInspectionBase;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.FQNameCellRenderer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.ui.components.JBList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class JavaDocReferenceInspection
extends JavaDocReferenceInspectionBase {
    @Override
    protected LocalQuickFix createAddQualifierFix(PsiJavaCodeReferenceElement reference) {
        List<PsiClass> classesToImport = new ImportClassFix(reference).getClassesToImport();
        return classesToImport.isEmpty() ? null : new AddQualifierFix(classesToImport);
    }

    @Override
    protected RenameReferenceQuickFix createRenameReferenceQuickFix(Set<String> unboundParams) {
        return new RenameReferenceQuickFix(unboundParams);
    }

    private static class AddQualifierFix
    implements LocalQuickFix {
        private final List<PsiClass> originalClasses;

        public AddQualifierFix(List<PsiClass> originalClasses) {
            this.originalClasses = originalClasses;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("add.qualifier", new Object[0]);
            if (string == null) {
                AddQualifierFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiJavaCodeReferenceElement element;
            if (project == null) {
                AddQualifierFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AddQualifierFix.$$$reportNull$$$0(2);
            }
            if ((element = (PsiJavaCodeReferenceElement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiJavaCodeReferenceElement.class)) != null) {
                Collections.sort(this.originalClasses, new PsiProximityComparator(element.getElement()));
                JBList list = new JBList((Object[])this.originalClasses.toArray(PsiClass.EMPTY_ARRAY));
                list.setCellRenderer(new FQNameCellRenderer());
                Runnable runnable = () -> this.lambda$applyFix$0(element, (JList)list, project);
                AsyncResult asyncResult = DataManager.getInstance().getDataContextFromFocus();
                asyncResult.doWhenDone(arg_0 -> AddQualifierFix.lambda$applyFix$1((JList)list, runnable, arg_0));
            }
        }

        private static /* synthetic */ void lambda$applyFix$1(JList list, Runnable runnable, DataContext dataContext) {
            new PopupChooserBuilder(list).setTitle(QuickFixBundle.message("add.qualifier.original.class.chooser.title", new Object[0])).setItemChoosenCallback(runnable).createPopup().showInBestPositionFor(dataContext);
        }

        private /* synthetic */ void lambda$applyFix$0(final PsiJavaCodeReferenceElement element, JList list, final @NotNull Project project) {
            if (project == null) {
                AddQualifierFix.$$$reportNull$$$0(3);
            }
            if (!element.isValid()) {
                return;
            }
            final int index = list.getSelectedIndex();
            if (index < 0) {
                return;
            }
            new WriteCommandAction(project, new PsiFile[]{element.getContainingFile()}){

                protected void run(@NotNull Result result) throws Throwable {
                    PsiClass psiClass;
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((psiClass = (PsiClass)originalClasses.get(index)).isValid()) {
                        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                        element.bindToElement((PsiElement)psiClass);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$AddQualifierFix$1", "run"));
                }
            }.execute();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$AddQualifierFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$AddQualifierFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$applyFix$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RenameReferenceQuickFix
    implements LocalQuickFix {
        private final Set<String> myUnboundParams;

        public RenameReferenceQuickFix(Set<String> unboundParams) {
            this.myUnboundParams = unboundParams;
        }

        @NotNull
        public String getFamilyName() {
            if ("Change to ..." == null) {
                RenameReferenceQuickFix.$$$reportNull$$$0(0);
            }
            return "Change to ...";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RenameReferenceQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RenameReferenceQuickFix.$$$reportNull$$$0(2);
            }
            AsyncResult asyncResult = DataManager.getInstance().getDataContextFromFocus();
            asyncResult.doWhenDone(dataContext -> {
                if (descriptor == null) {
                    RenameReferenceQuickFix.$$$reportNull$$$0(3);
                }
                if (project == null) {
                    RenameReferenceQuickFix.$$$reportNull$$$0(4);
                }
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                assert (editor != null);
                TextRange textRange = ((ProblemDescriptorBase)descriptor).getTextRange();
                editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
                String word = editor.getSelectionModel().getSelectedText();
                if (word == null || StringUtil.isEmptyOrSpaces((String)word)) {
                    return;
                }
                ArrayList<LookupElementBuilder> items = new ArrayList<LookupElementBuilder>();
                for (String variant : this.myUnboundParams) {
                    items.add(LookupElementBuilder.create((String)variant));
                }
                LookupManager.getInstance((Project)project).showLookup(editor, items.toArray(LookupElement.EMPTY_ARRAY));
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RenameReferenceQuickFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RenameReferenceQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$applyFix$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

