/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.uncheckedWarnings;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableArrayTypeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.ChangeVariableTypeQuickFixProvider;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JCheckBox;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UncheckedWarningLocalInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "UNCHECKED_WARNING";
    public static final String DISPLAY_NAME = InspectionsBundle.message((String)"unchecked.warning", (Object[])new Object[0]);
    @NonNls
    private static final String ID = "unchecked";
    private static final Logger LOG = Logger.getInstance((String)("#" + UncheckedWarningLocalInspectionBase.class));
    public boolean IGNORE_UNCHECKED_ASSIGNMENT;
    public boolean IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION;
    public boolean IGNORE_UNCHECKED_CALL;
    public boolean IGNORE_UNCHECKED_CAST;
    public boolean IGNORE_UNCHECKED_OVERRIDING;

    @NotNull
    static JCheckBox createSetting(@NotNull String cbText, boolean option, @NotNull Pass<JCheckBox> pass) {
        if (cbText == null) {
            UncheckedWarningLocalInspectionBase.$$$reportNull$$$0(0);
        }
        if (pass == null) {
            UncheckedWarningLocalInspectionBase.$$$reportNull$$$0(1);
        }
        JCheckBox uncheckedCb = new JCheckBox(cbText, option);
        uncheckedCb.addActionListener(e -> {
            if (pass == null) {
                UncheckedWarningLocalInspectionBase.$$$reportNull$$$0(16);
            }
            pass.pass((Object)uncheckedCb);
        });
        JCheckBox jCheckBox = uncheckedCb;
        if (jCheckBox == null) {
            UncheckedWarningLocalInspectionBase.$$$reportNull$$$0(2);
        }
        return jCheckBox;
    }

    @NotNull
    private static LocalQuickFix[] getChangeVariableTypeFixes(@NotNull PsiVariable parameter2, @Nullable PsiType itemType, LocalQuickFix[] generifyFixes) {
        if (parameter2 == null) {
            UncheckedWarningLocalInspectionBase.$$$reportNull$$$0(3);
        }
        if (itemType instanceof PsiMethodReferenceType) {
            if (generifyFixes == null) {
                UncheckedWarningLocalInspectionBase.$$$reportNull$$$0(4);
            }
            return generifyFixes;
        }
        LOG.assertTrue(parameter2.isValid());
        ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
        if (itemType != null) {
            for (ChangeVariableTypeQuickFixProvider fixProvider : (ChangeVariableTypeQuickFixProvider[])Extensions.getExtensions((ExtensionPointName)ChangeVariableTypeQuickFixProvider.EP_NAME)) {
                for (IntentionAction action : fixProvider.getFixes(parameter2, itemType)) {
                    if (!(action instanceof LocalQuickFix)) continue;
                    result.add((LocalQuickFix)action);
                }
            }
        }
        if (generifyFixes.length > 0) {
            Collections.addAll(result, generifyFixes);
        }
        LocalQuickFix[] localQuickFixArray = result.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            UncheckedWarningLocalInspectionBase.$$$reportNull$$$0(5);
        }
        return localQuickFixArray;
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            UncheckedWarningLocalInspectionBase.$$$reportNull$$$0(6);
        }
        return "";
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            UncheckedWarningLocalInspectionBase.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            UncheckedWarningLocalInspectionBase.$$$reportNull$$$0(8);
        }
        return SHORT_NAME;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    @NonNls
    public String getID() {
        if (ID == null) {
            UncheckedWarningLocalInspectionBase.$$$reportNull$$$0(9);
        }
        return ID;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            UncheckedWarningLocalInspectionBase.$$$reportNull$$$0(10);
        }
        if (this.IGNORE_UNCHECKED_ASSIGNMENT || this.IGNORE_UNCHECKED_CALL || this.IGNORE_UNCHECKED_CAST || this.IGNORE_UNCHECKED_OVERRIDING || this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
            super.writeSettings(node);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        LanguageLevel languageLevel;
        if (holder == null) {
            UncheckedWarningLocalInspectionBase.$$$reportNull$$$0(11);
        }
        if (session == null) {
            UncheckedWarningLocalInspectionBase.$$$reportNull$$$0(12);
        }
        if (!(languageLevel = PsiUtil.getLanguageLevel((PsiElement)session.getFile())).isAtLeast(LanguageLevel.JDK_1_5)) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
            if (psiElementVisitor == null) {
                UncheckedWarningLocalInspectionBase.$$$reportNull$$$0(13);
            }
            return psiElementVisitor;
        }
        UncheckedWarningsVisitor uncheckedWarningsVisitor = new UncheckedWarningsVisitor(isOnTheFly, languageLevel){

            @Override
            protected void registerProblem(@NotNull String message2, @Nullable PsiElement callExpression, @NotNull PsiElement psiElement, @NotNull LocalQuickFix[] quickFixes) {
                String rawExpression;
                if (message2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (psiElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (quickFixes == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((rawExpression = UncheckedWarningLocalInspectionBase.isMethodCalledOnRawType(callExpression)) != null) {
                    String referenceName = ((PsiMethodCallExpression)callExpression).getMethodExpression().getReferenceName();
                    message2 = message2 + ". Reason: '" + rawExpression + "' has raw type, so result of " + referenceName + " is erased";
                }
                holder.registerProblem(psiElement, message2, quickFixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "psiElement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "quickFixes";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase$1";
                objectArray[2] = "registerProblem";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (uncheckedWarningsVisitor == null) {
            UncheckedWarningLocalInspectionBase.$$$reportNull$$$0(14);
        }
        return uncheckedWarningsVisitor;
    }

    @NotNull
    protected LocalQuickFix[] createFixes() {
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            UncheckedWarningLocalInspectionBase.$$$reportNull$$$0(15);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static String isMethodCalledOnRawType(PsiElement expression2) {
        PsiClass qualifierClass;
        PsiExpression qualifierExpression2;
        if (expression2 instanceof PsiMethodCallExpression && (qualifierExpression2 = ((PsiMethodCallExpression)expression2).getMethodExpression().getQualifierExpression()) != null && (qualifierClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifierExpression2.getType())) != null && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)qualifierClass, (PsiSubstitutor)((PsiMethodCallExpression)expression2).resolveMethodGenerics().getSubstitutor())) {
            return qualifierExpression2.getText();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cbText";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pass";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetting";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeVariableTypeFixes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSetting";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChangeVariableTypeFixes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createSetting$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class UncheckedWarningsVisitor
    extends JavaElementVisitor {
        private final boolean myOnTheFly;
        @NotNull
        private final LanguageLevel myLanguageLevel;
        private final LocalQuickFix[] myGenerifyFixes;

        UncheckedWarningsVisitor(@NotNull boolean onTheFly, LanguageLevel level) {
            if (level == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(0);
            }
            this.myOnTheFly = onTheFly;
            this.myLanguageLevel = level;
            this.myGenerifyFixes = onTheFly ? UncheckedWarningLocalInspectionBase.this.createFixes() : LocalQuickFix.EMPTY_ARRAY;
        }

        protected abstract void registerProblem(@NotNull String var1, PsiElement var2, @NotNull PsiElement var3, @NotNull LocalQuickFix[] var4);

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
                return;
            }
            JavaResolveResult result = expression2.advancedResolve(false);
            if (JavaGenericsUtil.isUncheckedWarning((PsiJavaCodeReferenceElement)expression2, (JavaResolveResult)result, (LanguageLevel)this.myLanguageLevel)) {
                this.registerProblem("Unchecked generics array creation for varargs parameter", null, (PsiElement)expression2, LocalQuickFix.EMPTY_ARRAY);
            }
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_GENERICS_ARRAY_CREATION) {
                return;
            }
            PsiJavaCodeReferenceElement classReference2 = expression2.getClassOrAnonymousClassReference();
            if (classReference2 != null && JavaGenericsUtil.isUncheckedWarning((PsiJavaCodeReferenceElement)classReference2, (JavaResolveResult)expression2.resolveMethodGenerics(), (LanguageLevel)this.myLanguageLevel)) {
                this.registerProblem("Unchecked generics array creation for varargs parameter", (PsiElement)expression2, (PsiElement)classReference2, LocalQuickFix.EMPTY_ARRAY);
            }
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
            super.visitTypeCastExpression(expression2);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_CAST) {
                return;
            }
            PsiTypeElement typeElement = expression2.getCastType();
            if (typeElement == null) {
                return;
            }
            PsiType castType = typeElement.getType();
            PsiExpression operand2 = expression2.getOperand();
            if (operand2 == null) {
                return;
            }
            PsiType exprType = operand2.getType();
            if (exprType == null) {
                return;
            }
            if (!TypeConversionUtil.areTypesConvertible((PsiType)exprType, (PsiType)castType)) {
                return;
            }
            if (JavaGenericsUtil.isUncheckedCast((PsiType)castType, (PsiType)exprType)) {
                String description = JavaErrorMessages.message("generics.unchecked.cast", JavaHighlightUtil.formatType(exprType), JavaHighlightUtil.formatType(castType));
                this.registerProblem(description, (PsiElement)operand2, (PsiElement)expression2, this.myGenerifyFixes);
            }
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            super.visitMethodReferenceExpression(expression2);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_CALL) {
                return;
            }
            JavaResolveResult result = expression2.advancedResolve(false);
            String description = this.getUncheckedCallDescription((PsiElement)expression2, result);
            if (description != null) {
                PsiElement referenceNameElement = expression2.getReferenceNameElement();
                this.registerProblem(description, (PsiElement)expression2, (PsiElement)(referenceNameElement != null ? referenceNameElement : expression2), this.myGenerifyFixes);
            }
        }

        public void visitCallExpression(PsiCallExpression callExpression) {
            super.visitCallExpression(callExpression);
            JavaResolveResult result = callExpression.resolveMethodGenerics();
            String description = this.getUncheckedCallDescription((PsiElement)callExpression, result);
            if (description != null) {
                if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_CALL) {
                    return;
                }
                PsiCallExpression element = callExpression instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)callExpression).getMethodExpression() : callExpression;
                this.registerProblem(description, null, (PsiElement)element, this.myGenerifyFixes);
            } else {
                PsiMethod method;
                if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                    return;
                }
                PsiSubstitutor substitutor = result.getSubstitutor();
                PsiExpressionList argumentList = callExpression.getArgumentList();
                if (argumentList != null && (method = (PsiMethod)result.getElement()) != null) {
                    PsiExpression[] expressions2 = argumentList.getExpressions();
                    PsiParameter[] parameters2 = method.getParameterList().getParameters();
                    if (parameters2.length != 0) {
                        for (int i = 0; i < expressions2.length; ++i) {
                            PsiParameter parameter2 = parameters2[Math.min(i, parameters2.length - 1)];
                            PsiExpression expression2 = expressions2[i];
                            PsiType parameterType = substitutor.substitute(parameter2.getType());
                            PsiType expressionType = expression2.getType();
                            if (expressionType == null) continue;
                            this.checkRawToGenericsAssignment((PsiElement)expression2, expression2, parameterType, expressionType, () -> this.myGenerifyFixes);
                        }
                    }
                }
            }
        }

        public void visitVariable(PsiVariable variable) {
            super.visitVariable(variable);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null || initializer instanceof PsiArrayInitializerExpression) {
                return;
            }
            PsiType initializerType = initializer.getType();
            this.checkRawToGenericsAssignment((PsiElement)initializer, initializer, variable.getType(), initializerType, () -> this.myOnTheFly ? UncheckedWarningLocalInspectionBase.getChangeVariableTypeFixes(variable, initializerType, this.myGenerifyFixes) : LocalQuickFix.EMPTY_ARRAY);
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
            super.visitForeachStatement(statement);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiParameter parameter2 = statement.getIterationParameter();
            PsiType parameterType = parameter2.getType();
            PsiExpression iteratedValue2 = statement.getIteratedValue();
            if (iteratedValue2 == null) {
                return;
            }
            PsiType itemType = JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue2);
            this.checkRawToGenericsAssignment((PsiElement)parameter2, iteratedValue2, parameterType, itemType, () -> this.myOnTheFly ? UncheckedWarningLocalInspectionBase.getChangeVariableTypeFixes((PsiVariable)parameter2, itemType, this.myGenerifyFixes) : LocalQuickFix.EMPTY_ARRAY);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            if (!"=".equals(expression2.getOperationSign().getText())) {
                return;
            }
            PsiExpression lExpr = expression2.getLExpression();
            PsiExpression rExpr = expression2.getRExpression();
            if (rExpr == null) {
                return;
            }
            PsiType lType = lExpr.getType();
            PsiType rType = rExpr.getType();
            if (rType == null) {
                return;
            }
            this.checkRawToGenericsAssignment((PsiElement)rExpr, rExpr, lType, rType, () -> {
                PsiElement element;
                if (this.myOnTheFly && lExpr instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)lExpr).resolve()) instanceof PsiVariable) {
                    return UncheckedWarningLocalInspectionBase.getChangeVariableTypeFixes((PsiVariable)element, rType, this.myGenerifyFixes);
                }
                return LocalQuickFix.EMPTY_ARRAY;
            });
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression arrayInitializer) {
            PsiExpression[] initializers;
            super.visitArrayInitializerExpression(arrayInitializer);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiType type2 = arrayInitializer.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return;
            }
            PsiType componentType = ((PsiArrayType)type2).getComponentType();
            boolean arrayTypeFixChecked = false;
            VariableArrayTypeFix fix = null;
            for (PsiExpression expression2 : initializers = arrayInitializer.getInitializers()) {
                PsiType itemType = expression2.getType();
                if (itemType == null || !TypeConversionUtil.isAssignable((PsiType)componentType, (PsiType)itemType) || !JavaGenericsUtil.isRawToGeneric((PsiType)componentType, (PsiType)itemType)) continue;
                String description = JavaErrorMessages.message("generics.unchecked.assignment", JavaHighlightUtil.formatType(itemType), JavaHighlightUtil.formatType(componentType));
                if (!arrayTypeFixChecked) {
                    PsiType checkResult = JavaHighlightUtil.sameType(initializers);
                    fix = checkResult != null ? VariableArrayTypeFix.createFix(arrayInitializer, checkResult) : null;
                    arrayTypeFixChecked = true;
                }
                if (fix == null) continue;
                this.registerProblem(description, null, (PsiElement)expression2, new LocalQuickFix[]{fix});
            }
        }

        private void checkRawToGenericsAssignment(@NotNull PsiElement parameter2, PsiExpression expression2, PsiType parameterType, PsiType itemType, Supplier<LocalQuickFix[]> fixesSupplier) {
            if (parameter2 == null) {
                UncheckedWarningsVisitor.$$$reportNull$$$0(1);
            }
            if (parameterType == null || itemType == null) {
                return;
            }
            if (!TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)itemType)) {
                return;
            }
            if (JavaGenericsUtil.isRawToGeneric((PsiType)parameterType, (PsiType)itemType)) {
                String description = JavaErrorMessages.message("generics.unchecked.assignment", JavaHighlightUtil.formatType(itemType), JavaHighlightUtil.formatType(parameterType));
                this.registerProblem(description, (PsiElement)expression2, parameter2, fixesSupplier.get());
            }
        }

        public void visitMethod(PsiMethod method) {
            List superMethodSignatures;
            super.visitMethod(method);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_OVERRIDING) {
                return;
            }
            if (!(method.isConstructor() || (superMethodSignatures = method.getHierarchicalMethodSignature().getSuperSignatures()).isEmpty() || method.hasModifierProperty("static"))) {
                MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
                for (MethodSignatureBackedByPsiMethod superSignature : superMethodSignatures) {
                    PsiMethod baseMethod = superSignature.getMethod();
                    PsiSubstitutor substitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)signature, (MethodSignature)superSignature);
                    if (substitutor == null) {
                        substitutor = superSignature.getSubstitutor();
                    }
                    if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)baseMethod, (PsiSubstitutor)superSignature.getSubstitutor())) continue;
                    PsiType baseReturnType = substitutor.substitute(baseMethod.getReturnType());
                    PsiType overriderReturnType = method.getReturnType();
                    if (baseReturnType == null || overriderReturnType == null) {
                        return;
                    }
                    if (!JavaGenericsUtil.isRawToGeneric((PsiType)baseReturnType, (PsiType)overriderReturnType)) continue;
                    String message2 = JavaErrorMessages.message("unchecked.overriding.incompatible.return.type", JavaHighlightUtil.formatType(overriderReturnType), JavaHighlightUtil.formatType(baseReturnType));
                    PsiTypeElement returnTypeElement = method.getReturnTypeElement();
                    LOG.assertTrue(returnTypeElement != null);
                    this.registerProblem(message2, null, (PsiElement)returnTypeElement, LocalQuickFix.EMPTY_ARRAY);
                }
            }
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiType valueType;
            PsiExpression returnValue;
            super.visitReturnStatement(statement);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiType returnType = PsiTypesUtil.getMethodReturnType((PsiElement)statement);
            if (returnType != null && !PsiType.VOID.equals((Object)returnType) && (returnValue = statement.getReturnValue()) != null && (valueType = returnValue.getType()) != null) {
                this.checkRawToGenericsAssignment((PsiElement)returnValue, returnValue, returnType, valueType, () -> {
                    LocalQuickFix[] localQuickFixArray;
                    PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
                    if (psiElement instanceof PsiMethod) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = QuickFixFactory.getInstance().createMethodReturnFix((PsiMethod)psiElement, valueType, true);
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    return localQuickFixArray;
                });
            }
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
            PsiType type2;
            PsiType interfaceReturnType;
            super.visitLambdaExpression(expression2);
            if (UncheckedWarningLocalInspectionBase.this.IGNORE_UNCHECKED_ASSIGNMENT) {
                return;
            }
            PsiElement body2 = expression2.getBody();
            if (body2 instanceof PsiExpression && (interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression2)) != null && !PsiType.VOID.equals((Object)interfaceReturnType) && (type2 = ((PsiExpression)body2).getType()) != null) {
                this.checkRawToGenericsAssignment(body2, (PsiExpression)body2, interfaceReturnType, type2, () -> LocalQuickFix.EMPTY_ARRAY);
            }
        }

        @Nullable
        private String getUncheckedCallDescription(PsiElement place, JavaResolveResult resolveResult) {
            PsiParameter[] parameters2;
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiMethod)) {
                return null;
            }
            final PsiMethod method = (PsiMethod)element;
            final PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            if (!PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)method, (PsiSubstitutor)substitutor)) {
                if (JavaVersionService.getInstance().isAtLeast(place, JavaSdkVersion.JDK_1_8)) {
                    for (PsiTypeParameter parameter2 : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)method)) {
                        PsiClassType[] extendsListTypes = parameter2.getExtendsListTypes();
                        if (extendsListTypes.length <= 0) continue;
                        PsiType subst = substitutor.substitute(parameter2);
                        for (PsiClassType classType : extendsListTypes) {
                            if (!JavaGenericsUtil.isRawToGeneric((PsiType)substitutor.substitute((PsiType)classType), (PsiType)subst)) continue;
                            return JavaErrorMessages.message("generics.unchecked.call", JavaHighlightUtil.formatMethod(method));
                        }
                    }
                }
                return null;
            }
            for (PsiParameter parameter3 : parameters2 = method.getParameterList().getParameters()) {
                PsiType parameterType = parameter3.getType();
                if (!((Boolean)parameterType.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

                    public Boolean visitPrimitiveType(PsiPrimitiveType primitiveType) {
                        return Boolean.FALSE;
                    }

                    public Boolean visitArrayType(PsiArrayType arrayType) {
                        return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
                    }

                    public Boolean visitClassType(PsiClassType classType) {
                        PsiClassType.ClassResolveResult result = classType.resolveGenerics();
                        PsiClass psiClass = result.getElement();
                        if (psiClass instanceof PsiTypeParameter) {
                            if (((PsiTypeParameter)psiClass).getOwner() == method) {
                                return Boolean.FALSE;
                            }
                            return substitutor.substitute((PsiTypeParameter)psiClass) == null ? Boolean.TRUE : Boolean.FALSE;
                        }
                        if (psiClass != null) {
                            PsiSubstitutor typeSubstitutor = result.getSubstitutor();
                            for (PsiTypeParameter parameter2 : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)psiClass)) {
                                PsiType psiType = typeSubstitutor.substitute(parameter2);
                                if (psiType == null || !((Boolean)psiType.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                                return Boolean.TRUE;
                            }
                        }
                        return Boolean.FALSE;
                    }

                    public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                        PsiType bound = wildcardType.getBound();
                        if (bound != null) {
                            return (Boolean)bound.accept((PsiTypeVisitor)this);
                        }
                        return Boolean.TRUE;
                    }

                    public Boolean visitEllipsisType(PsiEllipsisType ellipsisType) {
                        return (Boolean)ellipsisType.getComponentType().accept((PsiTypeVisitor)this);
                    }
                })).booleanValue()) continue;
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
                PsiClassType type2 = elementFactory.createType(method.getContainingClass(), substitutor);
                return JavaErrorMessages.message("generics.unchecked.call.to.member.of.raw.type", JavaHighlightUtil.formatMethod(method), JavaHighlightUtil.formatType((PsiType)type2));
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/uncheckedWarnings/UncheckedWarningLocalInspectionBase$UncheckedWarningsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkRawToGenericsAssignment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

