/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.intention.impl.StreamRefactoringUtil;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalUtil {
    private static final String OPTIONAL_INT = "java.util.OptionalInt";
    private static final String OPTIONAL_LONG = "java.util.OptionalLong";
    private static final String OPTIONAL_DOUBLE = "java.util.OptionalDouble";
    private static final CallMatcher OPTIONAL_OF = CallMatcher.staticCall("java.util.Optional", "of", "ofNullable").parameterCount(1);

    @NotNull
    @Contract(pure=true)
    public static String getOptionalClass(String type2) {
        switch (type2) {
            case "int": {
                if (OPTIONAL_INT == null) {
                    OptionalUtil.$$$reportNull$$$0(0);
                }
                return OPTIONAL_INT;
            }
            case "long": {
                if (OPTIONAL_LONG == null) {
                    OptionalUtil.$$$reportNull$$$0(1);
                }
                return OPTIONAL_LONG;
            }
            case "double": {
                if (OPTIONAL_DOUBLE == null) {
                    OptionalUtil.$$$reportNull$$$0(2);
                }
                return OPTIONAL_DOUBLE;
            }
        }
        if ("java.util.Optional" == null) {
            OptionalUtil.$$$reportNull$$$0(3);
        }
        return "java.util.Optional";
    }

    public static boolean isOptionalClassName(String className) {
        return "java.util.Optional".equals(className) || OPTIONAL_INT.equals(className) || OPTIONAL_LONG.equals(className) || OPTIONAL_DOUBLE.equals(className);
    }

    @Contract(value="null -> null")
    public static PsiType getOptionalElementType(PsiType type2) {
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        if (aClass == null) {
            return null;
        }
        String className = aClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        switch (className) {
            case "java.util.OptionalInt": {
                return PsiType.INT;
            }
            case "java.util.OptionalLong": {
                return PsiType.LONG;
            }
            case "java.util.OptionalDouble": {
                return PsiType.DOUBLE;
            }
            case "java.util.Optional": {
                PsiType[] parameters2 = ((PsiClassType)type2).getParameters();
                if (parameters2.length != 1) {
                    return null;
                }
                PsiType streamType = parameters2[0];
                if (streamType instanceof PsiCapturedWildcardType) {
                    streamType = ((PsiCapturedWildcardType)streamType).getUpperBound();
                }
                return streamType;
            }
        }
        return null;
    }

    public static String generateOptionalUnwrap(String qualifier, PsiVariable var, PsiExpression trueExpression, PsiExpression falseExpression, @Nullable PsiType targetType, boolean useOrElseGet) {
        boolean trivialMap;
        PsiExpression stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)trueExpression);
        PsiType trueType = trueExpression.getType();
        boolean bl = trivialMap = ExpressionUtils.isReferenceTo(trueExpression, var) && targetType != null && (trueType instanceof PsiLambdaParameterType || Objects.requireNonNull(trueType).isAssignableFrom(targetType));
        if (!trivialMap) {
            PsiType elementType;
            PsiTypeCastExpression castExpression;
            PsiTypeElement castType;
            if (stripped instanceof PsiTypeCastExpression && ExpressionUtils.isNullLiteral(falseExpression) && (castType = (castExpression = (PsiTypeCastExpression)stripped).getCastType()) != null && ExpressionUtils.isReferenceTo(castExpression.getOperand(), var)) {
                return "(" + castType.getText() + ")" + qualifier + ".orElse(null)";
            }
            if (ExpressionUtils.isLiteral((PsiElement)falseExpression, Boolean.FALSE) && PsiType.BOOLEAN.equals((Object)trueType)) {
                if (ExpressionUtils.isLiteral((PsiElement)trueExpression, Boolean.TRUE)) {
                    return qualifier + ".isPresent()";
                }
                return qualifier + ".filter(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)trueExpression) + ").isPresent()";
            }
            if (ExpressionUtils.isLiteral((PsiElement)falseExpression, Boolean.TRUE) && ExpressionUtils.isLiteral((PsiElement)trueExpression, Boolean.FALSE)) {
                return "!" + qualifier + ".isPresent()";
            }
            if (stripped instanceof PsiConditionalExpression) {
                PsiConditionalExpression condition2 = (PsiConditionalExpression)stripped;
                PsiExpression thenExpression2 = condition2.getThenExpression();
                PsiExpression elseExpression2 = condition2.getElseExpression();
                if (elseExpression2 != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)falseExpression, (PsiElement)elseExpression2)) {
                    return OptionalUtil.generateOptionalUnwrap(qualifier + ".filter(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)condition2.getCondition()) + ")", var, condition2.getThenExpression(), falseExpression, targetType, useOrElseGet);
                }
                if (thenExpression2 != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)falseExpression, (PsiElement)thenExpression2)) {
                    return OptionalUtil.generateOptionalUnwrap(qualifier + ".filter(" + var.getName() + " -> " + BoolUtils.getNegatedExpressionText(condition2.getCondition()) + ")", var, condition2.getElseExpression(), falseExpression, targetType, useOrElseGet);
                }
            }
            String suffix = null;
            boolean java9 = PsiUtil.isLanguageLevel9OrHigher((PsiElement)trueExpression);
            if (OptionalUtil.isOptionalEmptyCall(falseExpression)) {
                suffix = "";
            } else if (java9 && InheritanceUtil.isInheritor((PsiType)falseExpression.getType(), (String)"java.util.Optional") && LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)falseExpression)) {
                suffix = ".or(() -> " + falseExpression.getText() + ")";
            }
            if (suffix != null) {
                PsiMethodCallExpression mappedOptional = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)stripped, PsiMethodCallExpression.class);
                if (OPTIONAL_OF.test(mappedOptional)) {
                    PsiExpression arg = mappedOptional.getArgumentList().getExpressions()[0];
                    if (ExpressionUtils.isReferenceTo(arg, var)) {
                        return qualifier + suffix;
                    }
                    return qualifier + ".map(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)arg) + ")" + suffix;
                }
                if (suffix.isEmpty()) {
                    return qualifier + ".flatMap(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)trueExpression) + ")";
                }
            }
            if (java9 && StreamApiUtil.isNullOrEmptyStream(falseExpression) && !ExpressionUtils.isNullLiteral(falseExpression) && (elementType = StreamApiUtil.getStreamElementType(targetType)) != null) {
                String flatMapOperationName;
                String className;
                PsiMethod method;
                PsiExpression[] args;
                PsiMethodCallExpression mappedStream = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)stripped, PsiMethodCallExpression.class);
                if (mappedStream != null && "of".equals(mappedStream.getMethodExpression().getReferenceName()) && (args = mappedStream.getArgumentList().getExpressions()).length == 1 && (method = mappedStream.resolveMethod()) != null && method.getContainingClass() != null && (className = method.getContainingClass().getQualifiedName()) != null && className.startsWith("java.util.stream.")) {
                    PsiExpression arg = args[0];
                    if (ExpressionUtils.isReferenceTo(arg, var)) {
                        return qualifier + ".stream()";
                    }
                    if (arg.getType() != null && elementType.isAssignableFrom(arg.getType())) {
                        return qualifier + ".stream()" + StreamRefactoringUtil.generateMapOperation(var, elementType, (PsiElement)arg);
                    }
                }
                if ((flatMapOperationName = StreamRefactoringUtil.getFlatMapOperationName(var.getType(), elementType)) != null) {
                    return qualifier + ".stream()." + flatMapOperationName + "(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)trueExpression) + ")";
                }
            }
            trueExpression = targetType == null ? trueExpression : RefactoringUtil.convertInitializerToNormalExpression(trueExpression, targetType);
            String typeArg = OptionalUtil.getMapTypeArgument(trueExpression, targetType, falseExpression);
            qualifier = qualifier + "." + typeArg + "map(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)trueExpression) + ")";
        }
        if (useOrElseGet && !ExpressionUtils.isSafelyRecomputableExpression(falseExpression)) {
            return qualifier + ".orElseGet(() -> " + falseExpression.getText() + ")";
        }
        return qualifier + ".orElse(" + falseExpression.getText() + ")";
    }

    @Contract(value="null -> false")
    public static boolean isOptionalEmptyCall(PsiExpression expression2) {
        return expression2 instanceof PsiMethodCallExpression && MethodCallUtils.isCallToStaticMethod((PsiMethodCallExpression)expression2, "java.util.Optional", "empty", 0);
    }

    @NotNull
    public static String getMapTypeArgument(PsiExpression expression2, PsiType type2) {
        String string = OptionalUtil.getMapTypeArgument(expression2, type2, null);
        if (string == null) {
            OptionalUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String getMapTypeArgument(PsiExpression expression2, PsiType type2, PsiExpression falseExpression) {
        if (!(type2 instanceof PsiClassType)) {
            if ("" == null) {
                OptionalUtil.$$$reportNull$$$0(5);
            }
            return "";
        }
        PsiExpression copy = JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createExpressionFromText(expression2.getText(), (PsiElement)expression2);
        PsiType exprType = copy.getType();
        if (exprType != null && !exprType.equals(PsiType.NULL) && !LambdaUtil.notInferredType((PsiType)exprType) && TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)exprType)) {
            if (falseExpression == null) {
                if ("" == null) {
                    OptionalUtil.$$$reportNull$$$0(6);
                }
                return "";
            }
            PsiType falseType = falseExpression.getType();
            if (falseType != null && (falseType.isAssignableFrom(exprType) || falseType.equals(PsiType.NULL))) {
                if ("" == null) {
                    OptionalUtil.$$$reportNull$$$0(7);
                }
                return "";
            }
        }
        String string = "<" + type2.getCanonicalText() + ">";
        if (string == null) {
            OptionalUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/util/OptionalUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionalClass";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapTypeArgument";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

