/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.projectView.CompositePsiClassChildrenSource;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

public interface PsiClassChildrenSource {
    public static final PsiClassChildrenSource NONE = new PsiClassChildrenSource(){

        @Override
        public void addChildren(PsiClass psiClass, List<PsiElement> children) {
        }
    };
    public static final PsiClassChildrenSource METHODS = new PsiClassChildrenSource(){

        @Override
        public void addChildren(PsiClass psiClass, List<PsiElement> children) {
            ContainerUtil.addAll(children, (Object[])psiClass.getMethods());
        }
    };
    public static final PsiClassChildrenSource FIELDS = new PsiClassChildrenSource(){

        @Override
        public void addChildren(PsiClass psiClass, List<PsiElement> children) {
            ContainerUtil.addAll(children, (Object[])psiClass.getFields());
        }
    };
    public static final PsiClassChildrenSource CLASSES = new PsiClassChildrenSource(){

        @Override
        public void addChildren(PsiClass psiClass, List<PsiElement> children) {
            ContainerUtil.addAll(children, (Object[])psiClass.getInnerClasses());
        }
    };
    public static final PsiClassChildrenSource DEFAULT_CHILDREN = new CompositePsiClassChildrenSource(new PsiClassChildrenSource[]{CLASSES, METHODS, FIELDS});

    public void addChildren(PsiClass var1, List<PsiElement> var2);
}

