/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageElementNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.TreeViewUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageUtil {
    @NotNull
    public static PsiPackage[] getSubpackages(@NotNull PsiPackage aPackage, @Nullable Module module, boolean searchInLibraries) {
        if (aPackage == null) {
            PackageUtil.$$$reportNull$$$0(0);
        }
        GlobalSearchScope scopeToShow = PackageUtil.getScopeToShow(aPackage.getProject(), module, searchInLibraries);
        ArrayList<PsiPackage> result = new ArrayList<PsiPackage>();
        for (PsiPackage psiPackage : aPackage.getSubPackages(scopeToShow)) {
            String name = psiPackage.getName();
            if (name == null || name.isEmpty()) continue;
            result.add(psiPackage);
        }
        PsiPackage[] psiPackageArray = result.toArray(PsiPackage.EMPTY_ARRAY);
        if (psiPackageArray == null) {
            PackageUtil.$$$reportNull$$$0(1);
        }
        return psiPackageArray;
    }

    public static void addPackageAsChild(@NotNull Collection<AbstractTreeNode> children, @NotNull PsiPackage aPackage, @Nullable Module module, @NotNull ViewSettings settings, boolean inLibrary) {
        if (children == null) {
            PackageUtil.$$$reportNull$$$0(2);
        }
        if (aPackage == null) {
            PackageUtil.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            PackageUtil.$$$reportNull$$$0(4);
        }
        boolean shouldSkipPackage = settings.isHideEmptyMiddlePackages() && PackageUtil.isPackageEmpty(aPackage, module, !settings.isFlattenPackages(), inLibrary);
        Project project = aPackage.getProject();
        if (!shouldSkipPackage) {
            children.add((AbstractTreeNode)new PackageElementNode(project, new PackageElement(module, aPackage, inLibrary), settings));
        }
        if (settings.isFlattenPackages() || shouldSkipPackage) {
            PsiPackage[] subpackages;
            for (PsiPackage subpackage : subpackages = PackageUtil.getSubpackages(aPackage, module, inLibrary)) {
                PackageUtil.addPackageAsChild(children, subpackage, module, settings, inLibrary);
            }
        }
    }

    public static boolean isPackageEmpty(@NotNull PsiPackage aPackage, @Nullable Module module, boolean strictlyEmpty, boolean inLibrary) {
        Project project;
        GlobalSearchScope scopeToShow;
        PsiFile[] children;
        if (aPackage == null) {
            PackageUtil.$$$reportNull$$$0(5);
        }
        if ((children = aPackage.getFiles(scopeToShow = PackageUtil.getScopeToShow(project = aPackage.getProject(), module, inLibrary))).length > 0) {
            return false;
        }
        PsiPackage[] subPackages = aPackage.getSubPackages(scopeToShow);
        if (strictlyEmpty) {
            return subPackages.length == 1;
        }
        return subPackages.length > 0;
    }

    @NotNull
    public static PsiDirectory[] getDirectories(@NotNull PsiPackage aPackage, @Nullable Module module, boolean inLibrary) {
        if (aPackage == null) {
            PackageUtil.$$$reportNull$$$0(6);
        }
        GlobalSearchScope scopeToShow = PackageUtil.getScopeToShow(aPackage.getProject(), module, inLibrary);
        PsiDirectory[] psiDirectoryArray = aPackage.getDirectories(scopeToShow);
        if (psiDirectoryArray == null) {
            PackageUtil.$$$reportNull$$$0(7);
        }
        return psiDirectoryArray;
    }

    @NotNull
    public static GlobalSearchScope getScopeToShow(@NotNull Project project, @Nullable Module module, boolean forLibraries) {
        if (project == null) {
            PackageUtil.$$$reportNull$$$0(8);
        }
        if (module == null) {
            if (forLibraries) {
                ProjectLibrariesSearchScope projectLibrariesSearchScope = new ProjectLibrariesSearchScope(project);
                if (projectLibrariesSearchScope == null) {
                    PackageUtil.$$$reportNull$$$0(9);
                }
                return projectLibrariesSearchScope;
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
            if (globalSearchScope == null) {
                PackageUtil.$$$reportNull$$$0(10);
            }
            return globalSearchScope;
        }
        if (forLibraries) {
            ModuleLibrariesSearchScope moduleLibrariesSearchScope = new ModuleLibrariesSearchScope(module);
            if (moduleLibrariesSearchScope == null) {
                PackageUtil.$$$reportNull$$$0(11);
            }
            return moduleLibrariesSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleScope((Module)module);
        if (globalSearchScope == null) {
            PackageUtil.$$$reportNull$$$0(12);
        }
        return globalSearchScope;
    }

    public static boolean isPackageDefault(@NotNull PsiPackage directoryPackage) {
        if (directoryPackage == null) {
            PackageUtil.$$$reportNull$$$0(13);
        }
        String qName = directoryPackage.getQualifiedName();
        return qName.isEmpty();
    }

    @NotNull
    public static Collection<AbstractTreeNode> createPackageViewChildrenOnFiles(@NotNull List<VirtualFile> sourceRoots, @NotNull Project project, @NotNull ViewSettings settings, @Nullable Module module, boolean inLibrary) {
        if (sourceRoots == null) {
            PackageUtil.$$$reportNull$$$0(14);
        }
        if (project == null) {
            PackageUtil.$$$reportNull$$$0(15);
        }
        if (settings == null) {
            PackageUtil.$$$reportNull$$$0(16);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        HashSet<PsiPackage> topLevelPackages = new HashSet<PsiPackage>();
        for (VirtualFile root : sourceRoots) {
            ProgressManager.checkCanceled();
            PsiDirectory directory = psiManager.findDirectory(root);
            if (directory == null) continue;
            PsiPackage directoryPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (directoryPackage == null || PackageUtil.isPackageDefault(directoryPackage)) {
                PsiDirectory[] subdirectories;
                for (PsiDirectory subdirectory : subdirectories = directory.getSubdirectories()) {
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subdirectory);
                    if (aPackage == null || PackageUtil.isPackageDefault(aPackage)) continue;
                    topLevelPackages.add(aPackage);
                }
                children.addAll(ProjectViewDirectoryHelper.getInstance((Project)project).getDirectoryChildren(directory, settings, false));
                continue;
            }
            topLevelPackages.add(directoryPackage);
        }
        for (PsiPackage topLevelPackage : topLevelPackages) {
            PackageUtil.addPackageAsChild(children, topLevelPackage, module, settings, inLibrary);
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            PackageUtil.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    public static String getNodeName(@NotNull ViewSettings settings, PsiPackage aPackage, PsiPackage parentPackageInTree, @NotNull String defaultShortName, boolean isFQNameShown) {
        String name;
        if (settings == null) {
            PackageUtil.$$$reportNull$$$0(18);
        }
        if (defaultShortName == null) {
            PackageUtil.$$$reportNull$$$0(19);
        }
        if (isFQNameShown) {
            name = settings.isAbbreviatePackageNames() ? (aPackage == null ? defaultShortName : TreeViewUtil.calcAbbreviatedPackageFQName(aPackage)) : (aPackage == null ? defaultShortName : aPackage.getQualifiedName());
        } else if (parentPackageInTree != null || aPackage != null && aPackage.getParentPackage() != null) {
            String parentPackageName;
            StringBuilder buf = new StringBuilder();
            buf.append(aPackage.getName());
            for (PsiPackage parentPackage = aPackage.getParentPackage(); !(parentPackage == null || parentPackageInTree != null && parentPackage.equals(parentPackageInTree) || (parentPackageName = parentPackage.getName()) == null || parentPackageName.isEmpty()); parentPackage = parentPackage.getParentPackage()) {
                buf.insert(0, ".");
                buf.insert(0, parentPackageName);
            }
            name = buf.toString();
        } else {
            name = defaultShortName;
        }
        String string = name;
        if (string == null) {
            PackageUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/PackageUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 4: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryPackage";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/PackageUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubpackages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeToShow";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackageViewChildrenOnFiles";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSubpackages";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 20: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPackageAsChild";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPackageEmpty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDirectories";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getScopeToShow";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isPackageDefault";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createPackageViewChildrenOnFiles";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProjectLibrariesSearchScope
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;

        public ProjectLibrariesSearchScope(@NotNull Project project) {
            if (project == null) {
                ProjectLibrariesSearchScope.$$$reportNull$$$0(0);
            }
            super(project);
            this.myFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                ProjectLibrariesSearchScope.$$$reportNull$$$0(1);
            }
            return this.myFileIndex.isInLibraryClasses(file);
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                ProjectLibrariesSearchScope.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                ProjectLibrariesSearchScope.$$$reportNull$$$0(3);
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                ProjectLibrariesSearchScope.$$$reportNull$$$0(4);
            }
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/PackageUtil$ProjectLibrariesSearchScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compare";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ModuleLibrariesSearchScope
    extends GlobalSearchScope {
        private final Module myModule;

        public ModuleLibrariesSearchScope(@NotNull Module module) {
            if (module == null) {
                ModuleLibrariesSearchScope.$$$reportNull$$$0(0);
            }
            super(module.getProject());
            this.myModule = module;
        }

        public boolean contains(@NotNull VirtualFile file) {
            OrderEntry orderEntry;
            if (file == null) {
                ModuleLibrariesSearchScope.$$$reportNull$$$0(1);
            }
            return (orderEntry = ModuleRootManager.getInstance((Module)this.myModule).getFileIndex().getOrderEntryForFile(file)) instanceof JdkOrderEntry || orderEntry instanceof LibraryOrderEntry;
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                ModuleLibrariesSearchScope.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                ModuleLibrariesSearchScope.$$$reportNull$$$0(3);
            }
            ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)this.myModule).getFileIndex();
            return Comparing.compare((Comparable)fileIndex.getOrderEntryForFile(file2), (Comparable)fileIndex.getOrderEntryForFile(file1));
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                ModuleLibrariesSearchScope.$$$reportNull$$$0(4);
            }
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/PackageUtil$ModuleLibrariesSearchScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compare";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

