/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaFormatterUtil {
    private static final Set<IElementType> ASSIGNMENT_ELEMENT_TYPES = new HashSet<IElementType>(Arrays.asList(JavaElementType.ASSIGNMENT_EXPRESSION, JavaElementType.LOCAL_VARIABLE, JavaElementType.FIELD));

    private JavaFormatterUtil() {
    }

    public static boolean isAssignment(ASTNode node) {
        return ASSIGNMENT_ELEMENT_TYPES.contains(node.getElementType());
    }

    public static boolean areSamePriorityBinaryExpressions(ASTNode node1, ASTNode node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        if (!(node1 instanceof PsiPolyadicExpression) || !(node2 instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression expression1 = (PsiPolyadicExpression)node1;
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)node2;
        return expression1.getOperationTokenType() == expression2.getOperationTokenType();
    }

    public static boolean hasMultilineArguments(@NotNull PsiExpression[] arguments) {
        if (arguments == null) {
            JavaFormatterUtil.$$$reportNull$$$0(0);
        }
        for (PsiExpression argument : arguments) {
            ASTNode node = argument.getNode();
            if (!node.textContains('\n')) continue;
            return true;
        }
        return false;
    }

    public static boolean isMultilineExceptArguments(@NotNull PsiExpression[] arguments) {
        if (arguments == null) {
            JavaFormatterUtil.$$$reportNull$$$0(1);
        }
        for (PsiExpression argument : arguments) {
            ASTNode beforeArgument = argument.getNode().getTreePrev();
            if (!JavaFormatterUtil.isWhiteSpaceWithLineFeed(beforeArgument)) continue;
            return true;
        }
        PsiExpression lastArgument = arguments[arguments.length - 1];
        ASTNode afterLastArgument = lastArgument.getNode().getTreeNext();
        return JavaFormatterUtil.isWhiteSpaceWithLineFeed(afterLastArgument);
    }

    private static boolean isWhiteSpaceWithLineFeed(@NotNull ASTNode node) {
        if (node == null) {
            JavaFormatterUtil.$$$reportNull$$$0(2);
        }
        return node instanceof PsiWhiteSpace && node.textContains('\n');
    }

    @NotNull
    public static WrapType getWrapType(int wrap) {
        switch (wrap) {
            case 2: {
                WrapType wrapType = WrapType.ALWAYS;
                if (wrapType == null) {
                    JavaFormatterUtil.$$$reportNull$$$0(3);
                }
                return wrapType;
            }
            case 1: {
                WrapType wrapType = WrapType.NORMAL;
                if (wrapType == null) {
                    JavaFormatterUtil.$$$reportNull$$$0(4);
                }
                return wrapType;
            }
            case 0: {
                WrapType wrapType = WrapType.NONE;
                if (wrapType == null) {
                    JavaFormatterUtil.$$$reportNull$$$0(5);
                }
                return wrapType;
            }
        }
        WrapType wrapType = WrapType.CHOP_DOWN_IF_LONG;
        if (wrapType == null) {
            JavaFormatterUtil.$$$reportNull$$$0(6);
        }
        return wrapType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/java/JavaFormatterUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/java/JavaFormatterUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasMultilineArguments";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMultilineExceptArguments";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isWhiteSpaceWithLineFeed";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

