/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.migration;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.migration.PsiMigrationImpl;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MigrationElementFinder
extends PsiElementFinder
implements DumbAware {
    private final Project myProject;

    public MigrationElementFinder(Project project) {
        this.myProject = project;
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiMigrationImpl migration;
        if (qualifiedName == null) {
            MigrationElementFinder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            MigrationElementFinder.$$$reportNull$$$0(1);
        }
        if ((migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration()) != null) {
            return migration.getMigrationClass(qualifiedName);
        }
        return null;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass migrationClass;
        PsiMigrationImpl migration;
        if (qualifiedName == null) {
            MigrationElementFinder.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            MigrationElementFinder.$$$reportNull$$$0(3);
        }
        if ((migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration()) != null && (migrationClass = migration.getMigrationClass(qualifiedName)) != null) {
            PsiClass[] psiClassArray = new PsiClass[]{migrationClass};
            if (psiClassArray == null) {
                MigrationElementFinder.$$$reportNull$$$0(4);
            }
            return psiClassArray;
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            MigrationElementFinder.$$$reportNull$$$0(5);
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        PsiMigrationImpl migration;
        if (psiPackage == null) {
            MigrationElementFinder.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            MigrationElementFinder.$$$reportNull$$$0(7);
        }
        if ((migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration()) != null) {
            List<PsiClass> classes2 = migration.getMigrationClasses(psiPackage.getQualifiedName());
            PsiClass[] psiClassArray = classes2.toArray(PsiClass.EMPTY_ARRAY);
            if (psiClassArray == null) {
                MigrationElementFinder.$$$reportNull$$$0(8);
            }
            return psiClassArray;
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            MigrationElementFinder.$$$reportNull$$$0(9);
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        PsiMigrationImpl migration;
        if (psiPackage == null) {
            MigrationElementFinder.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            MigrationElementFinder.$$$reportNull$$$0(11);
        }
        if ((migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration()) != null) {
            List<PsiPackage> packages = migration.getMigrationPackages(psiPackage.getQualifiedName());
            PsiPackage[] psiPackageArray = packages.toArray(PsiPackage.EMPTY_ARRAY);
            if (psiPackageArray == null) {
                MigrationElementFinder.$$$reportNull$$$0(12);
            }
            return psiPackageArray;
        }
        if (PsiPackage.EMPTY_ARRAY == null) {
            MigrationElementFinder.$$$reportNull$$$0(13);
        }
        return PsiPackage.EMPTY_ARRAY;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName) {
        PsiMigrationImpl migration;
        if (qualifiedName == null) {
            MigrationElementFinder.$$$reportNull$$$0(14);
        }
        if ((migration = PsiMigrationManager.getInstance(this.myProject).getCurrentMigration()) != null) {
            return migration.getMigrationPackage(qualifiedName);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/migration/MigrationElementFinder";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/migration/MigrationElementFinder";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

