/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import java.util.HashMap;
import org.jetbrains.annotations.Nullable;

public class ModifierListElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.ModifierListElement");
    private static final HashMap<String, Integer> ourModifierToOrderMap = new HashMap();

    public ModifierListElement() {
        super(JavaElementType.MODIFIER_LIST);
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        if (before == null && first == last && ElementType.KEYWORD_BIT_SET.contains(first.getElementType())) {
            anchor = ModifierListElement.getDefaultAnchor((PsiModifierList)SourceTreeToPsiMap.treeElementToPsi((ASTNode)this), (PsiKeyword)SourceTreeToPsiMap.treeElementToPsi((ASTNode)first));
            before = Boolean.TRUE;
        }
        return super.addInternal(first, last, anchor, before);
    }

    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        if (child.getElementType() == JavaElementType.ANNOTATION) {
            return 250;
        }
        return 0;
    }

    @Nullable
    private static ASTNode getDefaultAnchor(PsiModifierList modifierList, PsiKeyword modifier) {
        Integer order = ourModifierToOrderMap.get(modifier.getText());
        if (order == null) {
            return null;
        }
        for (TreeElement child = SourceTreeToPsiMap.psiToTreeNotNull((PsiElement)modifierList).getFirstChildNode(); child != null; child = child.getTreeNext()) {
            Integer order1;
            if (!ElementType.KEYWORD_BIT_SET.contains(child.getElementType()) || (order1 = ourModifierToOrderMap.get(child.getText())) == null || order1 <= order) continue;
            return child;
        }
        return null;
    }

    static {
        ourModifierToOrderMap.put("public", 1);
        ourModifierToOrderMap.put("private", 1);
        ourModifierToOrderMap.put("protected", 1);
        ourModifierToOrderMap.put("static", 2);
        ourModifierToOrderMap.put("abstract", 2);
        ourModifierToOrderMap.put("final", 3);
        ourModifierToOrderMap.put("synchronized", 4);
        ourModifierToOrderMap.put("transient", 4);
        ourModifierToOrderMap.put("volatile", 4);
        ourModifierToOrderMap.put("native", 5);
        ourModifierToOrderMap.put("strictfp", 6);
    }
}

