/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.resolve;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.resolve.JavaMethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodResolveHelper {
    private final Set<MethodSignature> myDuplicates;
    private final MethodCandidatesProcessor myProcessor;
    @Nullable
    private final PsiType[] myArgumentTypes;

    public JavaMethodResolveHelper(final @NotNull PsiElement argumentList, PsiFile containingFile, final @Nullable PsiType[] argumentTypes) {
        if (argumentList == null) {
            JavaMethodResolveHelper.$$$reportNull$$$0(0);
        }
        this.myDuplicates = new THashSet();
        this.myArgumentTypes = argumentTypes;
        final LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)argumentList);
        PsiConflictResolver resolver = argumentTypes == null ? DuplicateConflictResolver.INSTANCE : new JavaMethodsConflictResolver(argumentList, argumentTypes, languageLevel);
        this.myProcessor = new MethodResolverProcessor(argumentList, containingFile, new PsiConflictResolver[]{resolver}){

            @Override
            protected MethodCandidateInfo createCandidateInfo(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean staticProblem, boolean accessible, boolean varargs) {
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (substitutor == null) {
                    1.$$$reportNull$$$0(1);
                }
                return JavaMethodResolveHelper.this.createCandidateInfo(method, substitutor, staticProblem, this.myCurrentFileContext, !accessible, argumentList, argumentTypes, languageLevel, varargs);
            }

            @Override
            protected boolean isAccepted(PsiMethod candidate) {
                return !candidate.isConstructor();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "method";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "substitutor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/resolve/JavaMethodResolveHelper$1";
                objectArray[2] = "createCandidateInfo";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected MethodCandidateInfo createCandidateInfo(@NotNull PsiMethod method, PsiSubstitutor substitutor, boolean staticProblem, PsiElement currentFileContext, boolean accessProblem, PsiElement argumentList, PsiType[] argumentTypes, @NotNull LanguageLevel languageLevel, final boolean vararg) {
        if (method == null) {
            JavaMethodResolveHelper.$$$reportNull$$$0(1);
        }
        if (languageLevel == null) {
            JavaMethodResolveHelper.$$$reportNull$$$0(2);
        }
        return new MethodCandidateInfo((PsiElement)method, substitutor, accessProblem, staticProblem, argumentList, currentFileContext, argumentTypes, PsiType.EMPTY_ARRAY, languageLevel){

            public boolean isVarargs() {
                return vararg;
            }
        };
    }

    public void addMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean staticError) {
        if (method == null) {
            JavaMethodResolveHelper.$$$reportNull$$$0(3);
        }
        if (substitutor == null) {
            JavaMethodResolveHelper.$$$reportNull$$$0(4);
        }
        if (this.myDuplicates.add(method.getSignature(substitutor))) {
            this.myProcessor.addMethod(method, substitutor, staticError);
        }
    }

    @NotNull
    public ErrorType getResolveError() {
        List<CandidateInfo> candidates = this.getCandidates();
        if (candidates.size() != 1) {
            ErrorType errorType = ErrorType.RESOLVE;
            if (errorType == null) {
                JavaMethodResolveHelper.$$$reportNull$$$0(5);
            }
            return errorType;
        }
        if (!candidates.get(0).isStaticsScopeCorrect()) {
            ErrorType errorType = ErrorType.STATIC;
            if (errorType == null) {
                JavaMethodResolveHelper.$$$reportNull$$$0(6);
            }
            return errorType;
        }
        ErrorType errorType = this.getResolveError((MethodCandidateInfo)candidates.get(0));
        if (errorType == null) {
            JavaMethodResolveHelper.$$$reportNull$$$0(7);
        }
        return errorType;
    }

    protected List<CandidateInfo> getCandidates() {
        return Arrays.asList(this.myProcessor.getCandidates());
    }

    protected ErrorType getResolveError(MethodCandidateInfo info) {
        if (this.myArgumentTypes == null) {
            return ErrorType.NONE;
        }
        if (!info.isApplicable()) {
            boolean hasNulls = false;
            PsiParameter[] parameters2 = info.getElement().getParameterList().getParameters();
            if (this.myArgumentTypes.length == parameters2.length) {
                for (int i = 0; i < this.myArgumentTypes.length; ++i) {
                    PsiType type2 = this.myArgumentTypes[i];
                    if (type2 == null) {
                        hasNulls = true;
                        continue;
                    }
                    if (parameters2[i].getType().isAssignableFrom(type2)) continue;
                    return ErrorType.RESOLVE;
                }
            }
            return hasNulls ? ErrorType.NONE : ErrorType.RESOLVE;
        }
        return ErrorType.NONE;
    }

    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        this.myProcessor.handleEvent(event, associated);
    }

    public Collection<JavaMethodCandidateInfo> getMethods() {
        return ContainerUtil.mapNotNull(this.getCandidates(), javaResolveResult -> new JavaMethodCandidateInfo((PsiMethod)javaResolveResult.getElement(), javaResolveResult.getSubstitutor()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/resolve/JavaMethodResolveHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/resolve/JavaMethodResolveHelper";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCandidateInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addMethod";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ErrorType {
        NONE,
        STATIC,
        RESOLVE;

    }
}

