/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.VariableDataSnapshot;
import com.intellij.refactoring.util.VariableData;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class ExtractMethodSnapshot {
    public final Project myProject;
    public final String myMethodName;
    public final boolean myStatic;
    public final boolean myIsChainedConstructor;
    public final String myMethodVisibility;
    public final Nullness myNullness;
    public final SmartTypePointer myReturnType;
    public final List<SmartPsiElementPointer<PsiVariable>> myOutputVariables;
    public final SmartPsiElementPointer<PsiVariable> myOutputVariable;
    public final SmartPsiElementPointer<PsiVariable> myArtificialOutputVariable;
    public final List<VariableDataSnapshot> myVariableDatum;

    public ExtractMethodSnapshot(@NotNull ExtractMethodProcessor from) {
        if (from == null) {
            ExtractMethodSnapshot.$$$reportNull$$$0(0);
        }
        this.myProject = from.getProject();
        this.myMethodName = from.myMethodName;
        this.myStatic = from.myStatic;
        this.myIsChainedConstructor = from.myIsChainedConstructor;
        this.myMethodVisibility = from.myMethodVisibility;
        this.myNullness = from.myNullness;
        SmartTypePointerManager typePointerManager = SmartTypePointerManager.getInstance((Project)this.myProject);
        this.myReturnType = typePointerManager.createSmartTypePointer(from.myReturnType);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        this.myOutputVariables = StreamEx.of((Object[])from.myOutputVariables).map(arg_0 -> ((SmartPointerManager)smartPointerManager).createSmartPsiElementPointer(arg_0)).toList();
        this.myOutputVariable = (SmartPsiElementPointer)ContainerUtil.getFirstItem(this.myOutputVariables);
        this.myArtificialOutputVariable = from.myArtificialOutputVariable != null ? smartPointerManager.createSmartPsiElementPointer((PsiElement)from.myArtificialOutputVariable) : null;
        this.myVariableDatum = StreamEx.of((Object[])from.myVariableDatum).map(data -> new VariableDataSnapshot((VariableData)((Object)data), this.myProject)).toList();
    }

    public void disposeSmartPointers() {
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        this.myOutputVariables.forEach(arg_0 -> ((SmartPointerManager)smartPointerManager).removePointer(arg_0));
        if (this.myArtificialOutputVariable != null) {
            smartPointerManager.removePointer(this.myArtificialOutputVariable);
        }
        this.myVariableDatum.stream().map(data -> data.myVariable).forEach(arg_0 -> ((SmartPointerManager)smartPointerManager).removePointer(arg_0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/refactoring/extractMethod/ExtractMethodSnapshot", "<init>"));
    }
}

