/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.extractMethod.preview.FragmentNode;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateNode
extends FragmentNode {
    private final SmartPsiElementPointer<PsiElement> myStart;
    private final SmartPsiElementPointer<PsiElement> myEnd;
    private boolean myExcluded;

    public DuplicateNode(@NotNull Match duplicate) {
        if (duplicate == null) {
            DuplicateNode.$$$reportNull$$$0(0);
        }
        super(duplicate.getMatchStart(), duplicate.getMatchEnd());
        PsiElement start = duplicate.getMatchStart();
        PsiElement end = duplicate.getMatchEnd();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)start.getProject());
        this.myStart = smartPointerManager.createSmartPsiElementPointer(start);
        this.myEnd = smartPointerManager.createSmartPsiElementPointer(end);
    }

    @Nullable
    public PsiElement getStart() {
        return this.myStart.getElement();
    }

    @Nullable
    public PsiElement getEnd() {
        return this.myEnd.getElement();
    }

    public TextRange getTextRange() {
        return DuplicateNode.getTextRange(this.getStart(), this.getEnd());
    }

    @Nullable
    public static TextRange getTextRange(@Nullable PsiElement start, @Nullable PsiElement end) {
        if (start != null && end != null) {
            return new TextRange(start.getTextRange().getStartOffset(), end.getTextRange().getEndOffset());
        }
        return null;
    }

    @Override
    protected Navigatable getNavigatable() {
        return (Navigatable)ObjectUtils.tryCast((Object)this.getStart(), Navigatable.class);
    }

    @Override
    public boolean isExcluded() {
        return this.myExcluded;
    }

    public void setExcluded(boolean excluded) {
        this.myExcluded = excluded;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "duplicate", "com/intellij/refactoring/extractMethod/preview/DuplicateNode", "<init>"));
    }
}

