/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.preview.DuplicateNode;
import com.intellij.refactoring.extractMethod.preview.FragmentNode;
import com.intellij.refactoring.extractMethod.preview.PreviewTreeListener;
import com.intellij.refactoring.extractMethod.preview.PreviewTreeModel;
import com.intellij.refactoring.extractMethod.preview.PreviewTreeRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

class PreviewTree
implements Disposable {
    private final Project myProject;
    private final Tree myTree;
    private final List<PreviewTreeListener> myTreeListeners = new SmartList();
    private final PreviewTreeModel myModel;

    public PreviewTree(ExtractMethodProcessor processor) {
        this.myProject = processor.getProject();
        this.myModel = new PreviewTreeModel(processor);
        this.myTree = this.createTree(this.myModel);
    }

    private Tree createTree(DefaultTreeModel model) {
        Tree tree = new Tree((TreeModel)model);
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        tree.setCellRenderer((TreeCellRenderer)((Object)new PreviewTreeRenderer()));
        tree.setName("ExtractMethodPreview");
        tree.getSelectionModel().addTreeSelectionListener(e -> ApplicationManager.getApplication().invokeLater(() -> this.onSelectionUpdate()));
        SmartExpander.installOn((JTree)tree);
        TreeUtil.installActions((JTree)tree);
        TreeUtil.expand((JTree)tree, (int)2);
        TreeUtil.selectFirstNode((JTree)tree);
        PopupHandler.installPopupHandler((JComponent)tree, (String)"ExtractMethodToolWindow.TreePopup", (String)"unknown");
        return tree;
    }

    public void addTreeListener(PreviewTreeListener listener) {
        this.myTreeListeners.add(listener);
    }

    void onSelectionUpdate() {
        if (this.myProject.isDisposed()) {
            return;
        }
        FragmentNode firstSelectedNode = (FragmentNode)ContainerUtil.getFirstItem(this.getSelectedNodes());
        if (firstSelectedNode != null) {
            List<DuplicateNode> enabledDuplicates = this.myModel.getEnabledDuplicates();
            for (PreviewTreeListener listener : this.myTreeListeners) {
                listener.onFragmentSelected(firstSelectedNode, enabledDuplicates);
            }
        }
    }

    @NotNull
    public List<FragmentNode> getSelectedNodes() {
        Object[] selectionPaths = this.myTree.getSelectionPaths();
        if (ArrayUtil.isEmpty((Object[])selectionPaths)) {
            List<FragmentNode> list = Collections.emptyList();
            if (list == null) {
                PreviewTree.$$$reportNull$$$0(0);
            }
            return list;
        }
        List list = StreamEx.of((Object[])selectionPaths).map(TreePath::getLastPathComponent).select(FragmentNode.class).toList();
        if (list == null) {
            PreviewTree.$$$reportNull$$$0(1);
        }
        return list;
    }

    public List<DuplicateNode> getAllDuplicates() {
        return this.myModel.getAllDuplicates();
    }

    public List<DuplicateNode> getEnabledDuplicates() {
        return this.myModel.getEnabledDuplicates();
    }

    public JComponent getComponent() {
        return this.myTree;
    }

    public void dispose() {
        this.myTreeListeners.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/extractMethod/preview/PreviewTree", "getSelectedNodes"));
    }
}

