/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectDialog;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectViewDescriptor;
import com.intellij.refactoring.extractMethodObject.MethodToMoveUsageInfo;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExtractMethodObjectProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(ExtractMethodObjectProcessor.class);
    @NonNls
    public static final String REFACTORING_NAME = "Extract Method Object";
    private final PsiElementFactory myElementFactory;
    protected final MyExtractMethodProcessor myExtractProcessor;
    private boolean myCreateInnerClass = true;
    private String myInnerClassName;
    private boolean myMultipleExitPoints;
    private PsiField[] myOutputFields;
    private PsiMethod myInnerMethod;
    private boolean myMadeStatic;
    private final Set<MethodToMoveUsageInfo> myUsages = new LinkedHashSet<MethodToMoveUsageInfo>();
    private PsiClass myInnerClass;
    private boolean myChangeReturnType;
    private Runnable myCopyMethodToInner;
    private final UniqueNameGenerator myFieldNameGenerator = new UniqueNameGenerator();
    private String myResultFieldName = null;
    private static final Key<Boolean> GENERATED_RETURN = new Key("GENERATED_RETURN");

    public ExtractMethodObjectProcessor(Project project, Editor editor, PsiElement[] elements, String innerClassName) {
        super(project);
        this.myInnerClassName = innerClassName;
        this.myExtractProcessor = new MyExtractMethodProcessor(project, editor, elements, null, REFACTORING_NAME, innerClassName, "refactoring.extractMethodObject");
        this.myElementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ExtractMethodObjectProcessor.$$$reportNull$$$0(0);
        }
        ExtractMethodObjectViewDescriptor extractMethodObjectViewDescriptor = new ExtractMethodObjectViewDescriptor(this.getMethod());
        if (extractMethodObjectViewDescriptor == null) {
            ExtractMethodObjectProcessor.$$$reportNull$$$0(1);
        }
        return extractMethodObjectViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        PsiReference[] refs;
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        PsiClass containingClass = this.getMethod().getContainingClass();
        LocalSearchScope scope = PsiUtilCore.getVirtualFile((PsiElement)containingClass) == null ? new LocalSearchScope((PsiElement)containingClass) : GlobalSearchScope.projectScope((Project)this.myProject);
        for (PsiReference ref : refs = (PsiReference[])ReferencesSearch.search((PsiElement)this.getMethod(), (SearchScope)scope, (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
            PsiElement element = ref.getElement();
            if (element == null || !element.isValid()) continue;
            result.add(new UsageInfo(element));
        }
        if (this.isCreateInnerClass()) {
            final LinkedHashSet usedMethods = new LinkedHashSet();
            this.getMethod().accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                    super.visitMethodCallExpression(expression2);
                    PsiMethod method = expression2.resolveMethod();
                    if (method != null) {
                        usedMethods.add(method);
                    }
                }
            });
            for (PsiMethod usedMethod : usedMethods) {
                if (!usedMethod.hasModifierProperty("private") || usedMethod.hasModifierProperty("static") && !this.myExtractProcessor.isStatic()) continue;
                PsiMethod toMove = usedMethod;
                for (PsiReference reference : ReferencesSearch.search((PsiElement)usedMethod)) {
                    if (PsiTreeUtil.isAncestor((PsiElement)this.getMethod(), (PsiElement)reference.getElement(), (boolean)false)) continue;
                    toMove = null;
                    break;
                }
                if (toMove == null) continue;
                this.myUsages.add(new MethodToMoveUsageInfo(toMove));
            }
        }
        UsageInfo[] usageInfos = result.toArray(UsageInfo.EMPTY_ARRAY);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        if (usageInfoArray == null) {
            ExtractMethodObjectProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    public void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ExtractMethodObjectProcessor.$$$reportNull$$$0(3);
        }
        try {
            if (this.isCreateInnerClass()) {
                PsiParameter[] parameters2;
                this.myInnerClass = (PsiClass)this.getMethod().getContainingClass().add((PsiElement)this.myElementFactory.createClass(this.getInnerClassName()));
                boolean isStatic = this.copyMethodModifiers() && this.notHasGeneratedFields();
                for (UsageInfo usage : usages) {
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)usage.getElement(), PsiMethodCallExpression.class);
                    if (methodCallExpression == null) continue;
                    this.replaceMethodCallExpression(this.inferTypeArguments(methodCallExpression), methodCallExpression);
                }
                if (this.myExtractProcessor.generatesConditionalExit()) {
                    this.myResultFieldName = this.uniqueFieldName(new String[]{"myResult"});
                    this.myInnerClass.add((PsiElement)this.myElementFactory.createField(this.myResultFieldName, (PsiType)PsiType.BOOLEAN));
                    this.myInnerClass.add((PsiElement)this.myElementFactory.createMethodFromText("boolean is(){return " + this.myResultFieldName + ";}", (PsiElement)this.myInnerClass));
                }
                if ((parameters2 = this.getMethod().getParameterList().getParameters()).length > 0) {
                    this.createInnerClassConstructor(parameters2);
                } else if (isStatic) {
                    PsiMethod copy = (PsiMethod)this.getMethod().copy();
                    copy.setName("invoke");
                    this.myInnerClass.add((PsiElement)copy);
                    if (this.myMultipleExitPoints) {
                        this.addOutputVariableFieldsWithGetters();
                    }
                    return;
                }
                if (this.myMultipleExitPoints) {
                    this.addOutputVariableFieldsWithGetters();
                }
                this.myCopyMethodToInner = () -> {
                    this.copyMethodWithoutParameters();
                    this.copyMethodTypeParameters();
                };
            } else {
                for (UsageInfo usage : usages) {
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)usage.getElement(), PsiMethodCallExpression.class);
                    if (methodCallExpression == null) continue;
                    methodCallExpression.replace((PsiElement)this.processMethodDeclaration(methodCallExpression.getArgumentList()));
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    void moveUsedMethodsToInner() {
        if (!this.myUsages.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                WriteAction.run(() -> {
                    for (MethodToMoveUsageInfo usage : this.myUsages) {
                        PsiMember member = (PsiMember)usage.getElement();
                        LOG.assertTrue(member != null);
                        this.myInnerClass.add(member.copy());
                        member.delete();
                    }
                });
                return;
            }
            ArrayList<MemberInfo> memberInfos = new ArrayList<MemberInfo>();
            for (MethodToMoveUsageInfo usage : this.myUsages) {
                memberInfos.add(new MemberInfo((PsiMember)((PsiMethod)usage.getElement())));
            }
            final MemberSelectionPanel panel = new MemberSelectionPanel("&Methods to move to the extracted class", memberInfos, null);
            DialogWrapper dlg = new DialogWrapper(this.myProject, false){
                {
                    super(arg0, arg1);
                    this.init();
                    this.setTitle("Move Methods Used in Extracted Block Only");
                }

                protected JComponent createCenterPanel() {
                    return panel;
                }
            };
            if (dlg.showAndGet()) {
                WriteAction.run(() -> {
                    for (MemberInfoBase memberInfo : panel.getTable().getSelectedMemberInfos()) {
                        if (!memberInfo.isChecked()) continue;
                        this.myInnerClass.add(((PsiMember)memberInfo.getMember()).copy());
                        ((PsiMember)memberInfo.getMember()).delete();
                    }
                });
            }
        }
    }

    private void addOutputVariableFieldsWithGetters() throws IncorrectOperationException {
        HashMap<String, String> var2FieldNames = new HashMap<String, String>();
        Object[] outputVariables = this.myExtractProcessor.getOutputVariables();
        for (int i = 0; i < outputVariables.length; ++i) {
            PsiField field;
            PsiVariable var = outputVariables[i];
            PsiField outputField = this.myOutputFields[i];
            String name = this.getPureName(var);
            LOG.assertTrue(name != null);
            if (outputField != null) {
                var2FieldNames.put(var.getName(), outputField.getName());
                this.myInnerClass.add((PsiElement)outputField);
                field = outputField;
            } else {
                field = PropertyUtilBase.findPropertyField((PsiClass)this.myInnerClass, (String)name, (boolean)false);
            }
            LOG.assertTrue(field != null, (Object)("i:" + i + "; output variables: " + Arrays.toString(outputVariables) + "; parameters: " + Arrays.toString(this.getMethod().getParameterList().getParameters()) + "; output field: " + outputField));
            this.myInnerClass.add((PsiElement)GenerateMembersUtil.generateGetterPrototype(field));
        }
        PsiCodeBlock body2 = this.getMethod().getBody();
        LOG.assertTrue(body2 != null);
        LinkedHashSet vars = new LinkedHashSet();
        final LinkedHashMap replacementMap = new LinkedHashMap();
        final ArrayList returnStatements = new ArrayList();
        body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReturnStatement(PsiReturnStatement statement) {
                returnStatements.add(statement);
            }

            public void visitClass(PsiClass aClass) {
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
            }
        });
        if (this.myExtractProcessor.generatesConditionalExit()) {
            for (int i = 0; i < returnStatements.size() - 1; ++i) {
                PsiReturnStatement condition2 = (PsiReturnStatement)returnStatements.get(i);
                PsiElement container = condition2.getParent();
                LOG.assertTrue(this.myResultFieldName != null);
                Iterator resultStmt = this.myElementFactory.createStatementFromText(this.myResultFieldName + " = true;", container);
                if (!RefactoringUtil.isLoopOrIf(container)) {
                    container.addBefore((PsiElement)resultStmt, (PsiElement)condition2);
                    continue;
                }
                RefactoringUtil.putStatementInLoopBody((PsiStatement)resultStmt, container, (PsiElement)condition2);
            }
            LOG.assertTrue(!returnStatements.isEmpty());
            PsiReturnStatement returnStatement = (PsiReturnStatement)returnStatements.get(returnStatements.size() - 1);
            PsiElement container = returnStatement.getParent();
            LOG.assertTrue(this.myResultFieldName != null);
            PsiStatement resultStmt = this.myElementFactory.createStatementFromText(this.myResultFieldName + " = false;", container);
            if (!RefactoringUtil.isLoopOrIf(container)) {
                container.addBefore((PsiElement)resultStmt, (PsiElement)returnStatement);
            } else {
                RefactoringUtil.putStatementInLoopBody(resultStmt, container, (PsiElement)returnStatement);
            }
        }
        body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((PsiVariable[])outputVariables, var2FieldNames, vars){
            final /* synthetic */ PsiVariable[] val$outputVariables;
            final /* synthetic */ Map val$var2FieldNames;
            final /* synthetic */ LinkedHashSet val$vars;
            {
                this.val$outputVariables = psiVariableArray;
                this.val$var2FieldNames = map2;
                this.val$vars = linkedHashSet;
            }

            public void visitReturnStatement(PsiReturnStatement statement) {
                super.visitReturnStatement(statement);
                try {
                    PsiStatement returnThisStatement = ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText("return this;", (PsiElement)statement);
                    returnThisStatement.putCopyableUserData(GENERATED_RETURN, (Object)true);
                    replacementMap.put(statement, returnThisStatement);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            public void visitClass(PsiClass aClass) {
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
            }

            public void visitDeclarationStatement(PsiDeclarationStatement statement) {
                PsiElement[] declaredElements;
                super.visitDeclarationStatement(statement);
                for (PsiElement declaredElement : declaredElements = statement.getDeclaredElements()) {
                    if (!(declaredElement instanceof PsiVariable)) continue;
                    for (PsiVariable variable : this.val$outputVariables) {
                        PsiVariable var = (PsiVariable)declaredElement;
                        if (!Comparing.strEqual((String)var.getName(), (String)variable.getName())) continue;
                        replacementMap.put(var, var.getInitializer());
                    }
                }
            }

            public void visitParameter(PsiParameter parameter2) {
                super.visitParameter(parameter2);
                PsiElement declarationScope = parameter2.getDeclarationScope();
                for (PsiVariable variable : this.val$outputVariables) {
                    if (!Comparing.strEqual((String)variable.getName(), (String)parameter2.getName())) continue;
                    replacementMap.put(parameter2, ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText(ExtractMethodObjectProcessor.this.myInnerClassName + ".this." + (String)this.val$var2FieldNames.get(variable.getName()) + " = " + parameter2.getName() + ";", declarationScope));
                }
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                PsiElement resolved = expression2.resolve();
                if (resolved instanceof PsiLocalVariable) {
                    String var = ((PsiLocalVariable)resolved).getName();
                    for (PsiVariable variable : this.val$outputVariables) {
                        if (!Comparing.strEqual((String)variable.getName(), (String)var)) continue;
                        this.val$vars.add((PsiLocalVariable)resolved);
                        break;
                    }
                }
            }
        });
        for (PsiLocalVariable var : vars) {
            String fieldName = (String)var2FieldNames.get(var.getName());
            for (PsiReference reference : ReferencesSearch.search((PsiElement)var)) {
                reference.handleElementRename(fieldName);
            }
        }
        LinkedHashMap<PsiStatement, PsiForeachStatement> blocksToReplace = new LinkedHashMap<PsiStatement, PsiForeachStatement>();
        for (PsiElement statement : replacementMap.keySet()) {
            PsiElement replacement = (PsiElement)replacementMap.get(statement);
            if (replacement != null) {
                PsiExpression returnValue;
                if (statement instanceof PsiParameter) {
                    PsiCodeBlock codeBlock = null;
                    PsiElement declarationScope = ((PsiParameter)statement).getDeclarationScope();
                    if (declarationScope instanceof PsiForeachStatement) {
                        PsiStatement loopBody = ((PsiForeachStatement)declarationScope).getBody();
                        if (loopBody instanceof PsiBlockStatement) {
                            codeBlock = ((PsiBlockStatement)loopBody).getCodeBlock();
                        } else {
                            blocksToReplace.put((PsiStatement)replacement, (PsiForeachStatement)declarationScope);
                        }
                    } else if (declarationScope instanceof PsiCatchSection) {
                        codeBlock = ((PsiCatchSection)declarationScope).getCatchBlock();
                    }
                    if (codeBlock == null) continue;
                    codeBlock.addBefore(replacement, codeBlock.getFirstBodyElement());
                    continue;
                }
                if (statement instanceof PsiLocalVariable) {
                    PsiLocalVariable variable = (PsiLocalVariable)statement;
                    variable.normalizeDeclaration();
                    PsiExpression initializer = variable.getInitializer();
                    LOG.assertTrue(initializer != null);
                    PsiStatement assignmentStatement = this.myElementFactory.createStatementFromText((String)var2FieldNames.get(variable.getName()) + " = " + initializer.getText() + ";", statement);
                    PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiDeclarationStatement.class);
                    LOG.assertTrue(declaration2 != null);
                    declaration2.replace((PsiElement)assignmentStatement);
                    continue;
                }
                if (statement instanceof PsiReturnStatement && !((returnValue = ((PsiReturnStatement)statement).getReturnValue()) instanceof PsiReferenceExpression) && returnValue != null && !(returnValue instanceof PsiLiteralExpression)) {
                    statement.getParent().addBefore((PsiElement)this.myElementFactory.createStatementFromText(returnValue.getText() + ";", (PsiElement)returnValue), statement);
                }
                statement.replace(replacement);
                continue;
            }
            statement.delete();
        }
        for (PsiElement statement : blocksToReplace.keySet()) {
            RefactoringUtil.putStatementInLoopBody((PsiStatement)statement, (PsiElement)blocksToReplace.get(statement), null);
        }
        this.myChangeReturnType = true;
    }

    void runChangeSignature() {
        if (this.myCopyMethodToInner != null) {
            this.myCopyMethodToInner.run();
        }
        if (this.myChangeReturnType) {
            PsiTypeElement typeElement = ((PsiLocalVariable)((PsiDeclarationStatement)JavaPsiFacade.getElementFactory((Project)this.myProject).createStatementFromText(this.myInnerClassName + " l =null;", (PsiElement)this.myInnerClass)).getDeclaredElements()[0]).getTypeElement();
            PsiTypeElement innerMethodReturnTypeElement = this.myInnerMethod.getReturnTypeElement();
            LOG.assertTrue(innerMethodReturnTypeElement != null);
            innerMethodReturnTypeElement.replace((PsiElement)typeElement);
        }
    }

    private String getPureName(PsiVariable var) {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        return styleManager.variableNameToPropertyName(var.getName(), styleManager.getVariableKind(var));
    }

    public PsiExpression processMethodDeclaration(PsiExpressionList expressionList) throws IncorrectOperationException {
        if (this.isCreateInnerClass()) {
            String typeArguments = this.getMethod().hasTypeParameters() ? "<" + StringUtil.join(Arrays.asList(this.getMethod().getTypeParameters()), typeParameter -> {
                String typeParameterName = typeParameter.getName();
                LOG.assertTrue(typeParameterName != null);
                return typeParameterName;
            }, (String)", ") + ">" : "";
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)this.myElementFactory.createExpressionFromText("invoke" + expressionList.getText(), null);
            return this.replaceMethodCallExpression(typeArguments, methodCallExpression);
        }
        String paramsDeclaration = this.getMethod().getParameterList().getText();
        PsiType returnType = this.getMethod().getReturnType();
        LOG.assertTrue(returnType != null);
        PsiCodeBlock methodBody2 = this.getMethod().getBody();
        LOG.assertTrue(methodBody2 != null);
        this.adjustTargetClassReferences((PsiElement)methodBody2);
        return this.myElementFactory.createExpressionFromText("new Object(){ \nprivate " + returnType.getPresentableText() + " " + this.myInnerClassName + paramsDeclaration + methodBody2.getText() + "}." + this.myInnerClassName + expressionList.getText(), null);
    }

    private PsiMethodCallExpression replaceMethodCallExpression(String inferredTypeArguments, PsiMethodCallExpression methodCallExpression) throws IncorrectOperationException {
        String newReplacement;
        String staticqualifier = this.getMethod().hasModifierProperty("static") && this.notHasGeneratedFields() ? this.getInnerClassName() : null;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        if (staticqualifier != null) {
            newReplacement = argumentList.isEmpty() ? staticqualifier + "." : "new " + staticqualifier + inferredTypeArguments + argumentList.getText() + ".";
        } else {
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            String qualifier = qualifierExpression2 != null ? qualifierExpression2.getText() + "." : "";
            newReplacement = qualifier + "new " + this.getInnerClassName() + inferredTypeArguments + argumentList.getText() + ".";
        }
        return (PsiMethodCallExpression)methodCallExpression.replace((PsiElement)this.myElementFactory.createExpressionFromText(newReplacement + "invoke()", null));
    }

    @NotNull
    private String inferTypeArguments(PsiMethodCallExpression methodCallExpression) {
        PsiReferenceParameterList list = methodCallExpression.getMethodExpression().getParameterList();
        if (list != null && list.getTypeArguments().length > 0) {
            String string = list.getText();
            if (string == null) {
                ExtractMethodObjectProcessor.$$$reportNull$$$0(4);
            }
            return string;
        }
        PsiTypeParameter[] methodTypeParameters = this.getMethod().getTypeParameters();
        if (methodTypeParameters.length > 0) {
            ArrayList<String> typeSignature = new ArrayList<String>();
            PsiSubstitutor substitutor = methodCallExpression.resolveMethodGenerics().getSubstitutor();
            for (PsiTypeParameter typeParameter : methodTypeParameters) {
                PsiType type2 = substitutor.substitute(typeParameter);
                if (type2 == null || PsiType.NULL.equals((Object)type2)) {
                    if ("" == null) {
                        ExtractMethodObjectProcessor.$$$reportNull$$$0(5);
                    }
                    return "";
                }
                typeSignature.add(type2.getPresentableText());
            }
            String string = "<" + StringUtil.join(typeSignature, (String)", ") + ">";
            if (string == null) {
                ExtractMethodObjectProcessor.$$$reportNull$$$0(6);
            }
            return string;
        }
        if ("" == null) {
            ExtractMethodObjectProcessor.$$$reportNull$$$0(7);
        }
        return "";
    }

    @NotNull
    protected String getCommandName() {
        if (REFACTORING_NAME == null) {
            ExtractMethodObjectProcessor.$$$reportNull$$$0(8);
        }
        return REFACTORING_NAME;
    }

    private boolean copyMethodModifiers() throws IncorrectOperationException {
        PsiModifierList methodModifierList = this.getMethod().getModifierList();
        PsiModifierList innerClassModifierList = this.myInnerClass.getModifierList();
        LOG.assertTrue(innerClassModifierList != null);
        innerClassModifierList.setModifierProperty(VisibilityUtil.getVisibilityModifier((PsiModifierList)methodModifierList), true);
        boolean isStatic = methodModifierList.hasModifierProperty("static");
        innerClassModifierList.setModifierProperty("static", isStatic);
        return isStatic;
    }

    private void copyMethodTypeParameters() throws IncorrectOperationException {
        PsiTypeParameterList typeParameterList = this.myInnerClass.getTypeParameterList();
        LOG.assertTrue(typeParameterList != null);
        for (PsiTypeParameter parameter2 : this.getMethod().getTypeParameters()) {
            typeParameterList.add((PsiElement)parameter2);
        }
    }

    private void copyMethodWithoutParameters() throws IncorrectOperationException {
        PsiMethod newMethod = this.myElementFactory.createMethod("invoke", this.getMethod().getReturnType());
        newMethod.getThrowsList().replace((PsiElement)this.getMethod().getThrowsList());
        PsiCodeBlock replacedMethodBody = newMethod.getBody();
        LOG.assertTrue(replacedMethodBody != null);
        PsiCodeBlock methodBody2 = this.getMethod().getBody();
        LOG.assertTrue(methodBody2 != null);
        if (this.isCreateInnerClass()) {
            this.adjustTargetClassReferences((PsiElement)methodBody2);
        }
        replacedMethodBody.replace((PsiElement)methodBody2);
        PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)"static", (this.myInnerClass.hasModifierProperty("static") && this.notHasGeneratedFields() ? 1 : 0) != 0);
        this.myInnerMethod = (PsiMethod)this.myInnerClass.add((PsiElement)newMethod);
    }

    private void adjustTargetClassReferences(PsiElement body2) throws IncorrectOperationException {
        final PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        final PsiClass targetClass = this.getMethod().getContainingClass();
        body2.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReturnStatement(PsiReturnStatement statement) {
                if (statement.getCopyableUserData(GENERATED_RETURN) == null) {
                    super.visitReturnStatement(statement);
                }
            }

            public void visitThisExpression(PsiThisExpression expression2) {
                if (expression2.getQualifier() == null) {
                    expression2.replace((PsiElement)RefactoringChangeUtil.createThisExpression(manager, targetClass));
                }
            }

            public void visitSuperExpression(PsiSuperExpression expression2) {
                if (expression2.getQualifier() == null) {
                    expression2.replace((PsiElement)RefactoringChangeUtil.createSuperExpression(manager, targetClass));
                }
            }

            public void visitClass(PsiClass aClass) {
            }
        });
    }

    private boolean notHasGeneratedFields() {
        return !this.myMultipleExitPoints && this.getMethod().getParameterList().isEmpty();
    }

    private void createInnerClassConstructor(PsiParameter[] parameters2) throws IncorrectOperationException {
        PsiMethod constructor = this.myElementFactory.createConstructor();
        PsiParameterList parameterList = constructor.getParameterList();
        for (PsiParameter parameter2 : parameters2) {
            PsiModifierList parameterModifierList = parameter2.getModifierList();
            LOG.assertTrue(parameterModifierList != null);
            String parameterName = parameter2.getName();
            LOG.assertTrue(parameterName != null);
            PsiParameter parm = this.myElementFactory.createParameter(parameterName, parameter2.getType());
            if (((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_PARAMETERS) {
                PsiModifierList modifierList = parm.getModifierList();
                LOG.assertTrue(modifierList != null);
                modifierList.setModifierProperty("final", true);
            }
            parameterList.add((PsiElement)parm);
            PsiField field = this.createField(parm, constructor, parameterModifierList.hasModifierProperty("final"));
            for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter2)) {
                reference.handleElementRename(field.getName());
            }
        }
        this.myInnerClass.add((PsiElement)constructor);
    }

    private PsiField createField(PsiParameter parameter2, PsiMethod constructor, boolean isFinal) {
        String parameterName = parameter2.getName();
        PsiType type2 = parameter2.getType();
        if (type2 instanceof PsiEllipsisType) {
            type2 = ((PsiEllipsisType)type2).toArrayType();
        }
        try {
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.getMethod().getProject());
            String fieldName = this.uniqueFieldName(styleManager.suggestVariableName((VariableKind)VariableKind.FIELD, (String)styleManager.variableNameToPropertyName((String)parameterName, (VariableKind)VariableKind.PARAMETER), null, (PsiType)type2).names);
            PsiField field = this.myElementFactory.createField(fieldName, type2);
            PsiModifierList modifierList = field.getModifierList();
            LOG.assertTrue(modifierList != null);
            NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)this.myProject);
            if (manager.isNullable((PsiModifierListOwner)parameter2, false)) {
                modifierList.addAfter((PsiElement)this.myElementFactory.createAnnotationFromText("@" + manager.getDefaultNullable(), (PsiElement)field), null);
            }
            modifierList.setModifierProperty("final", isFinal);
            PsiCodeBlock methodBody2 = constructor.getBody();
            LOG.assertTrue(methodBody2 != null);
            String stmtText = Comparing.strEqual((String)parameterName, (String)fieldName) ? "this." + fieldName + " = " + parameterName + ";" : fieldName + " = " + parameterName + ";";
            PsiStatement assignmentStmt = this.myElementFactory.createStatementFromText(stmtText, (PsiElement)methodBody2);
            assignmentStmt = (PsiStatement)CodeStyleManager.getInstance((Project)constructor.getProject()).reformat((PsiElement)assignmentStmt);
            methodBody2.add((PsiElement)assignmentStmt);
            field = (PsiField)this.myInnerClass.add((PsiElement)field);
            return field;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    protected void changeInstanceAccess(Project project) throws IncorrectOperationException {
        if (this.myMadeStatic) {
            PsiReference[] refs;
            for (PsiReference ref : refs = (PsiReference[])ReferencesSearch.search((PsiElement)this.myInnerMethod, (SearchScope)GlobalSearchScope.projectScope((Project)project), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
                PsiElement element = ref.getElement();
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
                if (callExpression == null) continue;
                this.replaceMethodCallExpression(this.inferTypeArguments(callExpression), callExpression);
            }
        }
    }

    public PsiMethod getMethod() {
        return this.myExtractProcessor.getExtractedMethod();
    }

    public String getInnerClassName() {
        return this.myInnerClassName;
    }

    public void setCreateInnerClass(boolean createInnerClass) {
        this.myCreateInnerClass = createInnerClass;
    }

    public boolean isCreateInnerClass() {
        return this.myCreateInnerClass;
    }

    public MyExtractMethodProcessor getExtractProcessor() {
        return this.myExtractProcessor;
    }

    protected AbstractExtractDialog createExtractMethodObjectDialog(final MyExtractMethodProcessor processor) {
        return new ExtractMethodObjectDialog(this.myProject, processor.getTargetClass(), processor.getInputVariables(), processor.getReturnType(), processor.getTypeParameterList(), (PsiType[])processor.getThrownExceptions(), processor.isStatic(), processor.isCanBeStatic(), processor.getElements(), this.myMultipleExitPoints){

            @Override
            protected boolean isUsedAfter(PsiVariable variable) {
                return ArrayUtil.find((Object[])processor.getOutputVariables(), (Object)variable) != -1;
            }
        };
    }

    public PsiClass getInnerClass() {
        return this.myInnerClass;
    }

    protected boolean isFoldingApplicable() {
        return true;
    }

    private String uniqueFieldName(String[] candidates) {
        String name = StreamEx.of((Object[])candidates).findFirst(arg_0 -> ((UniqueNameGenerator)this.myFieldNameGenerator).isUnique(arg_0)).orElse(null);
        if (name == null) {
            name = this.myFieldNameGenerator.generateUniqueName(candidates[0]);
        }
        this.myFieldNameGenerator.addExistingName(name);
        return name;
    }

    static /* synthetic */ PsiField[] access$602(ExtractMethodObjectProcessor x0, PsiField[] x1) {
        x0.myOutputFields = x1;
        return x1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeArguments";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MyExtractMethodProcessor
    extends ExtractMethodProcessor {
        public MyExtractMethodProcessor(Project project, Editor editor, PsiElement[] elements, PsiType forcedReturnType, String refactoringName, String initialMethodName, String helpId) {
            super(project, editor, elements, forcedReturnType, refactoringName, initialMethodName, helpId);
        }

        @Override
        protected boolean insertNotNullCheckIfPossible() {
            return false;
        }

        @Override
        protected boolean isNeedToChangeCallContext() {
            return false;
        }

        @Override
        protected void apply(AbstractExtractDialog dialog) {
            super.apply(dialog);
            ExtractMethodObjectProcessor.this.myCreateInnerClass = !(dialog instanceof ExtractMethodObjectDialog) || ((ExtractMethodObjectDialog)dialog).createInnerClass();
            ExtractMethodObjectProcessor.this.myInnerClassName = ExtractMethodObjectProcessor.this.myCreateInnerClass ? StringUtil.capitalize((String)dialog.getChosenMethodName()) : dialog.getChosenMethodName();
        }

        @Override
        protected AbstractExtractDialog createExtractMethodDialog(boolean direct) {
            return ExtractMethodObjectProcessor.this.createExtractMethodObjectDialog(this);
        }

        @Override
        protected PsiExpression expressionToReplace(PsiExpression expression2) {
            IElementType elementType;
            if (expression2 instanceof PsiUnaryExpression && ((elementType = ((PsiUnaryExpression)expression2).getOperationTokenType()) == JavaTokenType.PLUSPLUS || elementType == JavaTokenType.MINUSMINUS)) {
                PsiExpression operand2 = ((PsiUnaryExpression)expression2).getOperand();
                return ((PsiBinaryExpression)expression2.replace((PsiElement)ExtractMethodObjectProcessor.this.myElementFactory.createExpressionFromText(operand2.getText() + " + x", (PsiElement)operand2))).getROperand();
            }
            return super.expressionToReplace(expression2);
        }

        @Override
        protected boolean checkOutputVariablesCount() {
            ExtractMethodObjectProcessor.this.myMultipleExitPoints = super.checkOutputVariablesCount();
            ExtractMethodObjectProcessor.access$602(ExtractMethodObjectProcessor.this, new PsiField[this.myOutputVariables.length]);
            for (int i = 0; i < this.myOutputVariables.length; ++i) {
                PsiVariable variable = this.myOutputVariables[i];
                if (this.myInputVariables.contains(variable)) continue;
                String fieldName = ExtractMethodObjectProcessor.this.uniqueFieldName(JavaCodeStyleManager.getInstance((Project)this.myProject).suggestVariableName((VariableKind)VariableKind.FIELD, (String)((ExtractMethodObjectProcessor)ExtractMethodObjectProcessor.this).getPureName((PsiVariable)variable), null, (PsiType)variable.getType()).names);
                try {
                    ((ExtractMethodObjectProcessor)ExtractMethodObjectProcessor.this).myOutputFields[i] = ExtractMethodObjectProcessor.this.myElementFactory.createField(fieldName, variable.getType());
                    continue;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            return !ExtractMethodObjectProcessor.this.myCreateInnerClass && ExtractMethodObjectProcessor.this.myMultipleExitPoints;
        }

        @Override
        public PsiElement processMatch(Match match) throws IncorrectOperationException {
            PsiMethodCallExpression methodCallExpression;
            boolean makeStatic = ExtractMethodObjectProcessor.this.myInnerMethod != null && RefactoringUtil.isInStaticContext(match.getMatchStart(), this.getExtractedMethod().getContainingClass()) && !ExtractMethodObjectProcessor.this.myInnerMethod.getContainingClass().hasModifierProperty("static");
            PsiElement element = super.processMatch(match);
            if (makeStatic) {
                ExtractMethodObjectProcessor.this.myMadeStatic = true;
                PsiModifierList modifierList = ExtractMethodObjectProcessor.this.myInnerMethod.getContainingClass().getModifierList();
                LOG.assertTrue(modifierList != null);
                modifierList.setModifierProperty("static", true);
                PsiUtil.setModifierProperty((PsiModifierListOwner)ExtractMethodObjectProcessor.this.myInnerMethod, (String)"static", (boolean)true);
            }
            if ((methodCallExpression = this.getMatchMethodCallExpression(element)) == null) {
                return element;
            }
            PsiExpression expression2 = ExtractMethodObjectProcessor.this.processMethodDeclaration(methodCallExpression.getArgumentList());
            return methodCallExpression.replace((PsiElement)expression2);
        }

        @Override
        protected void declareNecessaryVariablesAfterCall(PsiVariable outputVariable) throws IncorrectOperationException {
            if (ExtractMethodObjectProcessor.this.myMultipleExitPoints) {
                String object = JavaCodeStyleManager.getInstance((Project)this.myProject).suggestUniqueVariableName(StringUtil.decapitalize((String)ExtractMethodObjectProcessor.this.myInnerClassName), (PsiElement)outputVariable, true);
                PsiStatement methodCallStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.getMethodCall(), PsiStatement.class);
                LOG.assertTrue(methodCallStatement != null);
                PsiStatement declarationStatement = ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText(ExtractMethodObjectProcessor.this.myInnerClassName + " " + object + " = " + this.getMethodCall().getText() + ";", (PsiElement)ExtractMethodObjectProcessor.this.myInnerMethod);
                if (methodCallStatement instanceof PsiIfStatement) {
                    methodCallStatement.getParent().addBefore((PsiElement)declarationStatement, (PsiElement)methodCallStatement);
                    PsiExpression conditionExpression = ((PsiIfStatement)methodCallStatement).getCondition();
                    this.setMethodCall((PsiMethodCallExpression)conditionExpression.replace((PsiElement)ExtractMethodObjectProcessor.this.myElementFactory.createExpressionFromText(object + ".is()", (PsiElement)ExtractMethodObjectProcessor.this.myInnerMethod)));
                } else if (this.myElements[0] instanceof PsiExpression) {
                    methodCallStatement.getParent().addBefore((PsiElement)declarationStatement, (PsiElement)methodCallStatement);
                } else {
                    PsiDeclarationStatement replace = (PsiDeclarationStatement)methodCallStatement.replace((PsiElement)declarationStatement);
                    this.setMethodCall((PsiMethodCallExpression)((PsiLocalVariable)replace.getDeclaredElements()[0]).getInitializer());
                }
                Object[] usedVariables = this.myOutputVariables;
                if (this.generatesConditionalExit() && this.myOutputVariable != null && !this.myControlFlowWrapper.needVariableValueAfterEnd(this.myOutputVariable)) {
                    usedVariables = (PsiVariable[])ArrayUtil.remove((Object[])usedVariables, (Object)this.myOutputVariable);
                }
                Collection<ControlFlowUtil.VariableInfo> reassigned = this.myControlFlowWrapper.getInitializedTwice();
                for (Object variable : usedVariables) {
                    String getterName;
                    String name = variable.getName();
                    LOG.assertTrue(name != null);
                    PsiStatement st = null;
                    String pureName = ExtractMethodObjectProcessor.this.getPureName((PsiVariable)variable);
                    int varIdxInOutput = ArrayUtil.find((Object[])this.myOutputVariables, (Object)variable);
                    String string = getterName = varIdxInOutput > -1 && ExtractMethodObjectProcessor.this.myOutputFields[varIdxInOutput] != null ? GenerateMembersUtil.suggestGetterName(ExtractMethodObjectProcessor.this.myOutputFields[varIdxInOutput]) : GenerateMembersUtil.suggestGetterName(pureName, variable.getType(), this.myProject);
                    if (this.isDeclaredInside((PsiVariable)variable)) {
                        st = ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText(variable.getType().getCanonicalText() + " " + name + " = " + object + "." + getterName + "();", (PsiElement)ExtractMethodObjectProcessor.this.myInnerMethod);
                        if (reassigned.contains(new ControlFlowUtil.VariableInfo((PsiVariable)variable, null))) {
                            PsiElement[] psiElements = ((PsiDeclarationStatement)st).getDeclaredElements();
                            assert (psiElements.length > 0);
                            PsiVariable var = (PsiVariable)psiElements[0];
                            PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)false);
                        }
                    } else if (varIdxInOutput != -1) {
                        st = ExtractMethodObjectProcessor.this.myElementFactory.createStatementFromText(name + " = " + object + "." + getterName + "();", (PsiElement)ExtractMethodObjectProcessor.this.myInnerMethod);
                    }
                    if (st == null) continue;
                    this.addToMethodCallLocation(st);
                }
                if (this.myElements[0] instanceof PsiAssignmentExpression) {
                    this.getMethodCall().getParent().replace((PsiElement)((PsiAssignmentExpression)this.getMethodCall().getParent()).getLExpression());
                } else if (this.myElements[0] instanceof PsiUnaryExpression) {
                    this.getMethodCall().getParent().replace((PsiElement)((PsiBinaryExpression)this.getMethodCall().getParent()).getLOperand());
                }
                this.rebindExitStatement(object);
            } else {
                super.declareNecessaryVariablesAfterCall(outputVariable);
            }
        }

        @Override
        protected boolean isFoldingApplicable() {
            return ExtractMethodObjectProcessor.this.isFoldingApplicable();
        }

        private void rebindExitStatement(final String objectName) {
            PsiStatement exitStatementCopy = ExtractMethodObjectProcessor.this.myExtractProcessor.myFirstExitStatementCopy;
            if (exitStatementCopy != null) {
                ExtractMethodObjectProcessor.this.myExtractProcessor.getDuplicates().clear();
                final HashMap<String, PsiVariable> outVarsNames = new HashMap<String, PsiVariable>();
                for (PsiVariable variable : this.myOutputVariables) {
                    outVarsNames.put(variable.getName(), variable);
                }
                final HashMap replaceMap = new HashMap();
                exitStatementCopy.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitReferenceExpression(PsiReferenceExpression expression2) {
                        PsiVariable variable;
                        super.visitReferenceExpression(expression2);
                        if (expression2.resolve() == null && (variable = (PsiVariable)outVarsNames.get(expression2.getReferenceName())) != null) {
                            String call2Getter = objectName + "." + GenerateMembersUtil.suggestGetterName(ExtractMethodObjectProcessor.this.getPureName(variable), variable.getType(), MyExtractMethodProcessor.this.myProject) + "()";
                            PsiExpression callToGetter = ExtractMethodObjectProcessor.this.myElementFactory.createExpressionFromText(call2Getter, (PsiElement)variable);
                            replaceMap.put(expression2, callToGetter);
                        }
                    }
                });
                for (PsiElement element : replaceMap.keySet()) {
                    if (!element.isValid()) continue;
                    element.replace((PsiElement)replaceMap.get(element));
                }
            }
        }

        public boolean generatesConditionalExit() {
            return this.myGenerateConditionalExit;
        }
    }
}

