/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomNamedTarget;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.util.RefactoringUtil");
    public static final int EXPR_COPY_SAFE = 0;
    public static final int EXPR_COPY_UNSAFE = 1;
    public static final int EXPR_COPY_PROHIBITED = 2;

    private RefactoringUtil() {
    }

    public static boolean isSourceRoot(PsiDirectory directory) {
        if (directory.getManager() == null) {
            return false;
        }
        Project project = directory.getProject();
        VirtualFile virtualFile = directory.getVirtualFile();
        VirtualFile sourceRootForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(virtualFile);
        return Comparing.equal((Object)virtualFile, (Object)sourceRootForFile);
    }

    public static boolean isInStaticContext(PsiElement element, @Nullable PsiClass aClass) {
        return PsiUtil.getEnclosingStaticElement((PsiElement)element, (PsiClass)aClass) != null;
    }

    @Deprecated
    public static boolean isResolvableType(PsiType type2) {
        return !PsiTypesUtil.hasUnresolvedComponents((PsiType)type2);
    }

    public static PsiElement replaceOccurenceWithFieldRef(PsiExpression occurrence, PsiField newField, PsiClass destinationClass) throws IncorrectOperationException {
        PsiManager manager = destinationClass.getManager();
        String fieldName = newField.getName();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiElement element = (PsiElement)occurrence.getUserData(ElementToWorkOn.PARENT);
        PsiVariable psiVariable = facade.getResolveHelper().resolveAccessibleReferencedVariable(fieldName, (PsiElement)(element != null ? element : occurrence));
        PsiElementFactory factory = facade.getElementFactory();
        if (psiVariable != null && psiVariable.equals(newField)) {
            return IntroduceVariableBase.replace(occurrence, factory.createExpressionFromText(fieldName, null), manager.getProject());
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)factory.createExpressionFromText("this." + fieldName, null);
        if (!occurrence.isValid()) {
            return null;
        }
        if (newField.hasModifierProperty("static")) {
            ref.setQualifierExpression((PsiExpression)factory.createReferenceExpression(destinationClass));
        }
        return IntroduceVariableBase.replace(occurrence, (PsiExpression)ref, manager.getProject());
    }

    public static String suggestUniqueVariableName(String baseName, PsiElement place, PsiField fieldToReplace) {
        int index = 0;
        while (true) {
            final String name = index > 0 ? baseName + index : baseName;
            PsiManager manager = place.getManager();
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)manager.getProject()).getResolveHelper();
            PsiVariable refVar = helper.resolveAccessibleReferencedVariable(name, place);
            if (refVar == null || manager.areElementsEquivalent((PsiElement)refVar, (PsiElement)fieldToReplace)) {
                final boolean[] found = new boolean[]{false};
                place.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitClass(PsiClass aClass) {
                    }

                    public void visitVariable(PsiVariable variable) {
                        if (name.equals(variable.getName())) {
                            found[0] = true;
                            this.stopWalking();
                        }
                    }
                });
                if (!found[0]) {
                    return name;
                }
            }
            ++index;
        }
    }

    @Nullable
    public static String suggestNewOverriderName(String oldOverriderName, String oldBaseName, String newBaseName) {
        if (oldOverriderName.equals(oldBaseName)) {
            return newBaseName;
        }
        int i = oldOverriderName.startsWith(oldBaseName) ? 0 : StringUtil.indexOfIgnoreCase((String)oldOverriderName, (String)oldBaseName, (int)0);
        if (i >= 0) {
            String newOverriderName = oldOverriderName.substring(0, i);
            newOverriderName = Character.isUpperCase(oldOverriderName.charAt(i)) ? newOverriderName + StringUtil.capitalize((String)newBaseName) : newOverriderName + newBaseName;
            int j = i + oldBaseName.length();
            if (j < oldOverriderName.length()) {
                newOverriderName = newOverriderName + oldOverriderName.substring(j);
            }
            return newOverriderName;
        }
        return null;
    }

    public static boolean hasOnDemandStaticImport(PsiElement element, PsiClass aClass) {
        PsiImportList importList;
        if (element.getContainingFile() instanceof PsiJavaFile && (importList = ((PsiJavaFile)element.getContainingFile()).getImportList()) != null) {
            PsiImportStaticStatement[] importStaticStatements = importList.getImportStaticStatements();
            return Arrays.stream(importStaticStatements).anyMatch(stmt -> stmt.isOnDemand() && stmt.resolveTargetClass() == aClass);
        }
        return false;
    }

    public static PsiElement replaceElementsWithMap(PsiElement replaceIn, Map<PsiElement, PsiElement> elementsToReplace) throws IncorrectOperationException {
        for (Map.Entry<PsiElement, PsiElement> e : elementsToReplace.entrySet()) {
            if (e.getKey() == replaceIn) {
                return e.getKey().replace(e.getValue());
            }
            e.getKey().replace(e.getValue());
        }
        return replaceIn;
    }

    public static PsiElement getVariableScope(PsiLocalVariable localVar) {
        if (!(localVar instanceof ImplicitVariable)) {
            return localVar.getParent().getParent();
        }
        return ((ImplicitVariable)localVar).getDeclarationScope();
    }

    @Nullable
    public static PsiElement getParentStatement(@Nullable PsiElement place, boolean skipScopingStatements) {
        PsiElement parent = place;
        while (true) {
            if (parent == null) {
                return null;
            }
            if (parent instanceof PsiStatement) break;
            if (parent instanceof PsiExpression && parent.getParent() instanceof PsiLambdaExpression) {
                return parent;
            }
            parent = parent.getParent();
        }
        PsiElement parentStatement = parent;
        while (parent instanceof PsiStatement) {
            if (!skipScopingStatements && (parent instanceof PsiForStatement && parentStatement == ((PsiForStatement)parent).getBody() || parent instanceof PsiForeachStatement && parentStatement == ((PsiForeachStatement)parent).getBody() || parent instanceof PsiWhileStatement && parentStatement == ((PsiWhileStatement)parent).getBody() || parent instanceof PsiIfStatement && (parentStatement == ((PsiIfStatement)parent).getThenBranch() || parentStatement == ((PsiIfStatement)parent).getElseBranch()))) {
                return parentStatement;
            }
            parentStatement = parent;
            parent = parent.getParent();
        }
        return parentStatement;
    }

    public static PsiElement getParentExpressionAnchorElement(PsiElement place) {
        PsiElement parent = (PsiElement)place.getUserData(ElementToWorkOn.PARENT);
        if (place.getUserData(ElementToWorkOn.OUT_OF_CODE_BLOCK) != null) {
            return parent;
        }
        if (parent == null) {
            parent = place;
        }
        do {
            if (RefactoringUtil.isExpressionAnchorElement(parent)) {
                return parent;
            }
            if (!(parent instanceof PsiExpression) || !(parent.getParent() instanceof PsiLambdaExpression)) continue;
            return parent;
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    public static boolean isExpressionAnchorElement(PsiElement element) {
        if (element instanceof PsiDeclarationStatement && element.getParent() instanceof PsiForStatement) {
            return false;
        }
        return element instanceof PsiStatement || element instanceof PsiClassInitializer || element instanceof PsiField || element instanceof PsiMethod;
    }

    public static PsiElement getLoopForLoopCondition(PsiExpression expression2) {
        PsiExpression outermost = expression2;
        while (outermost.getParent() instanceof PsiExpression) {
            outermost = (PsiExpression)outermost.getParent();
        }
        if (outermost.getParent() instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)outermost.getParent();
            if (forStatement.getCondition() == outermost) {
                return forStatement;
            }
            return null;
        }
        if (outermost.getParent() instanceof PsiExpressionStatement && outermost.getParent().getParent() instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)outermost.getParent().getParent();
            if (forStatement.getUpdate() == outermost.getParent()) {
                return forStatement;
            }
            return null;
        }
        if (outermost.getParent() instanceof PsiWhileStatement) {
            return outermost.getParent();
        }
        if (outermost.getParent() instanceof PsiDoWhileStatement) {
            return outermost.getParent();
        }
        return null;
    }

    public static PsiClass getThisResolveClass(PsiReferenceExpression place) {
        JavaResolveResult resolveResult = place.advancedResolve(false);
        PsiElement scope = resolveResult.getCurrentFileResolveScope();
        if (scope instanceof PsiClass) {
            return (PsiClass)scope;
        }
        return null;
    }

    public static PsiCall getEnclosingConstructorCall(PsiJavaCodeReferenceElement ref) {
        PsiElement parent = ref.getParent();
        if (ref instanceof PsiReferenceExpression && parent instanceof PsiMethodCallExpression) {
            return (PsiCall)parent;
        }
        if (parent instanceof PsiAnonymousClass) {
            parent = parent.getParent();
        }
        return parent instanceof PsiNewExpression ? (PsiNewExpression)parent : null;
    }

    public static PsiMethod getEnclosingMethod(PsiElement element) {
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClass.class, PsiLambdaExpression.class});
        return container instanceof PsiMethod ? (PsiMethod)container : null;
    }

    public static void renameVariableReferences(PsiVariable variable, String newName, SearchScope scope) throws IncorrectOperationException {
        RefactoringUtil.renameVariableReferences(variable, newName, scope, false);
    }

    public static void renameVariableReferences(PsiVariable variable, String newName, SearchScope scope, boolean ignoreAccessScope) throws IncorrectOperationException {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)scope, (boolean)ignoreAccessScope)) {
            reference.handleElementRename(newName);
        }
    }

    public static boolean canBeDeclaredFinal(@NotNull PsiVariable variable) {
        if (variable == null) {
            RefactoringUtil.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(variable instanceof PsiLocalVariable || variable instanceof PsiParameter);
        boolean isReassigned = HighlightControlFlowUtil.isReassigned(variable, (Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>>)new THashMap());
        return !isReassigned;
    }

    public static PsiJavaCodeReferenceElement removeFromReferenceList(PsiReferenceList refList, PsiClass aClass) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] refs;
        for (PsiJavaCodeReferenceElement ref : refs = refList.getReferenceElements()) {
            if (!ref.isReferenceTo((PsiElement)aClass)) continue;
            PsiJavaCodeReferenceElement refCopy = (PsiJavaCodeReferenceElement)ref.copy();
            ref.delete();
            return refCopy;
        }
        return null;
    }

    public static PsiJavaCodeReferenceElement findReferenceToClass(PsiReferenceList refList, PsiClass aClass) {
        PsiJavaCodeReferenceElement[] refs;
        for (PsiJavaCodeReferenceElement ref : refs = refList.getReferenceElements()) {
            if (!ref.isReferenceTo((PsiElement)aClass)) continue;
            return ref;
        }
        return null;
    }

    public static PsiType getTypeByExpressionWithExpectedType(PsiExpression expr) {
        boolean detectConjunct;
        PsiType typeByExpression;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory();
        PsiType type2 = typeByExpression = RefactoringUtil.getTypeByExpression(expr, factory);
        boolean isFunctionalType = LambdaUtil.notInferredType((PsiType)type2);
        PsiType exprType = expr.getType();
        boolean bl = detectConjunct = exprType instanceof PsiIntersectionType || exprType instanceof PsiWildcardType && ((PsiWildcardType)exprType).getBound() instanceof PsiIntersectionType || exprType instanceof PsiCapturedWildcardType && ((PsiCapturedWildcardType)exprType).getUpperBound() instanceof PsiIntersectionType;
        if (type2 != null && !isFunctionalType && !detectConjunct) {
            return type2;
        }
        ExpectedTypeInfo[] expectedTypes = ExpectedTypesProvider.getExpectedTypes(expr, false);
        if (expectedTypes.length == 1 || (isFunctionalType || detectConjunct) && expectedTypes.length > 0) {
            if (typeByExpression != null && Arrays.stream(expectedTypes).anyMatch(typeInfo -> typeByExpression.isAssignableFrom(typeInfo.getType()))) {
                return type2;
            }
            type2 = expectedTypes[0].getType();
            if (!type2.equalsToText("java.lang.Object")) {
                return type2;
            }
        }
        return detectConjunct ? type2 : null;
    }

    public static PsiType getTypeByExpression(PsiExpression expr) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory();
        PsiType type2 = RefactoringUtil.getTypeByExpression(expr, factory);
        if (LambdaUtil.notInferredType((PsiType)type2)) {
            type2 = factory.createTypeByFQClassName("java.lang.Object", expr.getResolveScope());
        }
        return type2;
    }

    private static PsiType getTypeByExpression(PsiExpression expr, PsiElementFactory factory) {
        Object type2 = RefactoringChangeUtil.getTypeByExpression(expr);
        if (PsiType.NULL.equals(type2)) {
            ExpectedTypeInfo[] infos = ExpectedTypesProvider.getExpectedTypes(expr, false);
            type2 = infos.length == 1 ? infos[0].getType() : factory.createTypeByFQClassName("java.lang.Object", expr.getResolveScope());
        }
        return type2;
    }

    public static boolean isAssignmentLHS(@NotNull PsiElement element) {
        if (element == null) {
            RefactoringUtil.$$$reportNull$$$0(1);
        }
        return element instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element));
    }

    private static void removeFinalParameters(PsiMethod method) throws IncorrectOperationException {
        PsiParameter[] params;
        PsiParameterList paramList = method.getParameterList();
        for (PsiParameter param : params = paramList.getParameters()) {
            if (!param.hasModifierProperty("final")) continue;
            PsiUtil.setModifierProperty((PsiModifierListOwner)param, (String)"final", (boolean)false);
        }
    }

    public static PsiElement getAnchorElementForMultipleExpressions(@NotNull PsiExpression[] occurrences, PsiElement scope) {
        PsiSwitchStatement switchStatement;
        if (occurrences == null) {
            RefactoringUtil.$$$reportNull$$$0(2);
        }
        PsiElement anchor = null;
        for (PsiExpression occurrence : occurrences) {
            PsiElement firstAnchor;
            if (scope != null && !PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)occurrence, (boolean)false)) continue;
            PsiElement anchor1 = RefactoringUtil.getParentExpressionAnchorElement((PsiElement)occurrence);
            if (anchor1 == null) {
                if (!occurrence.isPhysical()) continue;
                return null;
            }
            if (anchor == null) {
                anchor = anchor1;
                continue;
            }
            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)anchor, (PsiElement)anchor1);
            if (commonParent == null || anchor.getTextRange() == null || anchor1.getTextRange() == null) {
                return null;
            }
            PsiElement psiElement = firstAnchor = anchor.getTextRange().getStartOffset() < anchor1.getTextRange().getStartOffset() ? anchor : anchor1;
            if (commonParent.equals(firstAnchor)) {
                anchor = firstAnchor;
                continue;
            }
            if (commonParent instanceof PsiStatement) {
                anchor = commonParent;
                continue;
            }
            PsiElement parent = firstAnchor;
            while (!parent.getParent().equals(commonParent)) {
                parent = parent.getParent();
            }
            PsiElement newAnchor = RefactoringUtil.getParentExpressionAnchorElement(parent);
            anchor = newAnchor != null ? newAnchor : parent;
        }
        if (anchor == null) {
            return null;
        }
        if (occurrences.length > 1 && anchor.getParent().getParent() instanceof PsiSwitchStatement && (switchStatement = (PsiSwitchStatement)anchor.getParent().getParent()).getBody().equals(anchor.getParent())) {
            int startOffset = occurrences[0].getTextRange().getStartOffset();
            int endOffset = occurrences[occurrences.length - 1].getTextRange().getEndOffset();
            PsiStatement[] statements = switchStatement.getBody().getStatements();
            boolean isInDifferentCases = false;
            for (PsiStatement statement : statements) {
                int caseOffset;
                if (!(statement instanceof PsiSwitchLabelStatement) || startOffset >= (caseOffset = statement.getTextRange().getStartOffset()) || caseOffset >= endOffset) continue;
                isInDifferentCases = true;
                break;
            }
            if (isInDifferentCases) {
                anchor = switchStatement;
            }
        }
        return anchor;
    }

    public static boolean isMethodUsage(PsiElement element) {
        if (element instanceof PsiEnumConstant) {
            return JavaLanguage.INSTANCE.equals(element.getLanguage());
        }
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiCall) {
            return true;
        }
        if (parent instanceof PsiAnonymousClass) {
            return element.equals(((PsiAnonymousClass)parent).getBaseClassReference());
        }
        return false;
    }

    @Nullable
    public static PsiExpressionList getArgumentListByMethodReference(PsiElement ref) {
        if (ref instanceof PsiCall) {
            return ((PsiCall)ref).getArgumentList();
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiCall) {
            return ((PsiCall)parent).getArgumentList();
        }
        if (parent instanceof PsiAnonymousClass) {
            return ((PsiNewExpression)parent.getParent()).getArgumentList();
        }
        LOG.assertTrue(false);
        return null;
    }

    public static PsiCall getCallExpressionByMethodReference(PsiElement ref) {
        if (ref instanceof PsiCall) {
            return (PsiCall)ref;
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)parent;
        }
        if (parent instanceof PsiNewExpression) {
            return (PsiNewExpression)parent;
        }
        if (parent instanceof PsiAnonymousClass) {
            return (PsiNewExpression)parent.getParent();
        }
        LOG.assertTrue(false);
        return null;
    }

    public static List<RangeHighlighter> highlightAllOccurrences(Project project, PsiElement[] occurrences, Editor editor) {
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        if (occurrences.length > 1) {
            for (PsiElement occurrence : occurrences) {
                RangeMarker rangeMarker = (RangeMarker)occurrence.getUserData(ElementToWorkOn.TEXT_RANGE);
                if (rangeMarker != null && rangeMarker.isValid()) {
                    highlightManager.addRangeHighlight(editor, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), attributes, true, highlighters);
                    continue;
                }
                TextRange textRange = occurrence.getTextRange();
                highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, true, highlighters);
            }
        }
        return highlighters;
    }

    public static String createTempVar(PsiExpression expr, PsiElement context, boolean declareFinal) throws IncorrectOperationException {
        PsiExpression expr1;
        PsiElement anchorStatement = RefactoringUtil.getParentStatement(context, true);
        LOG.assertTrue(anchorStatement != null && anchorStatement.getParent() != null);
        Project project = expr.getProject();
        String[] suggestedNames = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, null, (PsiExpression)expr, null).names;
        String prefix = suggestedNames.length > 0 ? suggestedNames[0] : "var";
        String id = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(prefix, context, true);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory();
        if (expr instanceof PsiParenthesizedExpression && (expr1 = ((PsiParenthesizedExpression)expr).getExpression()) != null) {
            expr = expr1;
        }
        PsiDeclarationStatement decl = factory.createVariableDeclarationStatement(id, expr.getType(), expr);
        if (declareFinal) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiLocalVariable)decl.getDeclaredElements()[0]), (String)"final", (boolean)true);
        }
        anchorStatement.getParent().addBefore((PsiElement)decl, anchorStatement);
        return id;
    }

    public static int verifySafeCopyExpression(PsiElement expr) {
        return RefactoringUtil.verifySafeCopyExpressionSubElement(expr);
    }

    private static int verifySafeCopyExpressionSubElement(PsiElement element) {
        PsiElement[] children;
        int result = 0;
        if (element == null) {
            return result;
        }
        if (element instanceof PsiThisExpression || element instanceof PsiSuperExpression || element instanceof PsiIdentifier) {
            return 0;
        }
        if (element instanceof PsiMethodCallExpression) {
            result = 1;
        }
        if (element instanceof PsiNewExpression) {
            return 2;
        }
        if (element instanceof PsiAssignmentExpression) {
            return 2;
        }
        if (PsiUtil.isIncrementDecrementOperation((PsiElement)element)) {
            return 2;
        }
        for (PsiElement child : children = element.getChildren()) {
            int childResult = RefactoringUtil.verifySafeCopyExpressionSubElement(child);
            result = Math.max(result, childResult);
        }
        return result;
    }

    @Contract(value="null, _ -> null")
    public static PsiExpression convertInitializerToNormalExpression(PsiExpression expression2, PsiType forcedReturnType) throws IncorrectOperationException {
        if (expression2 instanceof PsiArrayInitializerExpression && (forcedReturnType == null || forcedReturnType instanceof PsiArrayType)) {
            return RefactoringUtil.createNewExpressionFromArrayInitializer((PsiArrayInitializerExpression)expression2, forcedReturnType);
        }
        return expression2;
    }

    public static PsiExpression createNewExpressionFromArrayInitializer(PsiArrayInitializerExpression initializer, PsiType forcedType) throws IncorrectOperationException {
        PsiType initializerType = null;
        if (initializer != null) {
            initializerType = forcedType != null ? forcedType : RefactoringUtil.getTypeByExpression((PsiExpression)initializer);
        }
        if (initializerType == null) {
            return initializer;
        }
        LOG.assertTrue(initializerType instanceof PsiArrayType);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)initializer.getProject()).getElementFactory();
        PsiNewExpression result = (PsiNewExpression)factory.createExpressionFromText("new " + initializerType.getPresentableText() + "{}", null);
        result = (PsiNewExpression)CodeStyleManager.getInstance((Project)initializer.getProject()).reformat((PsiElement)result);
        PsiArrayInitializerExpression arrayInitializer = result.getArrayInitializer();
        LOG.assertTrue(arrayInitializer != null);
        arrayInitializer.replace((PsiElement)initializer);
        return result;
    }

    public static void makeMethodAbstract(@NotNull PsiClass targetClass, @NotNull PsiMethod method) throws IncorrectOperationException {
        if (targetClass == null) {
            RefactoringUtil.$$$reportNull$$$0(3);
        }
        if (method == null) {
            RefactoringUtil.$$$reportNull$$$0(4);
        }
        if (!method.hasModifierProperty("default")) {
            PsiCodeBlock body2 = method.getBody();
            if (body2 != null) {
                body2.delete();
            }
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"abstract", (boolean)true);
        }
        if (!targetClass.isInterface()) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)targetClass, (String)"abstract", (boolean)true);
            RefactoringUtil.prepareForAbstract(method);
        } else {
            RefactoringUtil.prepareForInterface(method);
        }
    }

    public static void makeMethodDefault(@NotNull PsiMethod method) throws IncorrectOperationException {
        if (method == null) {
            RefactoringUtil.$$$reportNull$$$0(5);
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"default", (!method.hasModifierProperty("static") ? 1 : 0) != 0);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"abstract", (boolean)false);
        RefactoringUtil.prepareForInterface(method);
    }

    private static void prepareForInterface(PsiMethod method) {
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)false);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"private", (boolean)false);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"protected", (boolean)false);
        RefactoringUtil.prepareForAbstract(method);
    }

    private static void prepareForAbstract(PsiMethod method) {
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"final", (boolean)false);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"synchronized", (boolean)false);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"native", (boolean)false);
        RefactoringUtil.removeFinalParameters(method);
    }

    public static boolean isInsideAnonymousOrLocal(PsiElement element, PsiElement upTo) {
        for (PsiElement current = element; current != null && current != upTo; current = current.getParent()) {
            if (current instanceof PsiAnonymousClass) {
                return true;
            }
            if (!(current instanceof PsiClass) || !(current.getParent() instanceof PsiDeclarationStatement)) continue;
            return true;
        }
        return false;
    }

    public static PsiExpression unparenthesizeExpression(PsiExpression expression2) {
        while (expression2 instanceof PsiParenthesizedExpression) {
            PsiExpression innerExpression = ((PsiParenthesizedExpression)expression2).getExpression();
            if (innerExpression == null) {
                return expression2;
            }
            expression2 = innerExpression;
        }
        return expression2;
    }

    public static PsiExpression outermostParenthesizedExpression(PsiExpression expression2) {
        while (expression2.getParent() instanceof PsiParenthesizedExpression) {
            expression2 = (PsiParenthesizedExpression)expression2.getParent();
        }
        return expression2;
    }

    public static String getNewInnerClassName(PsiClass aClass, String oldInnerClassName, String newName) {
        String className = aClass.getName();
        if (className == null || !oldInnerClassName.endsWith(className)) {
            return newName;
        }
        StringBuilder buffer = new StringBuilder(oldInnerClassName);
        buffer.replace(buffer.length() - className.length(), buffer.length(), newName);
        return buffer.toString();
    }

    public static void visitImplicitSuperConstructorUsages(PsiClass subClass, ImplicitConstructorUsageVisitor implicitConstructorUsageVistor, PsiClass superClass) {
        PsiMethod baseDefaultConstructor = RefactoringUtil.findDefaultConstructor(superClass);
        PsiMethod[] constructors = subClass.getConstructors();
        if (constructors.length > 0) {
            for (PsiMethod constructor : constructors) {
                PsiStatement[] statements;
                PsiCodeBlock body2 = constructor.getBody();
                if (body2 == null || (statements = body2.getStatements()).length >= 1 && JavaHighlightUtil.isSuperOrThisCall(statements[0], true, true)) continue;
                implicitConstructorUsageVistor.visitConstructor(constructor, baseDefaultConstructor);
            }
        } else {
            implicitConstructorUsageVistor.visitClassWithoutConstructors(subClass);
        }
    }

    private static PsiMethod findDefaultConstructor(PsiClass aClass) {
        PsiMethod[] constructors;
        for (PsiMethod constructor : constructors = aClass.getConstructors()) {
            if (!constructor.getParameterList().isEmpty()) continue;
            return constructor;
        }
        return null;
    }

    public static void replaceMovedMemberTypeParameters(PsiElement member, Iterable<PsiTypeParameter> parametersIterable, PsiSubstitutor substitutor, PsiElementFactory factory) {
        LinkedHashMap<Object, Object> replacement = new LinkedHashMap<Object, Object>();
        for (PsiTypeParameter parameter2 : parametersIterable) {
            PsiType substitutedType = substitutor.substitute(parameter2);
            PsiType erasedType = substitutedType == null ? TypeConversionUtil.erasure((PsiType)factory.createType((PsiClass)parameter2)) : substitutedType;
            for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter2, (SearchScope)new LocalSearchScope(member))) {
                PsiElement element = reference.getElement();
                PsiElement parent = element.getParent();
                if (parent instanceof PsiTypeElement) {
                    if (substitutedType == null) {
                        PsiJavaCodeReferenceElement codeReferenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)parent, PsiJavaCodeReferenceElement.class);
                        if (codeReferenceElement != null) {
                            PsiJavaCodeReferenceElement copy = (PsiJavaCodeReferenceElement)codeReferenceElement.copy();
                            PsiReferenceParameterList parameterList = copy.getParameterList();
                            if (parameterList != null) {
                                parameterList.delete();
                            }
                            replacement.put(codeReferenceElement, copy);
                            continue;
                        }
                        PsiTypeElement topPsiTypeElement = (PsiTypeElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)parent, PsiTypeElement.class);
                        if (topPsiTypeElement == null) {
                            topPsiTypeElement = (PsiTypeElement)parent;
                        }
                        replacement.put(topPsiTypeElement, factory.createTypeElement(TypeConversionUtil.erasure((PsiType)topPsiTypeElement.getType())));
                        continue;
                    }
                    replacement.put(parent, factory.createTypeElement(substitutedType));
                    continue;
                }
                if (!(element instanceof PsiJavaCodeReferenceElement) || !(erasedType instanceof PsiClassType)) continue;
                replacement.put(element, factory.createReferenceElementByType((PsiClassType)erasedType));
            }
        }
        for (PsiElement element : replacement.keySet()) {
            if (!element.isValid()) continue;
            element.replace((PsiElement)replacement.get(element));
        }
    }

    public static void renameConflictingTypeParameters(PsiMember memberCopy, PsiClass targetClass) {
        if (memberCopy instanceof PsiTypeParameterListOwner && !memberCopy.hasModifierProperty("static")) {
            UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
            PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)targetClass).forEach(param -> {
                String paramName = param.getName();
                if (paramName != null) {
                    nameGenerator.addExistingName(paramName);
                }
            });
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)memberCopy.getProject());
            for (PsiTypeParameter parameter2 : ((PsiTypeParameterListOwner)memberCopy).getTypeParameters()) {
                String parameterName = parameter2.getName();
                if (parameterName == null || nameGenerator.isUnique(parameterName)) continue;
                substitutor = substitutor.put(parameter2, PsiSubstitutor.EMPTY.substitute(factory.createTypeParameter(nameGenerator.generateUniqueName(parameterName), PsiClassType.EMPTY_ARRAY)));
            }
            if (!PsiSubstitutor.EMPTY.equals(substitutor)) {
                RefactoringUtil.replaceMovedMemberTypeParameters((PsiElement)memberCopy, PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)((PsiTypeParameterListOwner)memberCopy)), substitutor, factory);
                for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
                    ((PsiTypeParameter)entry.getKey()).setName(((PsiType)entry.getValue()).getCanonicalText());
                }
            }
        }
    }

    @Nullable
    public static PsiMethod getChainedConstructor(PsiMethod constructor) {
        PsiMethodCallExpression methodCallExpression;
        PsiReferenceExpression methodExpr;
        PsiExpression expression2;
        PsiCodeBlock constructorBody = constructor.getBody();
        if (constructorBody == null) {
            return null;
        }
        PsiStatement[] statements = constructorBody.getStatements();
        if (statements.length == 1 && statements[0] instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression && "this".equals((methodExpr = (methodCallExpression = (PsiMethodCallExpression)expression2).getMethodExpression()).getReferenceName())) {
            return (PsiMethod)methodExpr.resolve();
        }
        return null;
    }

    public static boolean isInMovedElement(PsiElement element, Set<PsiMember> membersToMove) {
        for (PsiMember member : membersToMove) {
            if (!PsiTreeUtil.isAncestor((PsiElement)member, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean inImportStatement(PsiReference ref, PsiElement element) {
        PsiImportList importList;
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class) != null) {
            return true;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile instanceof PsiJavaFile && (importList = ((PsiJavaFile)containingFile).getImportList()) != null) {
            TextRange refRange = ref.getRangeInElement().shiftRight(element.getTextRange().getStartOffset());
            for (PsiImportStatementBase importStatementBase : importList.getAllImportStatements()) {
                TextRange textRange = importStatementBase.getTextRange();
                if (!textRange.contains(refRange)) continue;
                return true;
            }
        }
        return false;
    }

    public static PsiStatement putStatementInLoopBody(PsiStatement declaration2, PsiElement container, PsiElement finalAnchorStatement) throws IncorrectOperationException {
        return RefactoringUtil.putStatementInLoopBody(declaration2, container, finalAnchorStatement, false);
    }

    public static PsiStatement putStatementInLoopBody(PsiStatement declaration2, PsiElement container, PsiElement finalAnchorStatement, boolean replaceBody) throws IncorrectOperationException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)container.getProject()).getElementFactory();
        if (RefactoringUtil.isLoopOrIf(container)) {
            PsiElement pprev;
            PsiStatement loopBody = RefactoringUtil.getLoopBody(container, finalAnchorStatement);
            PsiStatement loopBodyCopy = loopBody != null ? (PsiStatement)loopBody.copy() : null;
            PsiBlockStatement blockStatement = (PsiBlockStatement)elementFactory.createStatementFromText("{}", null);
            blockStatement = (PsiBlockStatement)CodeStyleManager.getInstance((Project)container.getProject()).reformat((PsiElement)blockStatement);
            PsiElement prevSibling = loopBody.getPrevSibling();
            if (!(!(prevSibling instanceof PsiWhiteSpace) || (pprev = prevSibling.getPrevSibling()) instanceof PsiComment && ((PsiComment)pprev).getTokenType().equals(JavaTokenType.END_OF_LINE_COMMENT))) {
                prevSibling.delete();
            }
            blockStatement = (PsiBlockStatement)loopBody.replace((PsiElement)blockStatement);
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            declaration2 = (PsiStatement)codeBlock.add((PsiElement)declaration2);
            JavaCodeStyleManager.getInstance((Project)declaration2.getProject()).shortenClassReferences((PsiElement)declaration2);
            if (loopBodyCopy != null && !replaceBody) {
                codeBlock.add((PsiElement)loopBodyCopy);
            }
        } else if (container instanceof PsiLambdaExpression) {
            PsiLambdaExpression copy;
            PsiStatement lastBodyStatement;
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)container;
            PsiElement invalidBody = lambdaExpression.getBody();
            if (invalidBody == null) {
                return declaration2;
            }
            String lambdaParamListWithArrowAndComments = lambdaExpression.getText().substring(0, (declaration2.isPhysical() ? declaration2 : invalidBody).getStartOffsetInParent());
            PsiLambdaExpression expressionFromText = (PsiLambdaExpression)elementFactory.createExpressionFromText(lambdaParamListWithArrowAndComments + "{}", lambdaExpression.getParent());
            PsiCodeBlock newBody = (PsiCodeBlock)expressionFromText.getBody();
            LOG.assertTrue(newBody != null);
            newBody.add((PsiElement)declaration2);
            PsiElement lambdaExpressionBody = lambdaExpression.getBody();
            LOG.assertTrue(lambdaExpressionBody != null);
            if (PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression))) {
                if (replaceBody) {
                    lastBodyStatement = null;
                } else {
                    lastBodyStatement = elementFactory.createStatementFromText("a;", (PsiElement)lambdaExpression);
                    ((PsiExpressionStatement)lastBodyStatement).getExpression().replace(lambdaExpressionBody);
                }
            } else {
                lastBodyStatement = elementFactory.createStatementFromText("return a;", (PsiElement)lambdaExpression);
                PsiExpression returnValue = ((PsiReturnStatement)lastBodyStatement).getReturnValue();
                LOG.assertTrue(returnValue != null);
                returnValue.replace(lambdaExpressionBody);
            }
            if (lastBodyStatement != null) {
                newBody.add((PsiElement)lastBodyStatement);
            }
            LOG.assertTrue((newBody = (PsiCodeBlock)(copy = (PsiLambdaExpression)lambdaExpression.replace((PsiElement)expressionFromText)).getBody()) != null);
            declaration2 = newBody.getStatements()[0];
            declaration2 = (PsiStatement)JavaCodeStyleManager.getInstance((Project)declaration2.getProject()).shortenClassReferences((PsiElement)declaration2);
        }
        return declaration2;
    }

    @Nullable
    private static PsiStatement getLoopBody(PsiElement container, PsiElement anchorStatement) {
        if (container instanceof PsiLoopStatement) {
            return ((PsiLoopStatement)container).getBody();
        }
        if (container instanceof PsiIfStatement) {
            PsiStatement thenBranch = ((PsiIfStatement)container).getThenBranch();
            if (thenBranch != null && PsiTreeUtil.isAncestor((PsiElement)thenBranch, (PsiElement)anchorStatement, (boolean)false)) {
                return thenBranch;
            }
            PsiStatement elseBranch = ((PsiIfStatement)container).getElseBranch();
            if (elseBranch != null && PsiTreeUtil.isAncestor((PsiElement)elseBranch, (PsiElement)anchorStatement, (boolean)false)) {
                return elseBranch;
            }
            LOG.assertTrue(false);
        }
        LOG.assertTrue(false);
        return null;
    }

    public static boolean isLoopOrIf(PsiElement element) {
        return element instanceof PsiLoopStatement || element instanceof PsiIfStatement;
    }

    public static PsiCodeBlock expandExpressionLambdaToCodeBlock(@NotNull PsiLambdaExpression lambdaExpression) {
        PsiElement body2;
        if (lambdaExpression == null) {
            RefactoringUtil.$$$reportNull$$$0(6);
        }
        if (!((body2 = lambdaExpression.getBody()) instanceof PsiExpression)) {
            return (PsiCodeBlock)body2;
        }
        String newLambdaText = "{";
        if (!PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression))) {
            newLambdaText = newLambdaText + "return ";
        }
        newLambdaText = newLambdaText + "a;}";
        Project project = lambdaExpression.getProject();
        PsiCodeBlock codeBlock = JavaPsiFacade.getElementFactory((Project)project).createCodeBlockFromText(newLambdaText, (PsiElement)lambdaExpression);
        PsiStatement statement = codeBlock.getStatements()[0];
        if (statement instanceof PsiReturnStatement) {
            PsiExpression value2 = ((PsiReturnStatement)statement).getReturnValue();
            LOG.assertTrue(value2 != null);
            value2.replace(body2);
        } else if (statement instanceof PsiExpressionStatement) {
            ((PsiExpressionStatement)statement).getExpression().replace(body2);
        }
        return (PsiCodeBlock)CodeStyleManager.getInstance((Project)project).reformat(body2.replace((PsiElement)codeBlock));
    }

    @Nullable
    public static <T extends PsiExpression> T ensureCodeBlock(@NotNull T expression2) {
        PsiElement newParent;
        PsiElement parent;
        if (expression2 == null) {
            RefactoringUtil.$$$reportNull$$$0(7);
        }
        if ((parent = RefactoringUtil.getParentStatement(expression2, false)) == null && (parent = PsiTreeUtil.getParentOfType(expression2, PsiField.class, (boolean)true, (Class[])new Class[]{PsiClass.class})) == null) {
            return null;
        }
        PsiElement grandParent = parent.getParent();
        if (!(!(parent instanceof PsiStatement) || !(grandParent instanceof PsiCodeBlock) || parent instanceof PsiForStatement && PsiTreeUtil.isAncestor((PsiElement)((PsiForStatement)parent).getInitialization(), expression2, (boolean)true) && RefactoringUtil.hasNameCollision((PsiElement)((PsiForStatement)parent).getInitialization(), grandParent))) {
            return expression2;
        }
        Object marker = new Object();
        PsiTreeUtil.mark(expression2, (Object)marker);
        PsiElement copy = parent.copy();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
        if (parent instanceof PsiExpression) {
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)grandParent;
            String replacement = PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda2)) ? "{a;}" : "{return a;}";
            PsiElement block = parent.replace((PsiElement)factory.createCodeBlockFromText(replacement, (PsiElement)lambda2));
            newParent = LambdaUtil.extractSingleExpressionFromBody((PsiElement)block).replace(copy);
        } else if (parent instanceof PsiField) {
            PsiField field = (PsiField)parent;
            PsiClassInitializer initializer = (PsiClassInitializer)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)field), PsiClassInitializer.class);
            boolean isStatic = field.hasModifierProperty("static");
            if (initializer == null || initializer.hasModifierProperty("static") != isStatic) {
                initializer = factory.createClassInitializer();
                if (isStatic) {
                    Objects.requireNonNull(initializer.getModifierList()).setModifierProperty("static", true);
                }
                initializer = (PsiClassInitializer)field.getParent().addAfter((PsiElement)initializer, (PsiElement)field);
            }
            PsiCodeBlock body2 = initializer.getBody();
            PsiElement anchor = PsiTreeUtil.skipWhitespacesForward((PsiElement)body2.getFirstChild());
            assert (anchor != null);
            anchor = anchor.getPrevSibling();
            assert (anchor != null);
            PsiExpressionStatement assignment = (PsiExpressionStatement)factory.createStatementFromText(field.getName() + "=null;", (PsiElement)initializer);
            assignment = (PsiExpressionStatement)body2.addAfter((PsiElement)assignment, anchor);
            PsiExpression fieldInitializer = ((PsiField)copy).getInitializer();
            if (fieldInitializer instanceof PsiArrayInitializerExpression) {
                fieldInitializer = RefactoringUtil.createNewExpressionFromArrayInitializer((PsiArrayInitializerExpression)fieldInitializer, field.getType());
            }
            PsiExpression rExpression = ((PsiAssignmentExpression)assignment.getExpression()).getRExpression();
            assert (fieldInitializer != null);
            assert (rExpression != null);
            rExpression.replace((PsiElement)fieldInitializer);
            Objects.requireNonNull(field.getInitializer()).delete();
            newParent = assignment;
        } else {
            PsiBlockStatement blockStatement = (PsiBlockStatement)parent.replace((PsiElement)factory.createStatementFromText("{}", parent));
            newParent = blockStatement.getCodeBlock().add(copy);
        }
        return (T)((PsiExpression)PsiTreeUtil.releaseMark((PsiElement)newParent, (Object)marker));
    }

    private static boolean hasNameCollision(PsiElement declaration2, PsiElement context) {
        if (declaration2 instanceof PsiDeclarationStatement) {
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper();
            return StreamEx.of((Object[])((PsiDeclarationStatement)declaration2).getDeclaredElements()).select(PsiLocalVariable.class).map(PomNamedTarget::getName).nonNull().anyMatch(name -> helper.resolveReferencedVariable(name, context) != null);
        }
        return false;
    }

    public static <T> Set<T> transitiveClosure(Graph<T> graph, Condition<T> initialRelation) {
        boolean anyChanged;
        HashSet<T> result = new HashSet<T>();
        Set<T> vertices = graph.getVertices();
        do {
            anyChanged = false;
            block1: for (T currentVertex : vertices) {
                if (result.contains(currentVertex)) continue;
                if (!initialRelation.value(currentVertex)) {
                    Set<T> targets = graph.getTargets(currentVertex);
                    for (T currentTarget : targets) {
                        if (!result.contains(currentTarget) && !initialRelation.value(currentTarget)) continue;
                        result.add(currentVertex);
                        anyChanged = true;
                        continue block1;
                    }
                    continue;
                }
                result.add(currentVertex);
            }
        } while (anyChanged);
        return result;
    }

    public static boolean equivalentTypes(PsiType t1, PsiType t2, PsiManager manager) {
        while (t1 instanceof PsiArrayType) {
            if (!(t2 instanceof PsiArrayType)) {
                return false;
            }
            t1 = ((PsiArrayType)t1).getComponentType();
            t2 = ((PsiArrayType)t2).getComponentType();
        }
        if (t1 instanceof PsiPrimitiveType) {
            return t2 instanceof PsiPrimitiveType && t1.equals(t2);
        }
        return manager.areElementsEquivalent((PsiElement)PsiUtil.resolveClassInType((PsiType)t1), (PsiElement)PsiUtil.resolveClassInType((PsiType)t2));
    }

    public static List<PsiVariable> collectReferencedVariables(PsiElement scope) {
        final ArrayList<PsiVariable> result = new ArrayList<PsiVariable>();
        scope.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                PsiExpression qualifier;
                PsiElement element = expression2.resolve();
                if (element instanceof PsiVariable) {
                    result.add((PsiVariable)element);
                }
                if ((qualifier = expression2.getQualifierExpression()) != null) {
                    qualifier.accept((PsiElementVisitor)this);
                }
            }
        });
        return result;
    }

    public static boolean isModifiedInScope(PsiVariable variable, PsiElement scope) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope(scope), (boolean)false)) {
            if (!RefactoringUtil.isAssignmentLHS(reference.getElement())) continue;
            return true;
        }
        return false;
    }

    private static String getNameOfReferencedParameter(PsiDocTag tag) {
        LOG.assertTrue("param".equals(tag.getName()));
        PsiElement[] dataElements = tag.getDataElements();
        if (dataElements.length < 1) {
            return null;
        }
        return dataElements[0].getText();
    }

    public static void fixJavadocsForParams(PsiMethod method, Set<PsiParameter> newParameters) throws IncorrectOperationException {
        RefactoringUtil.fixJavadocsForParams(method, newParameters, (Condition<Pair<PsiParameter, String>>)Conditions.alwaysFalse());
    }

    public static void fixJavadocsForParams(PsiMethod method, Set<PsiParameter> newParameters, Condition<Pair<PsiParameter, String>> eqCondition) throws IncorrectOperationException {
        RefactoringUtil.fixJavadocsForParams(method, newParameters, eqCondition, (Condition<String>)Conditions.alwaysTrue());
    }

    /*
     * WARNING - void declaration
     */
    public static void fixJavadocsForParams(PsiMethod method, Set<PsiParameter> newParameters, Condition<Pair<PsiParameter, String>> eqCondition, Condition<String> matchedToOldParam) throws IncorrectOperationException {
        void var12_21;
        PsiDocComment docComment = method.getDocComment();
        if (docComment == null) {
            return;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiDocTag[] paramTags = docComment.findTagsByName("param");
        if (parameters2.length > 0 && newParameters.size() < parameters2.length && paramTags.length == 0) {
            return;
        }
        HashMap<PsiParameter, PsiDocTag> tagForParam = new HashMap<PsiParameter, PsiDocTag>();
        for (PsiParameter parameter2 : parameters2) {
            boolean bl = false;
            for (PsiDocTag paramTag : paramTags) {
                if (!parameter2.getName().equals(RefactoringUtil.getNameOfReferencedParameter(paramTag))) continue;
                tagForParam.put(parameter2, paramTag);
                bl = true;
                break;
            }
            if (!bl) {
                for (PsiDocTag paramTag : paramTags) {
                    String paramName = RefactoringUtil.getNameOfReferencedParameter(paramTag);
                    if (!eqCondition.value((Object)Pair.create((Object)parameter2, (Object)paramName))) continue;
                    tagForParam.put(parameter2, paramTag);
                    bl = true;
                    break;
                }
            }
            if (bl || newParameters.contains(parameter2)) continue;
            tagForParam.put(parameter2, null);
        }
        ArrayList<PsiDocTag> newTags = new ArrayList<PsiDocTag>();
        for (PsiDocTag psiDocTag : paramTags) {
            String paramName = RefactoringUtil.getNameOfReferencedParameter(psiDocTag);
            if (tagForParam.containsValue(psiDocTag) || matchedToOldParam.value((Object)paramName)) continue;
            newTags.add((PsiDocTag)psiDocTag.copy());
        }
        for (PsiDocTag psiDocTag : parameters2) {
            if (tagForParam.containsKey(psiDocTag)) {
                PsiDocTag psiDocTag2 = (PsiDocTag)tagForParam.get(psiDocTag);
                if (psiDocTag2 == null) continue;
                PsiDocTag copy = (PsiDocTag)psiDocTag2.copy();
                PsiDocTagValue valueElement = copy.getValueElement();
                if (valueElement != null) {
                    valueElement.replace((PsiElement)RefactoringUtil.createParamTag((PsiParameter)psiDocTag).getValueElement());
                }
                newTags.add(copy);
                continue;
            }
            newTags.add(RefactoringUtil.createParamTag((PsiParameter)psiDocTag));
        }
        PsiElement anchor = paramTags.length > 0 ? paramTags[0].getPrevSibling() : null;
        PsiDocTag[] psiDocTagArray = paramTags;
        int parameter2 = psiDocTagArray.length;
        boolean bl = false;
        while (var12_21 < parameter2) {
            PsiDocTag paramTag = psiDocTagArray[var12_21];
            paramTag.delete();
            ++var12_21;
        }
        for (PsiDocTag psiDocTag : newTags) {
            anchor = anchor != null && anchor.isValid() ? docComment.addAfter((PsiElement)psiDocTag, anchor) : docComment.add((PsiElement)psiDocTag);
        }
    }

    private static PsiDocTag createParamTag(PsiParameter parameter2) {
        return JavaPsiFacade.getInstance((Project)parameter2.getProject()).getElementFactory().createParamTag(parameter2.getName(), "");
    }

    public static PsiDirectory createPackageDirectoryInSourceRoot(PackageWrapper aPackage, VirtualFile sourceRoot) throws IncorrectOperationException {
        PsiDirectory[] directories;
        for (PsiDirectory directory : directories = aPackage.getDirectories()) {
            if (!VfsUtil.isAncestor((VirtualFile)sourceRoot, (VirtualFile)directory.getVirtualFile(), (boolean)false)) continue;
            return directory;
        }
        String qNameToCreate = RefactoringUtil.qNameToCreateInSourceRoot(aPackage, sourceRoot);
        String[] shortNames = qNameToCreate.split("\\.");
        PsiDirectory current = aPackage.getManager().findDirectory(sourceRoot);
        LOG.assertTrue(current != null);
        for (String shortName : shortNames) {
            PsiDirectory subdirectory = current.findSubdirectory(shortName);
            if (subdirectory == null) {
                subdirectory = current.createSubdirectory(shortName);
            }
            current = subdirectory;
        }
        return current;
    }

    public static String qNameToCreateInSourceRoot(PackageWrapper aPackage, VirtualFile sourceRoot) throws IncorrectOperationException {
        String targetQName = aPackage.getQualifiedName();
        String sourceRootPackage = ProjectRootManager.getInstance((Project)aPackage.getManager().getProject()).getFileIndex().getPackageNameByDirectory(sourceRoot);
        if (!RefactoringUtil.canCreateInSourceRoot(sourceRootPackage, targetQName)) {
            throw new IncorrectOperationException("Cannot create package '" + targetQName + "' in source folder " + sourceRoot.getPresentableUrl());
        }
        String result = targetQName.substring(sourceRootPackage.length());
        if (StringUtil.startsWithChar((CharSequence)result, (char)'.')) {
            result = result.substring(1);
        }
        return result;
    }

    public static boolean canCreateInSourceRoot(String sourceRootPackage, String targetQName) {
        if (sourceRootPackage == null || !targetQName.startsWith(sourceRootPackage)) {
            return false;
        }
        if (sourceRootPackage.length() == 0 || targetQName.length() == sourceRootPackage.length()) {
            return true;
        }
        return targetQName.charAt(sourceRootPackage.length()) == '.';
    }

    @Nullable
    public static PsiDirectory findPackageDirectoryInSourceRoot(PackageWrapper aPackage, VirtualFile sourceRoot) {
        String qNameToCreate;
        PsiDirectory[] directories;
        for (PsiDirectory directory : directories = aPackage.getDirectories()) {
            if (!VfsUtil.isAncestor((VirtualFile)sourceRoot, (VirtualFile)directory.getVirtualFile(), (boolean)false)) continue;
            return directory;
        }
        try {
            qNameToCreate = RefactoringUtil.qNameToCreateInSourceRoot(aPackage, sourceRoot);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        String[] shortNames = qNameToCreate.split("\\.");
        PsiDirectory current = aPackage.getManager().findDirectory(sourceRoot);
        LOG.assertTrue(current != null);
        for (String shortName : shortNames) {
            PsiDirectory subdirectory = current.findSubdirectory(shortName);
            if (subdirectory == null) {
                return null;
            }
            current = subdirectory;
        }
        return current;
    }

    @Nullable
    public static PsiTypeParameterList createTypeParameterListWithUsedTypeParameters(PsiElement ... elements) {
        if (elements == null) {
            RefactoringUtil.$$$reportNull$$$0(8);
        }
        return RefactoringUtil.createTypeParameterListWithUsedTypeParameters(null, elements);
    }

    @Nullable
    public static PsiTypeParameterList createTypeParameterListWithUsedTypeParameters(@Nullable PsiTypeParameterList fromList, PsiElement ... elements) {
        if (elements == null) {
            RefactoringUtil.$$$reportNull$$$0(9);
        }
        return RefactoringUtil.createTypeParameterListWithUsedTypeParameters(fromList, (Condition<PsiTypeParameter>)Conditions.alwaysTrue(), elements);
    }

    @Nullable
    public static PsiTypeParameterList createTypeParameterListWithUsedTypeParameters(@Nullable PsiTypeParameterList fromList, Condition<PsiTypeParameter> filter, PsiElement ... elements) {
        if (elements == null) {
            RefactoringUtil.$$$reportNull$$$0(10);
        }
        if (elements.length == 0) {
            return null;
        }
        HashSet<PsiTypeParameter> used = new HashSet<PsiTypeParameter>();
        for (PsiElement element : elements) {
            if (element == null) continue;
            RefactoringUtil.collectTypeParameters(used, element, filter);
        }
        RefactoringUtil.collectTypeParametersInDependencies(filter, used);
        if (fromList != null) {
            used.retainAll(Arrays.asList(fromList.getTypeParameters()));
        }
        PsiTypeParameter[] typeParameters = used.toArray(PsiTypeParameter.EMPTY_ARRAY);
        Arrays.sort(typeParameters, Comparator.comparingInt(tp -> tp.getTextRange().getStartOffset()));
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)elements[0].getProject()).getElementFactory();
        try {
            PsiClass aClass = elementFactory.createClassFromText("class A {}", null);
            PsiTypeParameterList list = aClass.getTypeParameterList();
            assert (list != null);
            for (PsiTypeParameter typeParameter : typeParameters) {
                list.add((PsiElement)typeParameter);
            }
            return list;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            assert (false);
            return null;
        }
    }

    private static void collectTypeParametersInDependencies(Condition<PsiTypeParameter> filter, Set<PsiTypeParameter> used) {
        Stack<PsiTypeParameter> toProcess = new Stack<PsiTypeParameter>();
        toProcess.addAll(used);
        while (!toProcess.isEmpty()) {
            PsiTypeParameter parameter2 = (PsiTypeParameter)toProcess.pop();
            HashSet<PsiTypeParameter> dependencies = new HashSet<PsiTypeParameter>();
            RefactoringUtil.collectTypeParameters(dependencies, (PsiElement)parameter2, (Condition<PsiTypeParameter>)((Condition)param -> filter.value(param) && !used.contains(param)));
            used.addAll(dependencies);
            toProcess.addAll(dependencies);
        }
    }

    public static void collectTypeParameters(Set<PsiTypeParameter> used, PsiElement element) {
        RefactoringUtil.collectTypeParameters(used, element, (Condition<PsiTypeParameter>)Conditions.alwaysTrue());
    }

    public static void collectTypeParameters(final Set<PsiTypeParameter> used, final PsiElement element, final Condition<PsiTypeParameter> filter) {
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiTypeParameter typeParameter;
                PsiElement resolved;
                super.visitReferenceElement(reference);
                if (!reference.isQualified() && (resolved = reference.resolve()) instanceof PsiTypeParameter && PsiTreeUtil.isAncestor((PsiElement)(typeParameter = (PsiTypeParameter)resolved).getOwner(), (PsiElement)element, (boolean)false) && filter.value((Object)typeParameter)) {
                    used.add(typeParameter);
                }
            }

            public void visitExpression(PsiExpression expression2) {
                super.visitExpression(expression2);
                PsiType type2 = expression2.getType();
                if (type2 != null) {
                    PsiTypesUtil.TypeParameterSearcher searcher = new PsiTypesUtil.TypeParameterSearcher();
                    type2.accept((PsiTypeVisitor)searcher);
                    for (PsiTypeParameter typeParam : searcher.getTypeParameters()) {
                        if (!PsiTreeUtil.isAncestor((PsiElement)typeParam.getOwner(), (PsiElement)element, (boolean)false) || !filter.value((Object)typeParam)) continue;
                        used.add(typeParam);
                    }
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/util/RefactoringUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeDeclaredFinal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAssignmentLHS";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnchorElementForMultipleExpressions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "makeMethodAbstract";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "makeMethodDefault";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "expandExpressionLambdaToCodeBlock";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureCodeBlock";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeParameterListWithUsedTypeParameters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class IsDescendantOf
    implements Condition<PsiClass> {
        private final PsiClass myClass;
        private final ConditionCache<PsiClass> myConditionCache;

        public IsDescendantOf(PsiClass aClass) {
            this.myClass = aClass;
            this.myConditionCache = new ConditionCache(aClass1 -> InheritanceUtil.isInheritorOrSelf((PsiClass)aClass1, (PsiClass)this.myClass, (boolean)true));
        }

        public boolean value(PsiClass aClass) {
            return this.myConditionCache.value(aClass);
        }
    }

    public static class ConditionCache<T>
    implements Condition<T> {
        private final Condition<T> myCondition;
        private final HashSet<T> myProcessedSet = new HashSet();
        private final HashSet<T> myTrueSet = new HashSet();

        public ConditionCache(Condition<T> condition2) {
            this.myCondition = condition2;
        }

        public boolean value(T object) {
            if (!this.myProcessedSet.contains(object)) {
                this.myProcessedSet.add(object);
                boolean value2 = this.myCondition.value(object);
                if (value2) {
                    this.myTrueSet.add(object);
                    return true;
                }
                return false;
            }
            return this.myTrueSet.contains(object);
        }
    }

    public static interface Graph<T> {
        public Set<T> getVertices();

        public Set<T> getTargets(T var1);
    }

    public static interface ImplicitConstructorUsageVisitor {
        public void visitConstructor(PsiMethod var1, PsiMethod var2);

        public void visitClassWithoutConstructors(PsiClass var1);
    }
}

