/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewStringBufferWithCharArgumentInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("new.string.buffer.with.char.argument.display.name", new Object[0]);
        if (string == null) {
            NewStringBufferWithCharArgumentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("new.string.buffer.with.char.argument.problem.descriptor", new Object[0]);
        if (string == null) {
            NewStringBufferWithCharArgumentInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression argument = (PsiExpression)infos[0];
        if (!(argument instanceof PsiLiteralExpression)) {
            return null;
        }
        return new NewStringBufferWithCharArgumentFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferWithCharArgumentVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/NewStringBufferWithCharArgumentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class StringBufferWithCharArgumentVisitor
    extends BaseInspectionVisitor {
        private StringBufferWithCharArgumentVisitor() {
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType type2 = argument.getType();
            if (!PsiType.CHAR.equals((Object)type2)) {
                return;
            }
            PsiMethod constructor = expression2.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiClass aClass = constructor.getContainingClass();
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.AbstractStringBuilder")) {
                return;
            }
            this.registerNewExpressionError(expression2, argument);
        }
    }

    private static class NewStringBufferWithCharArgumentFix
    extends InspectionGadgetsFix {
        private NewStringBufferWithCharArgumentFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("new.string.buffer.with.char.argument.quickfix", new Object[0]);
            if (string == null) {
                NewStringBufferWithCharArgumentFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiNewExpression newExpression = (PsiNewExpression)element.getParent();
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            String text2 = argument.getText();
            String newArgument = '\"' + StringUtil.escapeStringCharacters((String)StringUtil.stripQuotesAroundValue((String)text2)) + '\"';
            PsiReplacementUtil.replaceExpression(argument, newArgument);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/NewStringBufferWithCharArgumentInspection$NewStringBufferWithCharArgumentFix", "getFamilyName"));
        }
    }
}

