/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class ConstantConditionalExpressionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            ConstantConditionalExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiConditionalExpression expression2 = (PsiConditionalExpression)infos[0];
        String string = InspectionGadgetsBundle.message("constant.conditional.expression.problem.descriptor", ConstantConditionalExpressionInspection.calculateReplacementExpression(expression2, new CommentTracker()));
        if (string == null) {
            ConstantConditionalExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    static String calculateReplacementExpression(PsiConditionalExpression exp, CommentTracker commentTracker) {
        PsiExpression thenExpression2 = exp.getThenExpression();
        PsiExpression elseExpression2 = exp.getElseExpression();
        PsiExpression condition2 = exp.getCondition();
        assert (thenExpression2 != null);
        assert (elseExpression2 != null);
        return BoolUtils.isTrue(condition2) ? commentTracker.text((PsiElement)thenExpression2) : commentTracker.text((PsiElement)elseExpression2);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ConstantConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantConditionalExpressionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/ConstantConditionalExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ConstantConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private ConstantConditionalExpressionVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            PsiExpression condition2 = expression2.getCondition();
            PsiExpression thenExpression2 = expression2.getThenExpression();
            if (thenExpression2 == null) {
                return;
            }
            PsiExpression elseExpression2 = expression2.getElseExpression();
            if (elseExpression2 == null) {
                return;
            }
            if (BoolUtils.isFalse(condition2) || BoolUtils.isTrue(condition2)) {
                this.registerError((PsiElement)expression2, expression2);
            }
        }
    }

    private static class ConstantConditionalFix
    extends InspectionGadgetsFix {
        private ConstantConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                ConstantConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiConditionalExpression expression2 = (PsiConditionalExpression)descriptor.getPsiElement();
            CommentTracker commentTracker = new CommentTracker();
            String newExpression = ConstantConditionalExpressionInspection.calculateReplacementExpression(expression2, commentTracker);
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConstantConditionalExpressionInspection$ConstantConditionalFix", "getFamilyName"));
        }
    }
}

