/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.inheritance.RefusedBequestInspectionBase;
import com.siyeh.ig.psiutils.HighlightUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefusedBequestInspection
extends RefusedBequestInspectionBase {
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel annotationsListControl = SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)((Object)this.annotations), null);
        CheckBox checkBox1 = new CheckBox("Only report when super method is annotated by:", (InspectionProfileEntry)this, "onlyReportWhenAnnotated");
        CheckBox checkBox2 = new CheckBox(InspectionGadgetsBundle.message("refused.bequest.ignore.empty.super.methods.option", new Object[0]), (InspectionProfileEntry)this, "ignoreEmptySuperMethods");
        panel.add((Component)checkBox1, "North");
        panel.add((Component)annotationsListControl, "Center");
        panel.add((Component)checkBox2, "South");
        return panel;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RefusedBequestFix();
    }

    private static class RefusedBequestFix
    extends InspectionGadgetsFix {
        private RefusedBequestFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Insert call to super method" == null) {
                RefusedBequestFix.$$$reportNull$$$0(0);
            }
            return "Insert call to super method";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement methodName = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)methodName.getParent();
            assert (method != null);
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null) {
                return;
            }
            PsiType returnType = method.getReturnType();
            StringBuilder statementText = new StringBuilder();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            if (returnType != null && !PsiType.VOID.equals((Object)returnType)) {
                if (((JavaCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_LOCALS) {
                    statementText.append("final ");
                }
                statementText.append(returnType.getCanonicalText()).append(' ');
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                SuggestedNameInfo baseNameInfo = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, returnType);
                SuggestedNameInfo nameInfo = codeStyleManager.suggestUniqueVariableName(baseNameInfo, (PsiElement)body2, true);
                statementText.append(nameInfo.names.length > 0 ? nameInfo.names[0] : "result");
                statementText.append('=');
                MethodSignatureBackedByPsiMethod superMethodSignature = MethodUtils.getSuperMethodSignature(method);
                if (superMethodSignature == null) {
                    return;
                }
                PsiMethod superMethod = superMethodSignature.getMethod();
                PsiType superReturnType = superMethod.getReturnType();
                PsiType substitutedType = superMethodSignature.getSubstitutor().substitute(superReturnType);
                if (superReturnType != null && !returnType.isAssignableFrom(substitutedType)) {
                    statementText.append('(').append(returnType.getCanonicalText()).append(')');
                }
            }
            statementText.append("super.").append(methodName.getText()).append('(');
            boolean comma = false;
            for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
                if (comma) {
                    statementText.append(',');
                } else {
                    comma = true;
                }
                statementText.append(parameter2.getName());
            }
            statementText.append(");");
            PsiStatement newStatement = factory.createStatementFromText(statementText.toString(), null);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
            PsiJavaToken brace = body2.getLBrace();
            PsiElement element = body2.addAfter((PsiElement)newStatement, (PsiElement)brace);
            PsiElement element1 = styleManager.reformat(element);
            PsiElement element2 = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(element1);
            if (this.isOnTheFly()) {
                HighlightUtils.highlightElement(element2);
                if (element2 instanceof PsiDeclarationStatement) {
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)element2;
                    PsiLocalVariable variable = (PsiLocalVariable)declarationStatement.getDeclaredElements()[0];
                    HighlightUtils.showRenameTemplate((PsiElement)body2, (PsiNameIdentifierOwner)variable, new PsiReference[0]);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/RefusedBequestInspection$RefusedBequestFix", "getFamilyName"));
        }
    }
}

