/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.testFrameworks.AssertHint;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JUnit5AssertionsConverterInspection
extends BaseInspection {
    private String myFrameworkName = "JUnit5";

    JUnit5AssertionsConverterInspection(String frameworkName) {
        this.myFrameworkName = frameworkName;
    }

    public JUnit5AssertionsConverterInspection() {
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("junit5.assertions.converter.display.name", new Object[0]);
        if (string == null) {
            JUnit5AssertionsConverterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String name = (String)infos[0];
        String targetClassName = (String)infos[1];
        String string = InspectionGadgetsBundle.message("junit5.assertions.converter.problem.descriptor", name, targetClassName);
        if (string == null) {
            JUnit5AssertionsConverterInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean disabledFix = (Boolean)infos[2];
        return !disabledFix ? new ReplaceObsoleteAssertsFix((String)infos[1]) : null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UseOfObsoleteAssertVisitor();
    }

    private static String getNewAssertClassName(String methodName) {
        if ("assertThat".equals(methodName)) {
            return "org.hamcrest.MatcherAssert";
        }
        if (methodName.startsWith("assume")) {
            return "org.junit.jupiter.api.Assumptions";
        }
        return "org.junit.jupiter.api.Assertions";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/junit/JUnit5AssertionsConverterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static class ReplaceObsoleteAssertsFix
    extends InspectionGadgetsFix {
        private final String myBaseClassName;

        public ReplaceObsoleteAssertsFix(String baseClassName) {
            this.myBaseClassName = baseClassName;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiExpression message2;
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethodCallExpression.class);
            if (methodCallExpression == null) {
                return;
            }
            AssertHint assertHint = AssertHint.create(methodCallExpression, methodName -> AssertHint.JUnitCommonAssertNames.ASSERT_METHOD_2_PARAMETER_COUNT.get(methodName), false);
            if (assertHint == null) {
                return;
            }
            String methodName2 = assertHint.getMethod().getName();
            PsiClass newAssertClass = JavaPsiFacade.getInstance((Project)project).findClass(JUnit5AssertionsConverterInspection.getNewAssertClassName(methodName2), methodCallExpression.getResolveScope());
            if (!"assertThat".equals(methodName2) && (message2 = assertHint.getMessage()) != null) {
                methodCallExpression.getArgumentList().add((PsiElement)message2);
                message2.delete();
            }
            if (newAssertClass == null) {
                return;
            }
            String qualifiedName = newAssertClass.getQualifiedName();
            if (qualifiedName == null) {
                return;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            methodExpression.setQualifierExpression((PsiExpression)JavaPsiFacade.getElementFactory((Project)project).createReferenceExpression(newAssertClass));
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)methodExpression);
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("junit5.assertions.converter.quickfix", this.myBaseClassName);
            if (string == null) {
                ReplaceObsoleteAssertsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("junit5.assertions.converter.familyName", new Object[0]);
            if (string == null) {
                ReplaceObsoleteAssertsFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/junit/JUnit5AssertionsConverterInspection$ReplaceObsoleteAssertsFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class UseOfObsoleteAssertVisitor
    extends BaseInspectionVisitor {
        private UseOfObsoleteAssertVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            PsiFile file;
            Project project = expression2.getProject();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)expression2);
            if (module == null) {
                return;
            }
            PsiClass newAssertClass = JavaPsiFacade.getInstance((Project)project).findClass("org.junit.jupiter.api.Assertions", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
            if (newAssertClass == null) {
                return;
            }
            AssertHint hint = AssertHint.create(expression2, methodName -> AssertHint.JUnitCommonAssertNames.ASSERT_METHOD_2_PARAMETER_COUNT.get(methodName), false);
            if (hint == null) {
                return;
            }
            PsiMethod psiMethod = hint.getMethod();
            if (!psiMethod.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String name = containingClass.getQualifiedName();
            if (hint.isMessageOnFirstPosition() && (file = expression2.getContainingFile()) instanceof PsiClassOwner) {
                for (PsiClass psiClass : ((PsiClassOwner)file).getClasses()) {
                    TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)psiClass);
                    if (testFramework == null || !JUnit5AssertionsConverterInspection.this.myFrameworkName.equals(testFramework.getName())) continue;
                    String methodName2 = psiMethod.getName();
                    this.registerMethodCallError(expression2, name, JUnit5AssertionsConverterInspection.getNewAssertClassName(methodName2), this.absentInJUnit5(psiMethod, methodName2));
                    break;
                }
            }
        }

        private boolean absentInJUnit5(PsiMethod psiMethod, String methodName) {
            PsiParameter[] parameters2;
            if ("fail".equals(methodName)) {
                return psiMethod.getParameterList().isEmpty();
            }
            if ("assertNotEquals".equals(methodName) && (parameters2 = psiMethod.getParameterList().getParameters()).length > 0) {
                int lastParamIdx;
                int n = lastParamIdx = parameters2[0].getType().equalsToText("java.lang.String") ? 3 : 2;
                if (parameters2.length > lastParamIdx && parameters2[lastParamIdx].getType() instanceof PsiPrimitiveType) {
                    return true;
                }
            }
            return false;
        }
    }
}

