/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.SwitchUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IfCanBeSwitchInspection
extends BaseInspection {
    @NonNls
    private static final String ONLY_SAFE = "onlySuggestNullSafe";
    public int minimumBranches = 3;
    public boolean suggestIntSwitches = false;
    public boolean suggestEnumSwitches = false;
    protected boolean onlySuggestNullSafe = true;

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("if.can.be.switch.display.name", new Object[0]);
        if (string == null) {
            IfCanBeSwitchInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("if.can.be.switch.problem.descriptor", new Object[0]);
        if (string == null) {
            IfCanBeSwitchInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IfCanBeSwitchFix();
    }

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(InspectionGadgetsBundle.message("if.can.be.switch.minimum.branch.option", new Object[0]));
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        formatter.setParseIntegerOnly(true);
        final JFormattedTextField valueField = new JFormattedTextField(formatter);
        valueField.setValue(this.minimumBranches);
        valueField.setColumns(2);
        Document document = valueField.getDocument();
        document.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent e) {
                try {
                    valueField.commitEdit();
                    IfCanBeSwitchInspection.this.minimumBranches = ((Number)valueField.getValue()).intValue();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.bottom = 4;
        constraints.weightx = 0.0;
        constraints.anchor = 512;
        constraints.fill = 0;
        constraints.insets.right = 10;
        panel.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.insets.right = 0;
        panel.add((Component)valueField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        CheckBox checkBox1 = new CheckBox(InspectionGadgetsBundle.message("if.can.be.switch.int.option", new Object[0]), (InspectionProfileEntry)this, "suggestIntSwitches");
        panel.add((Component)checkBox1, constraints);
        constraints.gridy = 2;
        CheckBox checkBox2 = new CheckBox(InspectionGadgetsBundle.message("if.can.be.switch.enum.option", new Object[0]), (InspectionProfileEntry)this, "suggestEnumSwitches");
        panel.add((Component)checkBox2, constraints);
        constraints.gridy = 3;
        constraints.weighty = 1.0;
        CheckBox checkBox3 = new CheckBox(InspectionGadgetsBundle.message("if.can.be.switch.null.safe.option", new Object[0]), (InspectionProfileEntry)this, ONLY_SAFE);
        panel.add((Component)checkBox3, constraints);
        return panel;
    }

    public void setOnlySuggestNullSafe(boolean onlySuggestNullSafe) {
        this.onlySuggestNullSafe = onlySuggestNullSafe;
    }

    public static void replaceIfWithSwitch(PsiIfStatement ifStatement) {
        PsiStatement elseBranch;
        boolean breaksNeedRelabeled = false;
        PsiStatement breakTarget = null;
        String labelString = "";
        if (ControlFlowUtils.statementContainsNakedBreak((PsiStatement)ifStatement) && (breakTarget = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)ifStatement, (Class[])new Class[]{PsiLoopStatement.class, PsiSwitchStatement.class})) != null) {
            PsiElement parent = breakTarget.getParent();
            if (parent instanceof PsiLabeledStatement) {
                PsiLabeledStatement labeledStatement = (PsiLabeledStatement)parent;
                labelString = labeledStatement.getLabelIdentifier().getText();
                breakTarget = labeledStatement;
                breaksNeedRelabeled = true;
            } else {
                labelString = SwitchUtils.findUniqueLabelName((PsiStatement)ifStatement, "label");
                breaksNeedRelabeled = true;
            }
        }
        PsiIfStatement statementToReplace = ifStatement;
        PsiExpression switchExpression = SwitchUtils.getSwitchExpression(ifStatement, 0, false, true);
        if (switchExpression == null) {
            return;
        }
        ArrayList<SwitchUtils.IfStatementBranch> branches = new ArrayList<SwitchUtils.IfStatementBranch>(20);
        while (true) {
            PsiExpression condition2 = ifStatement.getCondition();
            PsiStatement thenBranch = ifStatement.getThenBranch();
            SwitchUtils.IfStatementBranch ifBranch = new SwitchUtils.IfStatementBranch(thenBranch, false);
            IfCanBeSwitchInspection.extractCaseExpressions(condition2, switchExpression, ifBranch);
            if (!branches.isEmpty()) {
                IfCanBeSwitchInspection.extractIfComments((PsiElement)ifStatement, ifBranch);
            }
            IfCanBeSwitchInspection.extractStatementComments((PsiElement)thenBranch, ifBranch);
            branches.add(ifBranch);
            elseBranch = ifStatement.getElseBranch();
            if (!(elseBranch instanceof PsiIfStatement)) break;
            ifStatement = (PsiIfStatement)elseBranch;
        }
        if (elseBranch != null) {
            SwitchUtils.IfStatementBranch elseIfBranch = new SwitchUtils.IfStatementBranch(elseBranch, true);
            PsiKeyword elseKeyword = ifStatement.getElseElement();
            IfCanBeSwitchInspection.extractIfComments((PsiElement)elseKeyword, elseIfBranch);
            IfCanBeSwitchInspection.extractStatementComments((PsiElement)elseBranch, elseIfBranch);
            branches.add(elseIfBranch);
        }
        StringBuilder switchStatementText = new StringBuilder();
        switchStatementText.append("switch(").append(switchExpression.getText()).append("){");
        PsiType type2 = switchExpression.getType();
        boolean castToInt = type2 != null && type2.equalsToText("java.lang.Integer");
        for (SwitchUtils.IfStatementBranch branch : branches) {
            boolean hasConflicts = false;
            for (SwitchUtils.IfStatementBranch testBranch : branches) {
                if (branch == testBranch || !branch.topLevelDeclarationsConflictWith(testBranch)) continue;
                hasConflicts = true;
            }
            IfCanBeSwitchInspection.dumpBranch(branch, castToInt, hasConflicts, breaksNeedRelabeled, labelString, switchStatementText);
        }
        switchStatementText.append('}');
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)ifStatement.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        if (breaksNeedRelabeled) {
            StringBuilder out = new StringBuilder();
            if (!(breakTarget instanceof PsiLabeledStatement)) {
                out.append(labelString).append(':');
            }
            IfCanBeSwitchInspection.termReplace((PsiElement)breakTarget, (PsiElement)statementToReplace, switchStatementText, out);
            String newStatementText = out.toString();
            PsiStatement newStatement = factory.createStatementFromText(newStatementText, (PsiElement)ifStatement);
            breakTarget.replace((PsiElement)newStatement);
        } else {
            PsiStatement newStatement = factory.createStatementFromText(switchStatementText.toString(), (PsiElement)ifStatement);
            statementToReplace.replace((PsiElement)newStatement);
        }
    }

    @SafeVarargs
    @Nullable
    public static <T extends PsiElement> T getPrevSiblingOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, Class<? extends PsiElement> ... stopAt) {
        PsiElement sibling;
        if (aClass == null) {
            IfCanBeSwitchInspection.$$$reportNull$$$0(2);
        }
        if (stopAt == null) {
            IfCanBeSwitchInspection.$$$reportNull$$$0(3);
        }
        if (element == null) {
            return null;
        }
        for (sibling = element.getPrevSibling(); sibling != null && !aClass.isInstance(sibling); sibling = sibling.getPrevSibling()) {
            for (Class<? extends PsiElement> stopClass : stopAt) {
                if (!stopClass.isInstance(sibling)) continue;
                return null;
            }
        }
        return (T)sibling;
    }

    private static void extractIfComments(PsiElement element, SwitchUtils.IfStatementBranch out) {
        PsiComment comment = IfCanBeSwitchInspection.getPrevSiblingOfType(element, PsiComment.class, PsiStatement.class);
        while (comment != null) {
            out.addComment(IfCanBeSwitchInspection.getCommentText(comment));
            comment = IfCanBeSwitchInspection.getPrevSiblingOfType((PsiElement)comment, PsiComment.class, PsiStatement.class);
        }
    }

    private static void extractStatementComments(PsiElement element, SwitchUtils.IfStatementBranch out) {
        PsiComment comment = IfCanBeSwitchInspection.getPrevSiblingOfType(element, PsiComment.class, PsiStatement.class, PsiKeyword.class);
        while (comment != null) {
            out.addStatementComment(IfCanBeSwitchInspection.getCommentText(comment));
            comment = IfCanBeSwitchInspection.getPrevSiblingOfType((PsiElement)comment, PsiComment.class, PsiStatement.class, PsiKeyword.class);
        }
    }

    private static String getCommentText(PsiComment comment) {
        PsiElement sibling = comment.getPrevSibling();
        if (sibling instanceof PsiWhiteSpace) {
            String whiteSpaceText = sibling.getText();
            return whiteSpaceText.startsWith("\n") ? whiteSpaceText.substring(1) + comment.getText() : comment.getText();
        }
        return comment.getText();
    }

    private static void termReplace(PsiElement target, PsiElement replace, StringBuilder stringToReplaceWith, StringBuilder out) {
        if (target.equals(replace)) {
            out.append((CharSequence)stringToReplaceWith);
        } else if (target.getChildren().length == 0) {
            out.append(target.getText());
        } else {
            PsiElement[] children;
            for (PsiElement child : children = target.getChildren()) {
                IfCanBeSwitchInspection.termReplace(child, replace, stringToReplaceWith, out);
            }
        }
    }

    private static void extractCaseExpressions(PsiExpression expression2, PsiExpression switchExpression, SwitchUtils.IfStatementBranch branch) {
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression argument = arguments[0];
            PsiExpression secondArgument = arguments.length > 1 ? arguments[1] : null;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            boolean stringType = ExpressionUtils.hasStringType(qualifierExpression2);
            if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(switchExpression, argument)) {
                branch.addCaseExpression(stringType ? qualifierExpression2 : secondArgument);
            } else {
                branch.addCaseExpression(argument);
            }
        } else if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.OROR.equals(tokenType)) {
                for (PsiExpression operand2 : operands2) {
                    IfCanBeSwitchInspection.extractCaseExpressions(operand2, switchExpression, branch);
                }
            } else if (operands2.length == 2) {
                PsiExpression lhs = operands2[0];
                PsiExpression rhs = operands2[1];
                if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(switchExpression, rhs)) {
                    branch.addCaseExpression(lhs);
                } else {
                    branch.addCaseExpression(rhs);
                }
            }
        } else if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression contents = parenthesizedExpression.getExpression();
            IfCanBeSwitchInspection.extractCaseExpressions(contents, switchExpression, branch);
        }
    }

    private static void dumpBranch(SwitchUtils.IfStatementBranch branch, boolean castToInt, boolean wrap, boolean renameBreaks, String breakLabelName, @NonNls StringBuilder switchStatementText) {
        IfCanBeSwitchInspection.dumpComments(branch.getComments(), switchStatementText);
        if (branch.isElse()) {
            switchStatementText.append("default: ");
        } else {
            for (PsiExpression caseExpression : branch.getCaseExpressions()) {
                switchStatementText.append("case ").append(IfCanBeSwitchInspection.getCaseLabelText(caseExpression, castToInt)).append(": ");
            }
        }
        IfCanBeSwitchInspection.dumpComments(branch.getStatementComments(), switchStatementText);
        IfCanBeSwitchInspection.dumpBody(branch.getStatement(), wrap, renameBreaks, breakLabelName, switchStatementText);
    }

    @NonNls
    private static String getCaseLabelText(PsiExpression expression2, boolean castToInt) {
        PsiType type2;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        if (expression2 instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)expression2).resolve()) instanceof PsiEnumConstant) {
            PsiEnumConstant enumConstant = (PsiEnumConstant)target;
            return enumConstant.getName();
        }
        if (castToInt && !PsiType.INT.equals((Object)(type2 = expression2.getType()))) {
            return "(int)" + expression2.getText();
        }
        return expression2.getText();
    }

    private static void dumpComments(List<String> comments, StringBuilder switchStatementText) {
        if (comments.isEmpty()) {
            return;
        }
        switchStatementText.append('\n');
        for (String comment : comments) {
            switchStatementText.append(comment).append('\n');
        }
    }

    private static void dumpBody(PsiStatement bodyStatement, boolean wrap, boolean renameBreaks, String breakLabelName, @NonNls StringBuilder switchStatementText) {
        if (wrap) {
            switchStatementText.append('{');
        }
        if (bodyStatement instanceof PsiBlockStatement) {
            PsiCodeBlock codeBlock = ((PsiBlockStatement)bodyStatement).getCodeBlock();
            PsiElement[] children = codeBlock.getChildren();
            for (int i = 1; i < children.length - 1; ++i) {
                PsiElement child = children[i];
                IfCanBeSwitchInspection.appendElement(child, renameBreaks, breakLabelName, switchStatementText);
            }
        } else {
            IfCanBeSwitchInspection.appendElement((PsiElement)bodyStatement, renameBreaks, breakLabelName, switchStatementText);
        }
        if (ControlFlowUtils.statementMayCompleteNormally(bodyStatement)) {
            switchStatementText.append("break;");
        }
        if (wrap) {
            switchStatementText.append('}');
        }
    }

    private static void appendElement(PsiElement element, boolean renameBreakElements, String breakLabelString, @NonNls StringBuilder switchStatementText) {
        String text2 = element.getText();
        if (!renameBreakElements) {
            switchStatementText.append(text2);
        } else if (element instanceof PsiBreakStatement) {
            PsiBreakStatement breakStatement = (PsiBreakStatement)element;
            PsiIdentifier identifier = breakStatement.getLabelIdentifier();
            if (identifier == null) {
                switchStatementText.append("break ").append(breakLabelString).append(';');
            } else {
                switchStatementText.append(text2);
            }
        } else if (element instanceof PsiBlockStatement || element instanceof PsiCodeBlock || element instanceof PsiIfStatement) {
            PsiElement[] children;
            for (PsiElement child : children = element.getChildren()) {
                IfCanBeSwitchInspection.appendElement(child, true, breakLabelString, switchStatementText);
            }
        } else {
            switchStatementText.append(text2);
        }
        PsiElement lastChild = element.getLastChild();
        if (IfCanBeSwitchInspection.isEndOfLineComment(lastChild)) {
            switchStatementText.append('\n');
        }
    }

    private static boolean isEndOfLineComment(PsiElement element) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        PsiComment comment = (PsiComment)element;
        IElementType tokenType = comment.getTokenType();
        return JavaTokenType.END_OF_LINE_COMMENT.equals(tokenType);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IfCanBeSwitchVisitor();
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            IfCanBeSwitchInspection.$$$reportNull$$$0(4);
        }
        super.writeSettings(node);
        if (!this.onlySuggestNullSafe) {
            Element e = new Element("option");
            e.setAttribute("name", ONLY_SAFE);
            e.setAttribute("value", Boolean.toString(this.onlySuggestNullSafe));
            node.addContent(e);
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            IfCanBeSwitchInspection.$$$reportNull$$$0(5);
        }
        super.readSettings(node);
        for (Element child : node.getChildren("option")) {
            if (!Comparing.strEqual((String)child.getAttributeValue("name"), (String)ONLY_SAFE)) continue;
            String value2 = child.getAttributeValue("value");
            if (value2 == null) break;
            this.onlySuggestNullSafe = Boolean.parseBoolean(value2);
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/migration/IfCanBeSwitchInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/migration/IfCanBeSwitchInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSiblingOfType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class IfCanBeSwitchVisitor
    extends BaseInspectionVisitor {
        private IfCanBeSwitchVisitor() {
        }

        public void visitIfStatement(PsiIfStatement statement) {
            ProblemHighlightType highlightType;
            super.visitIfStatement(statement);
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiIfStatement) {
                return;
            }
            PsiExpression switchExpression = SwitchUtils.getSwitchExpression(statement, IfCanBeSwitchInspection.this.minimumBranches, false, true);
            if (switchExpression == null) {
                return;
            }
            if (this.shouldHighlight(switchExpression)) {
                highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            } else {
                if (!this.isOnTheFly()) {
                    return;
                }
                highlightType = ProblemHighlightType.INFORMATION;
            }
            this.registerError(statement.getFirstChild(), highlightType, new Object[]{switchExpression});
        }

        private boolean shouldHighlight(PsiExpression switchExpression) {
            PsiType type2 = switchExpression.getType();
            if (!IfCanBeSwitchInspection.this.suggestIntSwitches && (type2 instanceof PsiClassType ? type2.equalsToText("java.lang.Integer") || type2.equalsToText("java.lang.Short") || type2.equalsToText("java.lang.Byte") || type2.equalsToText("java.lang.Character") : PsiType.INT.equals((Object)type2) || PsiType.SHORT.equals((Object)type2) || PsiType.BYTE.equals((Object)type2) || PsiType.CHAR.equals((Object)type2))) {
                return false;
            }
            if (type2 instanceof PsiClassType) {
                PsiClassType classType = (PsiClassType)type2;
                PsiClass aClass = classType.resolve();
                if (aClass == null) {
                    return false;
                }
                if (!IfCanBeSwitchInspection.this.suggestEnumSwitches && aClass.isEnum()) {
                    return false;
                }
                if ("java.lang.String".equals(aClass.getQualifiedName())) {
                    PsiMethodCallExpression methodCallExpression;
                    PsiElement grandParent;
                    PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)switchExpression);
                    if (parent instanceof PsiExpressionList && IfCanBeSwitchInspection.this.onlySuggestNullSafe && !ExpressionUtils.isAnnotatedNotNull(switchExpression) && (grandParent = parent.getParent()) instanceof PsiMethodCallExpression && "equals".equals((methodCallExpression = (PsiMethodCallExpression)grandParent).getMethodExpression().getReferenceName())) {
                        return false;
                    }
                    return !(parent instanceof PsiPolyadicExpression);
                }
            }
            return !SideEffectChecker.mayHaveSideEffects(switchExpression);
        }
    }

    private static class IfCanBeSwitchFix
    extends InspectionGadgetsFix {
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("if.can.be.switch.quickfix", new Object[0]);
            if (string == null) {
                IfCanBeSwitchFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement().getParent();
            if (!(element instanceof PsiIfStatement)) {
                return;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)element;
            IfCanBeSwitchInspection.replaceIfWithSwitch(ifStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/IfCanBeSwitchInspection$IfCanBeSwitchFix", "getFamilyName"));
        }
    }
}

