/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class CallToSimpleSetterInClassInspectionBase
extends BaseInspection {
    public boolean ignoreSetterCallsOnOtherObjects = false;
    public boolean onlyReportPrivateSetter = false;

    @NotNull
    public String getID() {
        if ("CallToSimpleSetterFromWithinClass" == null) {
            CallToSimpleSetterInClassInspectionBase.$$$reportNull$$$0(0);
        }
        return "CallToSimpleSetterFromWithinClass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("call.to.simple.setter.in.class.display.name", new Object[0]);
        if (string == null) {
            CallToSimpleSetterInClassInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("call.to.simple.setter.in.class.problem.descriptor", new Object[0]);
        if (string == null) {
            CallToSimpleSetterInClassInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CallToSimpleSetterInClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/CallToSimpleSetterInClassInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class CallToSimpleSetterInClassVisitor
    extends BaseInspectionVisitor {
        private CallToSimpleSetterInClassVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                CallToSimpleSetterInClassVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call);
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)call);
            if (containingClass == null) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            if (!containingClass.equals(method.getContainingClass())) {
                return;
            }
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
                if (CallToSimpleSetterInClassInspectionBase.this.ignoreSetterCallsOnOtherObjects) {
                    return;
                }
                PsiClass qualifierClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifier.getType());
                if (!containingClass.equals(qualifierClass)) {
                    return;
                }
            }
            if (!PropertyUtil.isSimpleSetter(method)) {
                return;
            }
            if (CallToSimpleSetterInClassInspectionBase.this.onlyReportPrivateSetter && !method.hasModifierProperty("private")) {
                return;
            }
            Query query = OverridingMethodsSearch.search((PsiMethod)method);
            PsiMethod overridingMethod = (PsiMethod)query.findFirst();
            if (overridingMethod != null) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/performance/CallToSimpleSetterInClassInspectionBase$CallToSimpleSetterInClassVisitor", "visitMethodCallExpression"));
        }
    }
}

