/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeUtils {
    private static final String[] EQUAL_CONTRACT_CLASSES = new String[]{"java.util.List", "java.util.Set", "java.util.Map", "java.util.Map.Entry"};
    private static final Map<PsiType, Integer> typePrecisions = new HashMap<PsiType, Integer>(7);

    private TypeUtils() {
    }

    @Contract(value="_, null -> false")
    public static boolean typeEquals(@NonNls @NotNull String typeName, @Nullable PsiType targetType) {
        if (typeName == null) {
            TypeUtils.$$$reportNull$$$0(0);
        }
        return targetType != null && targetType.equalsToText(typeName);
    }

    public static PsiClassType getType(@NotNull String fqName, @NotNull PsiElement context) {
        if (fqName == null) {
            TypeUtils.$$$reportNull$$$0(1);
        }
        if (context == null) {
            TypeUtils.$$$reportNull$$$0(2);
        }
        Project project = context.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        GlobalSearchScope scope = context.getResolveScope();
        return factory.createTypeByFQClassName(fqName, scope);
    }

    public static PsiClassType getType(@NotNull PsiClass aClass) {
        if (aClass == null) {
            TypeUtils.$$$reportNull$$$0(3);
        }
        return JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass);
    }

    public static PsiClassType getObjectType(@NotNull PsiElement context) {
        if (context == null) {
            TypeUtils.$$$reportNull$$$0(4);
        }
        return TypeUtils.getType("java.lang.Object", context);
    }

    public static PsiClassType getStringType(@NotNull PsiElement context) {
        if (context == null) {
            TypeUtils.$$$reportNull$$$0(5);
        }
        return TypeUtils.getType("java.lang.String", context);
    }

    public static boolean isNarrowingConversion(@Nullable PsiType sourceType, @Nullable PsiType targetType) {
        Integer sourcePrecision = typePrecisions.get(sourceType);
        Integer targetPrecision = typePrecisions.get(targetType);
        return sourcePrecision != null && targetPrecision != null && targetPrecision < sourcePrecision;
    }

    @Contract(value="null -> false")
    public static boolean isJavaLangObject(@Nullable PsiType targetType) {
        return TypeUtils.typeEquals("java.lang.Object", targetType);
    }

    @Contract(value="null -> false")
    public static boolean isJavaLangString(@Nullable PsiType targetType) {
        return TypeUtils.typeEquals("java.lang.String", targetType);
    }

    public static boolean isOptional(@Nullable PsiType type2) {
        return TypeUtils.isOptional(PsiUtil.resolveClassInClassTypeOnly((PsiType)type2));
    }

    @Contract(value="null -> false")
    public static boolean isOptional(PsiClass aClass) {
        if (aClass == null) {
            return false;
        }
        String qualifiedName = aClass.getQualifiedName();
        return "java.util.Optional".equals(qualifiedName) || "java.util.OptionalDouble".equals(qualifiedName) || "java.util.OptionalInt".equals(qualifiedName) || "java.util.OptionalLong".equals(qualifiedName) || "com.google.common.base.Optional".equals(qualifiedName);
    }

    public static boolean isExpressionTypeAssignableWith(@NotNull PsiExpression expression2, @NotNull Iterable<String> rhsTypeTexts) {
        PsiType type2;
        if (expression2 == null) {
            TypeUtils.$$$reportNull$$$0(6);
        }
        if (rhsTypeTexts == null) {
            TypeUtils.$$$reportNull$$$0(7);
        }
        if ((type2 = expression2.getType()) == null) {
            return false;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
        for (String rhsTypeText : rhsTypeTexts) {
            PsiClassType rhsType = factory.createTypeByFQClassName(rhsTypeText, expression2.getResolveScope());
            if (!type2.isAssignableFrom((PsiType)rhsType)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    public static boolean expressionHasTypeOrSubtype(@Nullable PsiExpression expression2, @NonNls @NotNull String typeName) {
        if (typeName == null) {
            TypeUtils.$$$reportNull$$$0(8);
        }
        return TypeUtils.expressionHasTypeOrSubtype(expression2, new String[]{typeName}) != null;
    }

    public static String expressionHasTypeOrSubtype(@Nullable PsiExpression expression2, String ... typeNames) {
        PsiType type2;
        if (typeNames == null) {
            TypeUtils.$$$reportNull$$$0(9);
        }
        if (expression2 == null) {
            return null;
        }
        PsiType psiType = type2 = expression2 instanceof PsiFunctionalExpression ? ((PsiFunctionalExpression)expression2).getFunctionalInterfaceType() : expression2.getType();
        if (type2 == null) {
            return null;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        if (aClass == null) {
            return null;
        }
        for (String typeName : typeNames) {
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)typeName)) continue;
            return typeName;
        }
        return null;
    }

    public static boolean expressionHasTypeOrSubtype(@Nullable PsiExpression expression2, @NonNls @NotNull Iterable<String> typeNames) {
        if (typeNames == null) {
            TypeUtils.$$$reportNull$$$0(10);
        }
        if (expression2 == null) {
            return false;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
        if (aClass == null) {
            return false;
        }
        for (String typeName : typeNames) {
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)typeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean variableHasTypeOrSubtype(@Nullable PsiVariable variable, String ... typeNames) {
        if (typeNames == null) {
            TypeUtils.$$$reportNull$$$0(11);
        }
        if (variable == null) {
            return false;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)variable.getType());
        if (aClass == null) {
            return false;
        }
        for (String typeName : typeNames) {
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)typeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFloatingPointType(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        PsiType type2 = expression2.getType();
        return type2 != null && (PsiType.FLOAT.equals((Object)type2) || PsiType.DOUBLE.equals((Object)type2));
    }

    public static boolean areConvertible(PsiType type1, PsiType type2) {
        if (TypeConversionUtil.areTypesConvertible((PsiType)type1, (PsiType)type2)) {
            return true;
        }
        PsiType comparedTypeErasure = TypeConversionUtil.erasure((PsiType)type1);
        PsiType comparisonTypeErasure = TypeConversionUtil.erasure((PsiType)type2);
        if (comparedTypeErasure == null || comparisonTypeErasure == null || TypeConversionUtil.areTypesConvertible((PsiType)comparedTypeErasure, (PsiType)comparisonTypeErasure)) {
            if (type1 instanceof PsiClassType && type2 instanceof PsiClassType) {
                PsiType[] parameters2;
                PsiClassType classType1 = (PsiClassType)type1;
                PsiClassType classType2 = (PsiClassType)type2;
                PsiType[] parameters1 = classType1.getParameters();
                if (parameters1.length != (parameters2 = classType2.getParameters()).length) {
                    return ((PsiClassType)type1).isRaw() || ((PsiClassType)type2).isRaw();
                }
                for (int i = 0; i < parameters1.length; ++i) {
                    if (TypeUtils.areConvertible(parameters1[i], parameters2[i])) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isTypeParameter(PsiType type2) {
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        return aClass instanceof PsiTypeParameter;
    }

    public static PsiType unaryNumericPromotion(PsiType type2) {
        if (type2 == null) {
            return null;
        }
        if (type2.equalsToText("java.lang.Byte") || type2.equalsToText("java.lang.Short") || type2.equalsToText("java.lang.Character") || type2.equalsToText("java.lang.Integer") || type2.equals(PsiType.BYTE) || type2.equals(PsiType.SHORT) || type2.equals(PsiType.CHAR)) {
            return PsiType.INT;
        }
        if (type2.equalsToText("java.lang.Long")) {
            return PsiType.LONG;
        }
        if (type2.equalsToText("java.lang.Float")) {
            return PsiType.FLOAT;
        }
        if (type2.equalsToText("java.lang.Double")) {
            return PsiType.DOUBLE;
        }
        return type2;
    }

    @Contract(value="null -> null")
    public static String resolvedClassName(PsiType type2) {
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        return aClass == null ? null : aClass.getQualifiedName();
    }

    public static boolean mayBeEqualByContract(PsiType type1, PsiType type2) {
        return Stream.of(EQUAL_CONTRACT_CLASSES).anyMatch(className -> TypeUtils.areConvertibleSubtypesOf(type1, type2, className));
    }

    private static boolean areConvertibleSubtypesOf(PsiType type1, PsiType type2, String className) {
        PsiClass class1 = PsiUtil.resolveClassInClassTypeOnly((PsiType)type1);
        if (class1 == null) {
            return false;
        }
        PsiClass class2 = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        if (class2 == null) {
            return false;
        }
        PsiClass superClass = JavaPsiFacade.getInstance((Project)class1.getProject()).findClass(className, class1.getResolveScope());
        if (superClass == null) {
            return false;
        }
        return InheritanceUtil.isInheritorOrSelf((PsiClass)class1, (PsiClass)superClass, (boolean)true) && InheritanceUtil.isInheritorOrSelf((PsiClass)class2, (PsiClass)superClass, (boolean)true);
    }

    public static boolean cannotBeEqualByContract(PsiType type1, PsiType type2) {
        if (InheritanceUtil.isInheritor((PsiType)type1, (String)"java.util.Set") && InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.List")) {
            return true;
        }
        return InheritanceUtil.isInheritor((PsiType)type1, (String)"java.util.List") && InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Set");
    }

    static {
        typePrecisions.put((PsiType)PsiType.BYTE, 1);
        typePrecisions.put((PsiType)PsiType.CHAR, 2);
        typePrecisions.put((PsiType)PsiType.SHORT, 2);
        typePrecisions.put((PsiType)PsiType.INT, 3);
        typePrecisions.put((PsiType)PsiType.LONG, 4);
        typePrecisions.put((PsiType)PsiType.FLOAT, 5);
        typePrecisions.put((PsiType)PsiType.DOUBLE, 6);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rhsTypeTexts";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeNames";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/TypeUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "typeEquals";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getObjectType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getStringType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isExpressionTypeAssignableWith";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "expressionHasTypeOrSubtype";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "variableHasTypeOrSubtype";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

