/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.MethodCallChainPredicate;
import com.siyeh.ipp.psiutils.HighlightUtil;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class MakeCallChainIntoCallSequenceIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MethodCallChainPredicate methodCallChainPredicate = new MethodCallChainPredicate();
        if (methodCallChainPredicate == null) {
            MakeCallChainIntoCallSequenceIntention.$$$reportNull$$$0(0);
        }
        return methodCallChainPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        boolean showRenameTemplate;
        String variableDeclaration;
        String firstStatement;
        PsiStatement appendStatement;
        String targetText;
        if (element == null) {
            MakeCallChainIntoCallSequenceIntention.$$$reportNull$$$0(1);
        }
        ArrayList<String> callTexts = new ArrayList<String>();
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)element, PsiMethodCallExpression.class);
        PsiExpression root = MethodCallChainPredicate.getCallChainRoot((PsiElement)call);
        if (root == null) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        while (call != null && call != root) {
            callTexts.add(call.getMethodExpression().getReferenceName() + tracker.text((PsiElement)call.getArgumentList()));
            call = MethodCallUtils.getQualifierMethodCall(call);
        }
        PsiType rootType = root.getType();
        if (rootType == null) {
            return;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiExpressionStatement) {
            targetText = root.getText();
            appendStatement = (PsiStatement)parent;
            firstStatement = null;
            variableDeclaration = null;
            showRenameTemplate = false;
        } else {
            PsiElement grandParent = parent.getParent();
            appendStatement = (PsiStatement)grandParent;
            if (parent instanceof PsiAssignmentExpression && grandParent instanceof PsiExpressionStatement) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                PsiExpression lhs = assignment.getLExpression();
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression expression2 = (PsiReferenceExpression)lhs;
                PsiElement target = expression2.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target;
                PsiType variableType = variable.getType();
                if (variableType.equals(rootType)) {
                    targetText = lhs.getText();
                    PsiJavaToken token = assignment.getOperationSign();
                    firstStatement = targetText + token.getText() + root.getText() + ';';
                    showRenameTemplate = false;
                } else {
                    targetText = "x";
                    showRenameTemplate = true;
                    Project project = element.getProject();
                    CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project);
                    firstStatement = ((JavaCodeStyleSettings)codeStyleSettings.getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_LOCALS ? "final " + rootType.getCanonicalText() + ' ' + targetText + '=' + root.getText() + ';' : rootType.getCanonicalText() + ' ' + targetText + '=' + root.getText() + ';';
                }
                variableDeclaration = null;
            } else {
                PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)appendStatement;
                PsiVariable variable = (PsiVariable)declaration2.getDeclaredElements()[0];
                PsiType variableType = variable.getType();
                if (variableType.equals(rootType)) {
                    targetText = variable.getName();
                    firstStatement = variable.hasModifierProperty("final") ? "final " + variableType.getCanonicalText() + ' ' + variable.getName() + '=' + root.getText() + ';' : variableType.getCanonicalText() + ' ' + variable.getName() + '=' + root.getText() + ';';
                    variableDeclaration = null;
                    showRenameTemplate = false;
                } else {
                    variableDeclaration = variable.hasModifierProperty("final") ? "final " + variableType.getCanonicalText() + ' ' + variable.getName() + '=' : variableType.getCanonicalText() + ' ' + variable.getName() + '=';
                    targetText = "x";
                    showRenameTemplate = true;
                    Project project = element.getProject();
                    CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project);
                    firstStatement = ((JavaCodeStyleSettings)codeStyleSettings.getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_LOCALS ? "final " + rootType.getCanonicalText() + " x=" + root.getText() + ';' : rootType.getCanonicalText() + " x=" + root.getText() + ';';
                }
            }
        }
        StringBuilder builder = new StringBuilder("{\n");
        if (firstStatement != null) {
            builder.append(firstStatement);
        }
        Collections.reverse(callTexts);
        int size = callTexts.size();
        for (int i = 0; i < size; ++i) {
            String callText = (String)callTexts.get(i);
            if (i == size - 1 && variableDeclaration != null) {
                builder.append(variableDeclaration);
            }
            builder.append(targetText).append('.').append(callText).append(";\n");
        }
        builder.append('}');
        PsiManager manager = element.getManager();
        Project project = manager.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiElement appendStatementParent = appendStatement.getParent();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        PsiCodeBlock codeBlock = factory.createCodeBlockFromText(builder.toString(), (PsiElement)appendStatement);
        if (appendStatementParent instanceof PsiLoopStatement || appendStatementParent instanceof PsiIfStatement) {
            PsiElement insertedCodeBlock = tracker.replaceAndRestoreComments((PsiElement)appendStatement, (PsiElement)codeBlock);
            PsiCodeBlock reformattedCodeBlock = (PsiCodeBlock)codeStyleManager.reformat(insertedCodeBlock);
            if (showRenameTemplate) {
                PsiStatement[] statements = reformattedCodeBlock.getStatements();
                PsiVariable variable = (PsiVariable)((PsiDeclarationStatement)statements[0]).getDeclaredElements()[0];
                HighlightUtil.showRenameTemplate(appendStatementParent, (PsiNameIdentifierOwner)variable);
            }
        } else {
            PsiStatement[] statements = codeBlock.getStatements();
            PsiVariable variable = null;
            int length = statements.length;
            for (int i = 0; i < length; ++i) {
                PsiElement insertedStatement = appendStatementParent.addBefore((PsiElement)tracker.markUnchanged(statements[i]), (PsiElement)appendStatement);
                if (i == 0 && showRenameTemplate) {
                    variable = (PsiVariable)((PsiDeclarationStatement)insertedStatement).getDeclaredElements()[0];
                }
                codeStyleManager.reformat(insertedStatement);
            }
            tracker.deleteAndRestoreComments((PsiElement)appendStatement);
            if (variable != null) {
                HighlightUtil.showRenameTemplate(appendStatementParent, variable);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/concatenation/MakeCallChainIntoCallSequenceIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/concatenation/MakeCallChainIntoCallSequenceIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

