/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.junit.AssertTrueOrFalsePredicate;
import org.jetbrains.annotations.NotNull;

public class FlipAssertLiteralIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String fromMethodName = methodExpression.getReferenceName();
        String toMethodName = "assertTrue".equals(fromMethodName) ? "assertFalse" : "assertTrue";
        return IntentionPowerPackBundle.message("flip.assert.literal.intention.name", fromMethodName, toMethodName);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        AssertTrueOrFalsePredicate assertTrueOrFalsePredicate = new AssertTrueOrFalsePredicate();
        if (assertTrueOrFalsePredicate == null) {
            FlipAssertLiteralIntention.$$$reportNull$$$0(0);
        }
        return assertTrueOrFalsePredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiMethodCallExpression call;
        PsiReferenceExpression methodExpression;
        String fromMethodName;
        if (element == null) {
            FlipAssertLiteralIntention.$$$reportNull$$$0(1);
        }
        String toMethodName = "assertTrue".equals(fromMethodName = (methodExpression = (call = (PsiMethodCallExpression)element).getMethodExpression()).getReferenceName()) ? "assertFalse" : "assertTrue";
        CommentTracker tracker = new CommentTracker();
        StringBuilder newCall = new StringBuilder();
        PsiElement qualifier = methodExpression.getQualifier();
        if (qualifier == null) {
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"junit.framework.Assert") && !ImportUtils.addStaticImport("org.junit.Assert", toMethodName, element)) {
                newCall.append("org.junit.Assert.");
            }
        } else {
            newCall.append(tracker.text(qualifier)).append('.');
        }
        newCall.append(toMethodName).append('(');
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length == 1) {
            newCall.append(BoolUtils.getNegatedExpressionText(arguments[0], tracker));
        } else {
            newCall.append(tracker.text((PsiElement)arguments[0])).append(',');
            newCall.append(BoolUtils.getNegatedExpressionText(arguments[1], tracker));
        }
        newCall.append(')');
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)call, newCall.toString(), tracker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/junit/FlipAssertLiteralIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/junit/FlipAssertLiteralIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

