/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.componentTree.ComponentTree;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.Painter;
import com.intellij.uiDesigner.propertyInspector.DesignerToolWindowManager;
import com.intellij.uiDesigner.radComponents.RadButtonGroup;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import icons.UIDesignerIcons;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

class PassiveDecorationLayer
extends JComponent {
    @NotNull
    private final GuiEditor myEditor;

    public PassiveDecorationLayer(@NotNull GuiEditor editor) {
        if (editor == null) {
            PassiveDecorationLayer.$$$reportNull$$$0(0);
        }
        this.myEditor = editor;
    }

    protected final void paintPassiveDecoration(RadComponent component, final Graphics g) {
        Painter.paintComponentDecoration(this.myEditor, component, g);
        final HashSet paintedGroups = new HashSet();
        final RadRootContainer rootContainer = this.myEditor.getRootContainer();
        ComponentTree componentTree = DesignerToolWindowManager.getInstance(this.myEditor).getComponentTree();
        final List selectedGroups = componentTree != null ? componentTree.getSelectedElements(RadButtonGroup.class) : Collections.emptyList();
        FormEditingUtil.iterate(component, new FormEditingUtil.ComponentVisitor<RadComponent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean visit(RadComponent component) {
                Point point = SwingUtilities.convertPoint(component.getDelegee(), 0, 0, rootContainer.getDelegee());
                RadButtonGroup group = (RadButtonGroup)FormEditingUtil.findGroupForComponent(rootContainer, component);
                if (group != null && !paintedGroups.contains(group) && (component.isSelected() || selectedGroups.contains(group))) {
                    paintedGroups.add(group);
                    Painter.paintButtonGroupLines(rootContainer, group, g);
                }
                g.translate(point.x, point.y);
                try {
                    if (PassiveDecorationLayer.this.myEditor.isShowComponentTags() && FormEditingUtil.isComponentSwitchedInView(component)) {
                        Painter.paintComponentTag(component, g);
                    }
                    Painter.paintSelectionDecoration(component, g, PassiveDecorationLayer.this.myEditor.getGlassLayer().isFocusOwner());
                    if (component.hasDragger()) {
                        Icon icon = PassiveDecorationLayer.getDragIcon();
                        icon.paintIcon(PassiveDecorationLayer.this, g, -icon.getIconWidth(), -icon.getIconHeight());
                    }
                }
                finally {
                    g.translate(-point.x, -point.y);
                }
                return true;
            }
        });
    }

    private static Icon getDragIcon() {
        return UIDesignerIcons.Drag;
    }

    @Override
    public void paint(Graphics g) {
        RadRootContainer root = this.myEditor.getRootContainer();
        for (int i = root.getComponentCount() - 1; i >= 0; --i) {
            RadComponent component = root.getComponent(i);
            this.paintPassiveDecoration(component, g);
        }
        this.paintChildren(g);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/uiDesigner/designSurface/PassiveDecorationLayer", "<init>"));
    }
}

