/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.palette;

import com.intellij.ide.palette.PaletteGroup;
import com.intellij.ide.palette.PaletteItem;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GroupItem
implements Cloneable,
PaletteGroup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.palette.GroupItem");
    public static final DataKey<GroupItem> DATA_KEY = DataKey.create((String)GroupItem.class.getName());
    @NotNull
    private String myName;
    @NotNull
    private final ArrayList<ComponentItem> myItems;
    private boolean myReadOnly;
    private boolean mySpecialGroup;

    public GroupItem(@NotNull String name) {
        if (name == null) {
            GroupItem.$$$reportNull$$$0(0);
        }
        this.myItems = new ArrayList();
        this.myReadOnly = false;
        this.mySpecialGroup = false;
        this.setName(name);
    }

    public GroupItem(boolean specialGroup) {
        this.myItems = new ArrayList();
        this.myReadOnly = false;
        this.mySpecialGroup = false;
        this.mySpecialGroup = specialGroup;
    }

    public GroupItem clone() {
        GroupItem result = new GroupItem(this.myName);
        for (ComponentItem myItem : this.myItems) {
            result.addItem(myItem.clone());
        }
        return result;
    }

    public boolean isReadOnly() {
        return this.myReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.mySpecialGroup) {
            String string = UIDesignerBundle.message("palette.special.group", new Object[0]);
            if (string == null) {
                GroupItem.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = this.myName;
        if (string == null) {
            GroupItem.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public String getTabName() {
        return "Swing";
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            GroupItem.$$$reportNull$$$0(3);
        }
        this.myName = name;
    }

    @NotNull
    public ComponentItem[] getItems() {
        ComponentItem[] componentItemArray = this.myItems.toArray(new ComponentItem[0]);
        if (componentItemArray == null) {
            GroupItem.$$$reportNull$$$0(4);
        }
        return componentItemArray;
    }

    public void addItem(@NotNull ComponentItem item) {
        if (item == null) {
            GroupItem.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(!this.myItems.contains(item));
        this.myItems.add(item);
    }

    public void replaceItem(@NotNull ComponentItem itemToBeReplaced, @NotNull ComponentItem replacement) {
        if (itemToBeReplaced == null) {
            GroupItem.$$$reportNull$$$0(6);
        }
        if (replacement == null) {
            GroupItem.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(this.myItems.contains(itemToBeReplaced));
        int index = this.myItems.indexOf(itemToBeReplaced);
        this.myItems.set(index, replacement);
    }

    public void removeItem(@NotNull ComponentItem item) {
        if (item == null) {
            GroupItem.$$$reportNull$$$0(8);
        }
        LOG.assertTrue(this.myItems.contains(item));
        this.myItems.remove(item);
    }

    public boolean contains(ComponentItem item) {
        return this.myItems.contains(item);
    }

    public boolean containsItemClass(@NotNull String className) {
        if (className == null) {
            GroupItem.$$$reportNull$$$0(9);
        }
        for (int i = this.myItems.size() - 1; i >= 0; --i) {
            if (!className.equals(this.myItems.get(i).getClassName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsItemCopy(@NotNull ComponentItem originalItem, String className) {
        if (originalItem == null) {
            GroupItem.$$$reportNull$$$0(10);
        }
        for (int i = this.myItems.size() - 1; i >= 0; --i) {
            if (!className.equals(this.myItems.get(i).getClassName()) || originalItem == this.myItems.get(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public ActionGroup getPopupActionGroup() {
        return (ActionGroup)ActionManager.getInstance().getAction("GuiDesigner.PaletteGroupPopupMenu");
    }

    @Override
    @Nullable
    public Object getData(Project project, String dataId) {
        if (dataId.equals(this.getClass().getName())) {
            return this;
        }
        return null;
    }

    @Override
    public void handleDrop(Project project, PaletteItem droppedItem, int index) {
        if (droppedItem instanceof ComponentItem) {
            ComponentItem componentItem = (ComponentItem)droppedItem;
            Palette palette = Palette.getInstance(project);
            int oldIndex = this.myItems.indexOf(componentItem);
            if (oldIndex >= 0) {
                if (index == -1 || oldIndex == index) {
                    return;
                }
                if (oldIndex < index) {
                    --index;
                }
                this.myItems.remove(oldIndex);
            } else {
                for (GroupItem groupItem : palette.getGroups()) {
                    if (!groupItem.myItems.contains(componentItem)) continue;
                    groupItem.removeItem(componentItem);
                    break;
                }
            }
            if (index == -1) {
                this.myItems.add(componentItem);
            } else {
                this.myItems.add(index, componentItem);
            }
            palette.fireGroupsChanged();
        }
    }

    public String toString() {
        return this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/palette/GroupItem";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemToBeReplaced";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/palette/GroupItem";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addItem";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceItem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeItem";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsItemClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "containsItemCopy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

